<?php
/**
 * Single Project.
 */
$apeix_large_image =  wp_get_attachment_image_src( get_post_thumbnail_id(get_the_ID()), 'fullsize', false, '' );
$apeix_large_image = $apeix_large_image[0];
$image_alt = get_post_meta( $apeix_large_image, '_wp_attachment_image_alt', true);
$project_options = get_post_meta( get_the_ID(), 'project_options', true );
$project_infotitle = isset($project_options['project_infotitle']) ? $project_options['project_infotitle'] : '';
$project_infos = isset($project_options['project_infos']) ? $project_options['project_infos'] : '';
$project_links = isset($project_options['project_links']) ? $project_options['project_links'] : '';

$apeix_prev_pro = cs_get_option('prev_service');
$apeix_next_pro = cs_get_option('next_servic');
$apeix_prev_pro = ($apeix_prev_pro) ? $apeix_prev_pro : esc_html__('Previous', 'apeix');
$apeix_next_pro = ($apeix_next_pro) ? $apeix_next_pro : esc_html__('Next', 'apeix');
$apeix_prev_post = get_previous_post( '', false);
$apeix_next_post = get_next_post( '', false);

?>
<div class="row">
    <div class="col col-md-8">
        <div class="project-content">
            <div class="img-holder">
                <img src="<?php echo esc_url( $apeix_large_image ); ?>" alt="<?php echo esc_attr( $image_alt ); ?>">
            </div>
            <h2><?php echo get_the_title(); ?></h2>
            <?php the_content();?>
            <div class="prev-next-project">
                <?php if ($apeix_prev_post) { ?>
                <div>
                    <a href="<?php echo esc_url(get_permalink($apeix_prev_post->ID)); ?>">
                        <div class="icon">
                            <i class="ti-arrow-left"></i>
                        </div>
                        <span><?php echo esc_html($apeix_prev_pro); ?></span>
                        <h5><?php echo esc_html($apeix_prev_post->post_title); ?></h5>
                    </a>
                </div>
                <?php } 
                if ($apeix_next_post) { ?>
                <div>
                    <a href="<?php echo esc_url(get_permalink( $apeix_next_post->ID)); ?>">
                        <div class="icon">
                            <i class="ti-arrow-right"></i>
                        </div>
                        <span><?php echo esc_html($apeix_next_pro); ?></span>
                        <h5><?php echo esc_html($apeix_next_post->post_title); ?></h5>
                    </a>
                </div>
                 <?php } ?>
            </div>
        </div>
    </div>
    <div class="col col-md-4">
        <div class="service-sidebar">
            <div class="widget project-info-widget">
                <h3><?php echo esc_html( $project_infotitle ); ?></h3>
                <ul>
                  <?php foreach ( $project_infos as $key => $project_info ) { ?>
                   <li>
                    <span><?php echo esc_html( $project_info['title'] ); ?></span> 
                    <?php echo esc_html( $project_info['desc'] ); ?>
                  </li>
                  <?php } ?>
                </ul>
            </div>
        </div>
    </div>
</div>