<?php
/**
 * Single Post.
 */
$apeix_large_image =  wp_get_attachment_image_src( get_post_thumbnail_id(get_the_ID()), 'fullsize', false, '' );
$apeix_large_image = $apeix_large_image ? $apeix_large_image[0] : '';
$image_alt = get_post_meta( $apeix_large_image, '_wp_attachment_image_alt', true);
$apeix_post_type = get_post_meta( get_the_ID(), 'post_type_metabox', true );
// Single Theme Option
$apeix_post_pagination_option = cs_get_option('single_post_pagination');
$apeix_single_featured_image = cs_get_option('single_featured_image');
$apeix_single_author_info = cs_get_option('single_author_info');
$apeix_single_share_option = cs_get_option('single_share_option');
$apeix_metas_hide = (array) cs_get_option( 'theme_metas_hide' );
?>
  <div <?php post_class('post clearfix'); ?>>
  	<?php if ( $apeix_large_image ) { ?>
  	  <div class="entry-media">
        <img src="<?php echo esc_url( $apeix_large_image ); ?>" alt="<?php echo esc_attr( $image_alt ); ?>">
   		</div>
  	<?php	} ?>
    <ul class="entry-meta">
       <li>
		   <i class="ti-user"></i>
           <?php if ( !in_array( 'author', $apeix_metas_hide ) ) { // Author Hide
              printf(
              '<a href="%1$s" rel="author">%2$s</a>',
              esc_url( get_author_posts_url( get_the_author_meta( 'ID' ) ) ), get_the_author()
              );
          } ?>
        </li>
        <li>
		 <i class="ti-timer"></i>
          <a href="<?php echo esc_url( get_permalink() ); ?>"><?php echo esc_html( get_the_date() );  ?></a></li>
        <li>
			<i class="ti-comment"></i>
           <a class="apeix-comment" href="<?php echo esc_url( get_comments_link() ); ?>">
            <?php printf( esc_html( _nx( 'Comments (%1$s)', 'Comments (%1$s)', get_comments_number(), 'comments title', 'apeix' ) ), '<span class="comment">'.number_format_i18n( get_comments_number() ).'</span>','<span>' . get_the_title() . '</span>' ); ?>
          </a>
        </li>
    </ul>
    <div class="entry-details">
	     <?php
				the_content();
				echo apeix_wp_link_pages();
			 ?>
    </div>
</div>
<?php if( has_tag() || ( $apeix_single_share_option && function_exists('apeix_wp_share_option') ) ) { ?>
<div class="tag-share">
  <?php if( has_tag() ) { ?>
     <div class="tag">
          <?php
            echo '<span>'.esc_html__('Tags:','apeix').'</span>';
            $tag_list = get_the_tags();
            if($tag_list) {
              echo the_tags( ' <ul><li>', '</li><li>', '</li></ul>' );
           } ?>
      </div>
    <?php } 
  		if ( $apeix_single_share_option && function_exists('apeix_wp_share_option') ) {
  					echo apeix_wp_share_option();
  			}
  	 ?>
</div>
<?php
}
if( !$apeix_single_author_info ) {
	apeix_author_info();
	}
 if( !$apeix_post_pagination_option ){
		apeix_single_pagination();
} ?>

