<?php
/**
 * Template part for displaying posts.
 */
// Metabox
$apeix_id    = ( isset( $post ) ) ? $post->ID : 0;
$apeix_id    = ( is_home() ) ? get_option( 'page_for_posts' ) : $apeix_id;
$apeix_id    = ( is_woocommerce_shop() ) ? wc_get_page_id( 'shop' ) : $apeix_id;
$apeix_meta  = get_post_meta( $apeix_id, 'page_type_metabox', true );
$apeix_large_image =  wp_get_attachment_image_src( get_post_thumbnail_id(get_the_ID()), 'fullsize', false, '' );
$apeix_alt = get_post_meta($apeix_large_image, '_wp_attachment_image_alt', true);
$apeix_read_more_text = cs_get_option('read_more_text');
$apeix_read_text = $apeix_read_more_text ? $apeix_read_more_text : esc_html__( 'Read More', 'apeix' );
$apeix_post_type = get_post_meta( get_the_ID(), 'post_type_metabox', true );
$apeix_metas_hide = (array) cs_get_option( 'theme_metas_hide' );
  // Sticky
$post_class = get_post_class();
$find_sticky = array_search( 'sticky', $post_class );

if ( 'gallery' == get_post_format() && ! empty( $apeix_post_type['gallery_post_format'] ) ) {
  $post_format_class = ' slider-post';
  $quote_output = '';
} elseif ( 'video' == get_post_format() && ! empty( $apeix_post_type['video_post_format'] ) ) {
  $post_format_class = ' video-post';
  $quote_output = '';
}  elseif ( 'quote' == get_post_format() && ! empty( $apeix_post_type['quote_post_format'] ) ) {
  $post_format_class = ' quote-post';
  $post_format_class = ' <div class="quote-icon"><i class="ti-quote-right"></i></div>';
} else {
  $post_format_class = ' ';
  $quote_output = '';
}
?>
 <div <?php post_class('post'.$post_format_class); ?>>
  <?php
    if ( $find_sticky ) {
        echo '<div class="sticky-badge"><h2>Featured</h2></div>';
    }
    if ( 'gallery' == get_post_format() && ! empty( $apeix_post_type['gallery_post_format'] ) ) { ?>
    <div class="entry-media post-slider"
        data-nav="true"
        data-autoplay="true"
        data-auto-height="true"
        data-dots="true">
    <?php
      $apeix_ids = explode( ',', $apeix_post_type['gallery_post_format'] );
      foreach ( $apeix_ids as $id ) {
        $apeix_attachment = wp_get_attachment_image_src( $id, 'full' );
        $apeix_alt = get_post_meta($id, '_wp_attachment_image_alt', true);
        echo '<img src="'. $apeix_attachment[0] .'" alt="'. esc_attr( $apeix_alt ) .'" />';
      }
    ?>
   </div>
  <?php } elseif ( 'video' == get_post_format() && ! empty( $apeix_post_type['video_post_format'] ) ) { ?>
    <div class="entry-media video-holder">
        <img src="<?php echo esc_url( $apeix_large_image[0] ); ?>" alt="<?php echo esc_attr( $apeix_alt ); ?>">
        <a href="<?php echo esc_url( $apeix_post_type['video_post_format'] ); ?>?autoplay=1" class="video-btn" data-type="iframe">
            <i class="fi flaticon-video-player"></i>
        </a>
    </div>
   <?php }  elseif ( 'quote' == get_post_format() ) { ?>
      <div class="quote-icon"></div>
    <?php } elseif ( $apeix_large_image ) { ?>
    <div class="entry-media">
        <img src="<?php echo esc_url( $apeix_large_image[0] ); ?>" alt="<?php echo esc_attr( $apeix_alt ); ?>">
    </div>
    <?php } ?>
    <ul class="entry-meta">
        <li>
		  <i class="ti-user"></i>
           <?php if ( !in_array( 'author', $apeix_metas_hide ) ) { // Author Hide
              printf(
              '<a href="%1$s" rel="author">%2$s</a>',
              esc_url( get_author_posts_url( get_the_author_meta( 'ID' ) ) ), get_the_author()
              );
          } ?>
        </li>
        <li>
		  <i class="ti-timer"></i>
          <a href="<?php echo esc_url( get_permalink() ); ?>"><?php echo esc_html( get_the_date() );  ?></a></li>
        <li>
			<i class="ti-comment"></i>
           <a class="apeix-comment" href="<?php echo esc_url( get_comments_link() ); ?>">
            <?php printf( esc_html( _nx( 'Comments (%1$s)', 'Comments (%1$s)', get_comments_number(), 'comments title', 'apeix' ) ), '<span class="comment">'.number_format_i18n( get_comments_number() ).'</span>','<span>' . get_the_title() . '</span>' ); ?>
          </a>
        </li>
    </ul>
     <h3><a href="<?php echo esc_url( get_permalink() ); ?>"><?php echo get_the_title(); ?></a></h3>
    <div class="entry-details">
      <p><?php
            $blog_excerpt = cs_get_option('theme_blog_excerpt');
            if ($blog_excerpt) {
              $blog_excerpt = $blog_excerpt;
            } else {
              $blog_excerpt = '25';
            }
            if(apeix_excerpt($blog_excerpt)) {
              apeix_excerpt($blog_excerpt);
            } else {
               echo wp_trim_words( get_the_content(), 35);
            }
            echo apeix_wp_link_pages();
        ?></p>
      <a href="<?php echo esc_url( get_permalink() ); ?>" class="more">
        <?php echo esc_attr($apeix_read_text); ?>
      </a>
    </div>
</div>
