<?php
	// Metabox
	$apeix_id    = ( isset( $post ) ) ? $post->ID : 0;
	$apeix_id    = ( is_home() ) ? get_option( 'page_for_posts' ) : $apeix_id;
	$apeix_id    = ( is_woocommerce_shop() ) ? wc_get_page_id( 'shop' ) : $apeix_id;
	$apeix_meta  = get_post_meta( $apeix_id, 'page_type_metabox', true );
	if ($apeix_meta && is_page()) {
		$apeix_title_bar_padding = $apeix_meta['title_area_spacings'];
	} else { $apeix_title_bar_padding = ''; }
	// Padding - Theme Options
	if ($apeix_title_bar_padding && $apeix_title_bar_padding !== 'padding-default') {
		$apeix_title_top_spacings = $apeix_meta['title_top_spacings'];
		$apeix_title_bottom_spacings = $apeix_meta['title_bottom_spacings'];
		if ($apeix_title_bar_padding === 'padding-custom') {
			$apeix_title_top_spacings = $apeix_title_top_spacings ? 'padding-top:'. apeix_check_px($apeix_title_top_spacings) .';' : '';
			$apeix_title_bottom_spacings = $apeix_title_bottom_spacings ? 'padding-bottom:'. apeix_check_px($apeix_title_bottom_spacings) .';' : '';
			$apeix_custom_padding = $apeix_title_top_spacings . $apeix_title_bottom_spacings;
		} else {
			$apeix_custom_padding = '';
		}
	} else {
		$apeix_title_bar_padding = cs_get_option('title_bar_padding');
		$apeix_titlebar_top_padding = cs_get_option('titlebar_top_padding');
		$apeix_titlebar_bottom_padding = cs_get_option('titlebar_bottom_padding');
		if ($apeix_title_bar_padding === 'padding-custom') {
			$apeix_titlebar_top_padding = $apeix_titlebar_top_padding ? 'padding-top:'. apeix_check_px($apeix_titlebar_top_padding) .';' : '';
			$apeix_titlebar_bottom_padding = $apeix_titlebar_bottom_padding ? 'padding-bottom:'. apeix_check_px($apeix_titlebar_bottom_padding) .';' : '';
			$apeix_custom_padding = $apeix_titlebar_top_padding . $apeix_titlebar_bottom_padding;
		} else {
			$apeix_custom_padding = '';
		}
	}
	// Banner Type - Meta Box
	if ($apeix_meta && is_page()) {
		$apeix_banner_type = $apeix_meta['banner_type'];
	} else { $apeix_banner_type = ''; }
	// Header Style
	if ($apeix_meta) {
	  $apeix_header_design  = $apeix_meta['select_header_design'];
	  $apeix_hide_breadcrumbs  = $apeix_meta['hide_breadcrumbs'];
	} else {
	  $apeix_header_design  = cs_get_option('select_header_design');
	  $apeix_hide_breadcrumbs = cs_get_option('need_breadcrumbs');
	}
	if ( $apeix_header_design === 'default') {
	  $apeix_header_design_actual  = cs_get_option('select_header_design');
	} else {
	  $apeix_header_design_actual = ( $apeix_header_design ) ? $apeix_header_design : cs_get_option('select_header_design');
	}
	if ( $apeix_header_design_actual == 'style_three') {
		$overly_class = ' overly';
	} else {
		$overly_class = ' ';
	}
	// Overlay Color - Theme Options
		if ($apeix_meta && is_page()) {
			$apeix_bg_overlay_color = $apeix_meta['titlebar_bg_overlay_color'];
			$title_color = isset($apeix_meta['title_color']) ? $apeix_meta['title_color'] : '';
		} else { $apeix_bg_overlay_color = ''; }
		if (!empty($apeix_bg_overlay_color)) {
			$apeix_bg_overlay_color = $apeix_bg_overlay_color;
			$title_color = $title_color;
		} else {
			$apeix_bg_overlay_color = cs_get_option('titlebar_bg_overlay_color');
			$title_color = cs_get_option('title_color');
		}
		$e_uniqid        = uniqid();
		$inline_style  = '';
		if ( $apeix_bg_overlay_color ) {
		 $inline_style .= '.page-title-'.$e_uniqid .'.page-title {';
		 $inline_style .= ( $apeix_bg_overlay_color ) ? 'background-color:'. $apeix_bg_overlay_color.';' : '';
		 $inline_style .= '}';
		}
		if ( $title_color ) {
		 $inline_style .= '.page-title-'.$e_uniqid .'.page-title h2, .page-title-'.$e_uniqid .'.page-title .breadcrumb li, .page-title-'.$e_uniqid .'.page-title .breadcrumbs ul li a {';
		 $inline_style .= ( $title_color ) ? 'color:'. $title_color.';' : '';
		 $inline_style .= '}';
		}
		// add inline style
		add_inline_style( $inline_style );
		$styled_class  = ' page-title-'.$e_uniqid;
	// Background - Type
	if( $apeix_meta ) {
		$title_bar_bg = $apeix_meta['title_area_bg'];
	} else {
		$title_bar_bg = '';
	}
	$apeix_custom_header = get_custom_header();
	$header_text_color = get_theme_mod( 'header_textcolor' );
	$background_color = get_theme_mod( 'background_color' );
	if( isset( $title_bar_bg['image'] ) && ( $title_bar_bg['image'] ||  $title_bar_bg['color'] ) ) {
	  extract( $title_bar_bg );
	  $apeix_background_image       = ( ! empty( $image ) ) ? 'background-image: url(' . esc_url($image) . ');' : '';
	  $apeix_background_repeat      = ( ! empty( $image ) && ! empty( $repeat ) ) ? ' background-repeat: ' . esc_attr( $repeat) . ';' : '';
	  $apeix_background_position    = ( ! empty( $image ) && ! empty( $position ) ) ? ' background-position: ' . esc_attr($position) . ';' : '';
	  $apeix_background_size    = ( ! empty( $image ) && ! empty( $size ) ) ? ' background-size: ' . esc_attr($size) . ';' : '';
	  $apeix_background_attachment    = ( ! empty( $image ) && ! empty( $size ) ) ? ' background-attachment: ' . esc_attr( $attachment ) . ';' : '';
	  $apeix_background_color       = ( ! empty( $color ) ) ? ' background-color: ' . esc_attr( $color ) . ';' : '';
	  $apeix_background_style       = ( ! empty( $image ) ) ? $apeix_background_image . $apeix_background_repeat . $apeix_background_position . $apeix_background_size . $apeix_background_attachment : '';
	  $apeix_title_bg = ( ! empty( $apeix_background_style ) || ! empty( $apeix_background_color ) ) ? $apeix_background_style . $apeix_background_color : '';
	} elseif( $apeix_custom_header->url ) {
		$apeix_title_bg = 'background-image:  url('. esc_url( $apeix_custom_header->url ) .');';
	} else {
		$apeix_title_bg = '';
	}
	if($apeix_banner_type === 'hide-title-area') { // Hide Title Area
	} elseif($apeix_meta && $apeix_banner_type === 'revolution-slider') { // Hide Title Area
		echo do_shortcode($apeix_meta['page_revslider']);
	} else {
	?>
 <!-- start page-title -->
  <section class="page-title <?php echo esc_attr( $overly_class.$styled_class.' '.$apeix_banner_type ); ?>" style="<?php echo esc_attr( $apeix_title_bg ); ?>">
      <div class="container">
          <div class="row">
              <div class="col col-xs-12" style="<?php echo esc_attr( $apeix_custom_padding ); ?>" >
                  <div class="title">
                      <h2><?php echo apeix_title_area(); ?></h2>
                  </div>
                   <?php if ( !$apeix_hide_breadcrumbs && function_exists( 'breadcrumb_trail' )) { breadcrumb_trail();  } ?>
              </div>
          </div> <!-- end row -->
      </div> <!-- end container -->
  </section>
  <!-- end page-title -->
<?php } ?>