<?php
  // Metabox
  $apeix_id    = ( isset( $post ) ) ? $post->ID : 0;
  $apeix_id    = ( is_home() ) ? get_option( 'page_for_posts' ) : $apeix_id;
  $apeix_id    = ( is_woocommerce_shop() ) ? wc_get_page_id( 'shop' ) : $apeix_id;
  $apeix_id    = ( ! is_tag() && ! is_archive() && ! is_search() && ! is_404() && ! is_singular('testimonial') ) ? $apeix_id : false;
  $apeix_meta  = get_post_meta( $apeix_id, 'page_type_metabox', true );

  // Header Style
  if ( $apeix_meta ) {
    $apeix_header_design  = $apeix_meta['select_header_design'];
    $apeix_sticky_header = isset( $apeix_meta['sticky_header'] ) ? $apeix_meta['sticky_header'] : '' ;
    $apeix_search = isset( $apeix_meta['apeix_search'] ) ? $apeix_meta['apeix_search'] : '';
  } else {
    $apeix_header_design  = cs_get_option( 'select_header_design' );
    $apeix_sticky_header  = cs_get_option( 'sticky_header' );
    $apeix_search  = cs_get_option( 'apeix_search' );
  }

  $apeix_cart_widget  = cs_get_option( 'apeix_cart_widget' );

  if ( $apeix_header_design === 'default' ) {
    $apeix_header_design_actual  = cs_get_option( 'select_header_design' );
  } else {
    $apeix_header_design_actual = ( $apeix_header_design ) ? $apeix_header_design : cs_get_option('select_header_design');
  }
  $apeix_header_design_actual = $apeix_header_design_actual ? $apeix_header_design_actual : 'style_three';

  if ( $apeix_meta && $apeix_header_design !== 'default') {
   $apeix_search = isset( $apeix_meta['apeix_search'] ) ? $apeix_meta['apeix_search'] : '';
  } else {
    $apeix_search  = cs_get_option( 'apeix_search' );
  }

  if ( $apeix_header_design_actual == 'style_two'  ) {
    $nav_right = '';
    $container_class = 'container-fluid';
  } else {
    $nav_right = '  navbar-right ';
    $container_class = 'container';
  }
  if ( $apeix_cart_widget ) {
   $cart_class = ' has-cart ';
  } else {
    $cart_class = ' not-has-cart ';
  }
  if ( $apeix_search ) {
   $search_class = ' not-has-search ';
  } else {
    $search_class = ' has-search ';
  }
  if ( has_nav_menu( 'primary' ) ) {
     $menu_padding = ' has-menu ';
  } else {
     $menu_padding = ' dont-has-menu ';
  }
  if ($apeix_meta) {
    $apeix_choose_menu = $apeix_meta['choose_menu'];
  } else { $apeix_choose_menu = ''; }
  $apeix_choose_menu = $apeix_choose_menu ? $apeix_choose_menu : '';

?>
<!-- Navigation & Search -->
 <div class="<?php echo esc_attr( $container_class ); ?>">
      <div class="navbar-header">
          <button type="button" class="open-btn">
              <span class="sr-only"><?php echo esc_html__( 'Toggle navigation','apeix' ) ?></span>
              <span class="icon-bar"></span>
              <span class="icon-bar"></span>
              <span class="icon-bar"></span>
          </button>
          <?php get_template_part( 'theme-layouts/header/logo' ); ?>
      </div>
    <div id="navbar" class="navbar-collapse collapse navigation-holder <?php echo esc_attr( $menu_padding.$cart_class.$search_class ); ?>">
     <button class="close-navbar"><i class="ti-close"></i></button>
       <?php
          wp_nav_menu(
            array(
              'menu'              => 'primary',
              'theme_location'    => 'primary',
              'container'         => '',
              'container_class'   => '',
              'container_id'      => '',
              'menu'              => $apeix_choose_menu,
              'menu_class'        => 'nav navbar-nav',
              'fallback_cb'       => '__return_false',
            )
          );
        ?>
      </div><!-- end of nav-collapse -->
      <?php get_template_part( 'theme-layouts/header/search','bar' ); ?>
  </div><!-- end of container -->


