<?php
// Metabox
global $post;
$apeix_id    = ( isset( $post ) ) ? $post->ID : false;
$apeix_id    = ( is_home() ) ? get_option( 'page_for_posts' ) : $apeix_id;
$apeix_id    = ( is_woocommerce_shop() ) ? wc_get_page_id( 'shop' ) : $apeix_id;
$apeix_id    = ( ! is_tag() && ! is_archive() && ! is_search() && ! is_404() && ! is_singular('service') ) ? $apeix_id : false;
$apeix_meta  = get_post_meta( $apeix_id, 'page_type_metabox', true );
// Header Style
if ( $apeix_meta ) {
  $apeix_header_design  = $apeix_meta['select_header_design'];
} else {
  $apeix_header_design  = cs_get_option( 'select_header_design' );
}

if ( $apeix_header_design === 'default' ) {
  $apeix_header_design_actual  = cs_get_option( 'select_header_design' );
} else {
  $apeix_header_design_actual = ( $apeix_header_design ) ? $apeix_header_design : cs_get_option('select_header_design');
}
$apeix_header_design_actual = $apeix_header_design_actual ? $apeix_header_design_actual : 'style_three';

$apeix_logo = cs_get_option( 'apeix_logo' );
$apeix_trlogo = cs_get_option( 'apeix_trlogo' );
$logo_url = wp_get_attachment_url( $apeix_logo );
$logo_alt = get_post_meta( $apeix_logo, '_wp_attachment_image_alt', true );
$trlogo_url = wp_get_attachment_url( $apeix_trlogo );
$trlogo_alt = get_post_meta( $apeix_trlogo, '_wp_attachment_image_alt', true );

if ( $logo_url ) {
  $logo_url = $logo_url;
} else {
 $logo_url = APEIX_IMAGES.'/logo.png';
}

if ( $trlogo_url ) {
  $trlogo_url = $trlogo_url;
} else {
 $trlogo_url = APEIX_IMAGES.'/tr-logo.png';
}

if ( $apeix_header_design_actual == 'style_three' ) {
  $apeix_logo_url = $logo_url;
  $apeix_logo_alt = $logo_alt;
} else {
  $apeix_logo_url = $trlogo_url;
  $apeix_logo_alt = $trlogo_alt;
}

if ( has_nav_menu( 'primary' ) ) {
  $logo_padding = ' has_menu ';
}
else {
   $logo_padding = ' dont_has_menu ';
}


// Logo Spacings
// Logo Spacings
$apeix_brand_logo_top = cs_get_option( 'apeix_logo_top' );
$apeix_brand_logo_bottom = cs_get_option( 'apeix_logo_bottom' );
if ( $apeix_brand_logo_top ) {
  $apeix_brand_logo_top = 'padding-top:'. apeix_check_px( $apeix_brand_logo_top ) .';';
} else { $apeix_brand_logo_top = ''; }
if ( $apeix_brand_logo_bottom ) {
  $apeix_brand_logo_bottom = 'padding-bottom:'. apeix_check_px( $apeix_brand_logo_bottom ) .';';
} else { $apeix_brand_logo_bottom = ''; }
?>
<div class="site-logo <?php echo esc_attr( $logo_padding ); ?>"  style="<?php echo esc_attr( $apeix_brand_logo_top ); echo esc_attr( $apeix_brand_logo_bottom ); ?>">
   <?php if ( $apeix_logo ) {
    ?>
      <a class="navbar-brand" href="<?php echo esc_url( home_url( '/' ) ); ?>">
       <img src="<?php echo esc_url( $apeix_logo_url ); ?>" alt=" <?php echo esc_attr( $apeix_logo_alt ); ?>">
     </a>
   <?php } elseif( has_custom_logo() ) {
      the_custom_logo();
    } else {
    ?>
    <a class="navbar-brand" href="<?php echo esc_url( home_url( '/' ) ); ?>">
       <img src="<?php echo esc_url( $apeix_logo_url ); ?>" alt="<?php echo get_bloginfo('name'); ?>">
     </a>
   <?php
  } ?>
</div>