<?php
/*
 * The template for displaying all single posts.
 * Author & Copyright: wpoceans
 * URL: http://themeforest.net/user/wpoceans
 */
	get_header();
	// Metabox
	$apeix_id    = ( isset( $post ) ) ? $post->ID : 0;
	$apeix_id    = ( is_home() ) ? get_option( 'page_for_posts' ) : $apeix_id;
	$apeix_id    = ( is_woocommerce_shop() ) ? wc_get_page_id( 'shop' ) : $apeix_id;
	$apeix_meta  = get_post_meta( $apeix_id, 'page_type_metabox', true );
	if ( $apeix_meta ) {
		$apeix_content_padding = $apeix_meta['content_spacings'];
	} else { $apeix_content_padding = ''; }
	// Padding - Metabox
	if ( $apeix_content_padding && $apeix_content_padding !== 'padding-default' ) {
		$apeix_content_top_spacings = $apeix_meta['content_top_spacings'];
		$apeix_content_bottom_spacings = $apeix_meta['content_bottom_spacings'];
		if ( $apeix_content_padding === 'padding-custom' ) {
			$apeix_content_top_spacings = $apeix_content_top_spacings ? 'padding-top:'. apeix_check_px($apeix_content_top_spacings) .';' : '';
			$apeix_content_bottom_spacings = $apeix_content_bottom_spacings ? 'padding-bottom:'. apeix_check_px($apeix_content_bottom_spacings) .';' : '';
			$apeix_custom_padding = $apeix_content_top_spacings . $apeix_content_bottom_spacings;
		} else {
			$apeix_custom_padding = '';
		}
	} else {
		$apeix_custom_padding = '';
	}
	// Theme Options
	$apeix_single_comment = cs_get_option( 'single_comment_form' );
	$apeix_sidebar_position = cs_get_option( 'blog_sidebar_position' );
	$apeix_sidebar_position = $apeix_sidebar_position ?$apeix_sidebar_position : 'sidebar-right';
	$apeix_blog_widget = cs_get_option( 'blog_widget' );
	$apeix_blog_widget = $apeix_blog_widget ? $apeix_blog_widget : 'sidebar-1';

	$apeix_sidebar_position = $apeix_sidebar_position ? $apeix_sidebar_position : 'sidebar-right';

	// Sidebar Position
	if ( $apeix_sidebar_position === 'sidebar-hide' ) {
		$layout_class = 'col-md-12';
		$apeix_sidebar_class = 'hide-sidebar';
	} elseif ( $apeix_sidebar_position === 'sidebar-left' && is_active_sidebar( $apeix_blog_widget ) ) {
		$layout_class = 'col-md-9 col-md-push-3';
		$apeix_sidebar_class = 'left-sidebar';
	} elseif( is_active_sidebar( $apeix_blog_widget ) ) {
		$layout_class = 'col-md-9';
		$apeix_sidebar_class = 'right-sidebar';
	} else {
		$layout_class = 'col-md-12';
		$apeix_sidebar_class = 'hide-sidebar';
	}
?>
<div class="blog-single-section section-padding <?php echo esc_attr( $apeix_content_padding .' '. $apeix_sidebar_class ); ?>" style="<?php echo esc_attr( $apeix_custom_padding ); ?>">
	<div class="container content-area ">
		<div class="row">
			<div class="single-content-wrap <?php echo esc_attr( $layout_class ); ?>">
				<div class="blog-content">
					<?php
					if ( have_posts() ) :
						/* Start the Loop */
						while ( have_posts() ) : the_post();
							if ( post_password_required() ) {
									echo '<div class="password-form">'.get_the_password_form().'</div>';
								} else {
									get_template_part( 'theme-layouts/post/content', 'single' );
									$apeix_single_comment = !$apeix_single_comment ? comments_template() : '';

								}
						endwhile;
					else :
						get_template_part( 'theme-layouts/post/content', 'none' );
					endif; ?>
				</div><!-- Blog Div -->
				<?php
		    wp_reset_postdata(); ?>
			</div><!-- Content Area -->
			<?php
				if ( $apeix_sidebar_position !== 'sidebar-hide' && is_active_sidebar( $apeix_blog_widget ) ) {
					get_sidebar(); // Sidebar
			} ?>
		</div>
	</div>
</div>
<?php
get_footer();