<?php
/*
 * The template for displaying all pages.
 * Author & Copyright: wpoceans
 * URL: http://themeforest.net/user/wpoceans
 */
$apeix_id    = ( isset( $post ) ) ? $post->ID : 0;
$apeix_id    = ( is_home() ) ? get_option( 'page_for_posts' ) : $apeix_id;
$apeix_meta  = get_post_meta( $apeix_id, 'page_type_metabox', true );
if ( $apeix_meta ) {
	$apeix_content_padding = $apeix_meta['content_spacings'];
} else { $apeix_content_padding = 'section-padding'; }
// Top and Bottom Padding
if ( $apeix_content_padding && $apeix_content_padding !== 'padding-default' ) {
	$apeix_content_top_spacings = isset( $apeix_meta['content_top_spacings'] ) ? $apeix_meta['content_top_spacings'] : '';
	$apeix_content_bottom_spacings = isset( $apeix_meta['content_bottom_spacings'] ) ? $apeix_meta['content_bottom_spacings'] : '';
	if ( $apeix_content_padding === 'padding-custom' ) {
		$apeix_content_top_spacings = $apeix_content_top_spacings ? 'padding-top:'. apeix_check_px( $apeix_content_top_spacings ) .';' : '';
		$apeix_content_bottom_spacings = $apeix_content_bottom_spacings ? 'padding-bottom:'. apeix_check_px($apeix_content_bottom_spacings) .';' : '';
		$apeix_custom_padding = $apeix_content_top_spacings . $apeix_content_bottom_spacings;
	} else {
		$apeix_custom_padding = '';
	}
	$padding_class = '';
} else {
	$apeix_custom_padding = '';
	$padding_class = '';
}

// Page Layout
$page_layout_options = get_post_meta( get_the_ID(), 'page_layout_options', true );
if ( $page_layout_options ) {
	$apeix_page_layout = $page_layout_options['page_layout'];
	$page_sidebar_widget = $page_layout_options['page_sidebar_widget'];
} else {
	$apeix_page_layout = 'right-sidebar';
	$page_sidebar_widget = '';
}
$page_sidebar_widget = $page_sidebar_widget ? $page_sidebar_widget : 'sidebar-1';
if ( $apeix_page_layout === 'extra-width' ) {
	$apeix_page_column = 'extra-width';
	$apeix_page_container = 'container-fluid';
} elseif ( $apeix_page_layout === 'full-width' ) {
	$apeix_page_column = 'col-md-12';
	$apeix_page_container = 'container ';
} elseif( ( $apeix_page_layout === 'left-sidebar' || $apeix_page_layout === 'right-sidebar' ) && is_active_sidebar( $page_sidebar_widget ) ) {
	if( $apeix_page_layout === 'left-sidebar' ){
		$apeix_page_column = 'col-md-9 order-12';
	} else {
		$apeix_page_column = 'col-md-9';
	}
	$apeix_page_container = 'container ';
} else {
	$apeix_page_column = 'col-md-12';
	$apeix_page_container = 'container ';
}
$apeix_theme_page_comments = cs_get_option( 'theme_page_comments' );
get_header();
?>
<div class="page-wrap <?php echo esc_attr( $padding_class ); ?>">
	<div class="<?php echo esc_attr( $apeix_page_container.''.$apeix_content_padding.' '.$apeix_page_layout ); ?>" style="<?php echo esc_attr( $apeix_custom_padding ); ?>">
		<div class="row">
			<div class="<?php echo esc_attr( $apeix_page_column ); ?>">
				<div class="page-wraper page-content clearfix">
				<?php
				while ( have_posts() ) : the_post();
					the_content();
					if ( !$apeix_theme_page_comments && ( comments_open() || get_comments_number() ) ) :
						comments_template();
					endif;
				endwhile; // End of the loop.
				?>
				</div>
				<div class="page-link-wrap">
					<?php apeix_wp_link_pages(); ?>
				</div>
			</div>
			<?php
			// Sidebar
			if( ($apeix_page_layout === 'left-sidebar' || $apeix_page_layout === 'right-sidebar') && is_active_sidebar( $page_sidebar_widget )  ) {
				get_sidebar();
			}
			?>
		</div>
	</div>
</div>
<?php
get_footer();