<?php
/*
 * All Theme Options for Apeix theme.
 * Author & Copyright:wpoceans
 * URL: http://themeforest.net/user/wpoceans
 */

function apeix_settings( $settings ) {

  $settings           = array(
    'menu_title'      => APEIX_NAME . esc_html__(' Options', 'apeix'),
    'menu_slug'       => sanitize_title(APEIX_NAME) . '_options',
    'menu_type'       => 'theme',
    'menu_icon'       => 'dashicons-awards',
    'menu_position'   => '4',
    'ajax_save'       => false,
    'show_reset_all'  => true,
    'framework_title' => APEIX_NAME .' <small>V-'. APEIX_VERSION .' by <a href="'. APEIX_BRAND_URL .'" target="_blank">'. APEIX_BRAND_NAME .'</a></small>',
  );

  return $settings;

}
add_filter( 'cs_framework_settings', 'apeix_settings' );

// Theme Framework Options
function apeix_options( $options ) {

  $options      = array(); // remove old options

  // ------------------------------
  // Branding
  // ------------------------------
  $options[]   = array(
    'name'     => 'apeix_theme_branding',
    'title'    => esc_html__('Site Brand', 'apeix'),
    'icon'     => 'fa fa-cog',
    'sections' => array(

      // brand logo tab
      array(
        'name'     => 'brand_logo',
        'title'    => esc_html__('Logo', 'apeix'),
        'icon'     => 'fa fa-star',
        'fields'   => array(

          // Site Logo
          array(
            'type'    => 'notice',
            'class'   => 'info cs-apeix-heading',
            'content' => esc_html__('Site Logo', 'apeix')
          ),
          array(
            'id'    => 'apeix_logo',
            'type'  => 'image',
            'title' => esc_html__('Default Logo', 'apeix'),
            'info'  => esc_html__('Upload your default logo here. If you not upload, then site title will load in this logo location.', 'apeix'),
            'add_title' => esc_html__('Add Logo', 'apeix'),
          ),
          array(
            'id'    => 'apeix_trlogo',
            'type'  => 'image',
            'title' => esc_html__('Transparent Logo', 'apeix'),
            'info'  => esc_html__('Upload your Transparent logo here. If you not upload, then site title will load in this logo location.', 'apeix'),
            'add_title' => esc_html__('Add Logo', 'apeix'),
          ),
          array(
            'id'          => 'apeix_logo_top',
            'type'        => 'number',
            'title'       => esc_html__('Logo Top Space', 'apeix'),
            'attributes'  => array( 'placeholder' => 5 ),
            'unit'        => 'px',
          ),
          array(
            'id'          => 'apeix_logo_bottom',
            'type'        => 'number',
            'title'       => esc_html__('Logo Bottom Space', 'apeix'),
            'attributes'  => array( 'placeholder' => 5 ),
            'unit'        => 'px',
          ),
          // WordPress Admin Logo
          array(
            'type'    => 'notice',
            'class'   => 'info cs-apeix-heading',
            'content' => esc_html__('WordPress Admin Logo', 'apeix')
          ),
          array(
            'id'    => 'brand_logo_wp',
            'type'  => 'image',
            'title' => esc_html__('Login logo', 'apeix'),
            'info'  => esc_html__('Upload your WordPress login page logo here.', 'apeix'),
            'add_title' => esc_html__('Add Login Logo', 'apeix'),
          ),
        ) // end: fields
      ), // end: section
    ),
  );

  // ------------------------------
  // Layout
  // ------------------------------
  $options[] = array(
    'name'   => 'theme_layout',
    'title'  => esc_html__('Theme Layout', 'apeix'),
    'icon'   => 'fa fa-folder-open-o'
  );

  $options[]      = array(
    'name'        => 'theme_general',
    'title'       => esc_html__('General Settings', 'apeix'),
    'icon'        => 'fa fa-sliders',

    // begin: fields
    'fields'      => array(

      // -----------------------------
      // Begin: Responsive
      // -----------------------------
       array(
        'id'    => 'theme_responsive',
        'off_text'  => 'No',
        'on_text'  => 'Yes',
        'type'  => 'switcher',
        'title' => esc_html__('Responsive', 'apeix'),
        'info' => esc_html__('Turn on if you don\'t want your site to be responsive.', 'apeix'),
        'default' => false,
      ),
      array(
        'id'    => 'theme_preloder',
        'off_text'  => 'No',
        'on_text'  => 'Yes',
        'type'  => 'switcher',
        'title' => esc_html__('Preloder', 'apeix'),
        'info' => esc_html__('Turn off if you don\'t want your site to be Preloder.', 'apeix'),
        'default' => true,
      ),
      array(
        'id'    => 'theme_layout_width',
        'type'  => 'image_select',
        'title' => esc_html__('Full Width & Extra Width', 'apeix'),
        'info' => esc_html__('Boxed or Fullwidth? Choose your site layout width. Default : Full Width', 'apeix'),
        'options'      => array(
          'container'    => APEIX_CS_IMAGES .'/boxed-width.jpg',
          'container-fluid'    => APEIX_CS_IMAGES .'/full-width.jpg',
        ),
        'default'      => 'container-fluid',
        'radio'      => true,
      ),
       array(
        'id'    => 'theme_page_comments',
        'type'  => 'switcher',
        'title' => esc_html__('Hide Page Comments?', 'apeix'),
        'label' => esc_html__('Yes! Hide Page Comments.', 'apeix'),
        'on_text' => esc_html__('Yes', 'apeix'),
        'off_text' => esc_html__('No', 'apeix'),
        'default' => false,
      ),
      array(
        'type'    => 'notice',
        'class'   => 'info cs-apeix-heading',
        'content' => esc_html__('Background Options', 'apeix'),
        'dependency' => array( 'theme_layout_width_container', '==', 'true' ),
      ),
      array(
        'id'             => 'theme_layout_bg_type',
        'type'           => 'select',
        'title'          => esc_html__('Background Type', 'apeix'),
        'options'        => array(
          'bg-image' => esc_html__('Image', 'apeix'),
          'bg-pattern' => esc_html__('Pattern', 'apeix'),
        ),
        'dependency' => array( 'theme_layout_width_container', '==', 'true' ),
      ),
      array(
        'id'    => 'theme_layout_bg_pattern',
        'type'  => 'image_select',
        'title' => esc_html__('Background Pattern', 'apeix'),
        'info' => esc_html__('Select background pattern', 'apeix'),
        'options'      => array(
          'pattern-1'    => APEIX_CS_IMAGES . '/pattern-1.png',
          'pattern-2'    => APEIX_CS_IMAGES . '/pattern-2.png',
          'pattern-3'    => APEIX_CS_IMAGES . '/pattern-3.png',
          'pattern-4'    => APEIX_CS_IMAGES . '/pattern-4.png',
          'custom-pattern'  => APEIX_CS_IMAGES . '/pattern-5.png',
        ),
        'default'      => 'pattern-1',
        'radio'      => true,
        'dependency' => array( 'theme_layout_width_container|theme_layout_bg_type', '==|==', 'true|bg-pattern' ),
      ),
      array(
        'id'      => 'custom_bg_pattern',
        'type'    => 'upload',
        'title'   => esc_html__('Custom Pattern', 'apeix'),
        'dependency' => array( 'theme_layout_width_container|theme_layout_bg_type|theme_layout_bg_pattern_custom-pattern', '==|==|==', 'true|bg-pattern|true' ),
        'info' => __('Select your custom background pattern. <br />Note, background pattern image will be repeat in all x and y axis. So, please consider all repeatable area will perfectly fit your custom patterns.', 'apeix'),
      ),
      array(
        'id'      => 'theme_layout_bg',
        'type'    => 'background',
        'title'   => esc_html__('Background', 'apeix'),
        'dependency' => array( 'theme_layout_width_container|theme_layout_bg_type', '==|==', 'true|bg-image' ),
      ),

    ), // end: fields

  );

  // ------------------------------
  // Header Sections
  // ------------------------------
  $options[]   = array(
    'name'     => 'theme_header_tab',
    'title'    => esc_html__('Header Settings', 'apeix'),
    'icon'     => 'fa fa-header',
    'sections' => array(

      // header design tab
      array(
        'name'     => 'header_design_tab',
        'title'    => esc_html__('Design', 'apeix'),
        'icon'     => 'fa fa-magic',
        'fields'   => array(

          // Header Select
          array(
            'id'           => 'select_header_design',
            'type'         => 'image_select',
            'title'        => esc_html__('Select Header Design', 'apeix'),
            'options'      => array(
              'style_one'    => APEIX_CS_IMAGES .'/hs-1.png',
              'style_two'    => APEIX_CS_IMAGES .'/hs-2.png',
              'style_three'    => APEIX_CS_IMAGES .'/hs-3.png',
            ),
            'attributes' => array(
              'data-depend-id' => 'header_design',
            ),
            'radio'        => true,
            'default'   => 'style_three',
            'info' => esc_html__('Select your header design, following options will may differ based on your selection of header design.', 'apeix'),
          ),
          // Header Select

          // Extra's
          array(
            'type'    => 'notice',
            'class'   => 'info cs-apeix-heading',
            'content' => esc_html__('Extra\'s', 'apeix'),
          ),
          array(
            'id'    => 'sticky_header',
            'type'  => 'switcher',
            'title' => esc_html__('Sticky Header', 'apeix'),
            'info' => esc_html__('Turn On if you want your naviagtion bar on sticky.', 'apeix'),
            'default' => true,
          ),
           array(
            'id'    => 'apeix_search',
            'type'  => 'switcher',
            'title' => esc_html__('Header Search', 'apeix'),
            'info' => esc_html__('Turn On if you want to hide Header Search .', 'apeix'),
            'default' => false,
          ),
          array(
            'id'    => 'apeix_cart_widget',
            'type'  => 'switcher',
            'title' => esc_html__('Header Cart', 'apeix'),
            'info' => esc_html__('Turn On if you want to Show Header Cart .', 'apeix'),
            'default' => false,
          ),
        )
      ),

      // header top bar
      array(
        'name'     => 'header_top_bar_tab',
        'title'    => esc_html__('Top Bar', 'apeix'),
        'icon'     => 'fa fa-minus',
        'fields'   => array(

          array(
            'id'          => 'top_bar',
            'type'        => 'switcher',
            'title'       => esc_html__('Hide Top Bar', 'apeix'),
            'on_text'     => esc_html__('Yes', 'apeix'),
            'off_text'    => esc_html__('No', 'apeix'),
            'default'     => true,
          ),
          array(
            'id'          => 'top_left',
            'title'       => esc_html__('Top left Block', 'apeix'),
            'desc'        => esc_html__('Top bar left block.', 'apeix'),
            'type'        => 'textarea',
            'shortcode'   => true,
            'dependency'  => array('top_bar', '==', false),
          ),
          array(
            'id'          => 'top_right',
            'title'       => esc_html__('Top Right Block', 'apeix'),
            'desc'        => esc_html__('Top bar right block.', 'apeix'),
            'type'        => 'textarea',
            'shortcode'   => true,
            'dependency'  => array('top_bar', '==', false),
          ),
        )
      ),

      // header banner
      array(
        'name'     => 'header_banner_tab',
        'title'    => esc_html__('Title Bar (or) Banner', 'apeix'),
        'icon'     => 'fa fa-bullhorn',
        'fields'   => array(

          // Title Area
          array(
            'type'    => 'notice',
            'class'   => 'info cs-apeix-heading',
            'content' => esc_html__('Title Area', 'apeix')
          ),
          array(
            'id'      => 'need_title_bar',
            'type'    => 'switcher',
            'title'   => esc_html__('Title Bar ?', 'apeix'),
            'label'   => esc_html__('If you want to Hide title bar in your sub-pages, please turn this ON.', 'apeix'),
            'default'    => false,
          ),
          array(
            'id'             => 'title_bar_padding',
            'type'           => 'select',
            'title'          => esc_html__('Padding Spaces Top & Bottom', 'apeix'),
            'options'        => array(
              'padding-default' => esc_html__('Default Spacing', 'apeix'),
              'padding-custom' => esc_html__('Custom Padding', 'apeix'),
            ),
            'dependency'   => array( 'need_title_bar', '==', 'false' ),
          ),
          array(
            'id'             => 'titlebar_top_padding',
            'type'           => 'text',
            'title'          => esc_html__('Padding Top', 'apeix'),
            'attributes' => array(
              'placeholder'     => '100px',
            ),
            'dependency'   => array( 'title_bar_padding', '==', 'padding-custom' ),
          ),
          array(
            'id'             => 'titlebar_bottom_padding',
            'type'           => 'text',
            'title'          => esc_html__('Padding Bottom', 'apeix'),
            'attributes' => array(
              'placeholder'     => '100px',
            ),
            'dependency'   => array( 'title_bar_padding', '==', 'padding-custom' ),
          ),

          array(
            'type'    => 'notice',
            'class'   => 'info cs-apeix-heading',
            'content' => esc_html__('Background Options', 'apeix'),
            'dependency' => array( 'need_title_bar', '==', 'false' ),
          ),
          array(
            'id'      => 'titlebar_bg_overlay_color',
            'type'    => 'color_picker',
            'title'   => esc_html__('Overlay Color', 'apeix'),
            'dependency' => array( 'need_title_bar', '==', 'false' ),
          ),
          array(
            'id'    => 'title_color',
            'type'  => 'color_picker',
            'title' => esc_html__('Title Color', 'apeix'),
            'dependency'   => array('banner_type', '==', 'default-title'),
          ),

          array(
            'type'    => 'notice',
            'class'   => 'info cs-apeix-heading',
            'content' => esc_html__('Breadcrumbs', 'apeix'),
          ),
         array(
            'id'      => 'need_breadcrumbs',
            'type'    => 'switcher',
            'title'   => esc_html__('Hide Breadcrumbs', 'apeix'),
            'label'   => esc_html__('If you want to hide breadcrumbs in your banner, please turn this ON.', 'apeix'),
            'default'    => false,
          ),
        )
      ),

    ),
  );

  // ------------------------------
  // Footer Section
  // ------------------------------
  $options[]   = array(
    'name'     => 'footer_section',
    'title'    => esc_html__('Footer Settings', 'apeix'),
    'icon'     => 'fa fa-tasks',
    'sections' => array(

      // footer widgets
      array(
        'name'     => 'footer_widgets_tab',
        'title'    => esc_html__('Widget Area', 'apeix'),
        'icon'     => 'fa fa-th',
        'fields'   => array(

          // Footer Widget Block
          array(
            'type'    => 'notice',
            'class'   => 'info cs-apeix-heading',
            'content' => esc_html__('Footer Widget Block', 'apeix')
          ),
          array(
            'id'    => 'footer_widget_block',
            'type'  => 'switcher',
            'title' => esc_html__('Enable Widget Block', 'apeix'),
            'info' => __('If you turn this ON, then Goto : Appearance > Widgets. There you can see <strong>Footer Widget 1,2,3 or 4</strong> Widget Area, add your widgets there.', 'apeix'),
            'default' => true,
          ),
          array(
            'id'    => 'footer_widget_layout',
            'type'  => 'image_select',
            'title' => esc_html__('Widget Layouts', 'apeix'),
            'info' => esc_html__('Choose your footer widget theme-layouts.', 'apeix'),
            'default' => 4,
            'options' => array(
              1   => APEIX_CS_IMAGES . '/footer/footer-1.png',
              2   => APEIX_CS_IMAGES . '/footer/footer-2.png',
              3   => APEIX_CS_IMAGES . '/footer/footer-3.png',
              4   => APEIX_CS_IMAGES . '/footer/footer-4.png',
              5   => APEIX_CS_IMAGES . '/footer/footer-5.png',
              6   => APEIX_CS_IMAGES . '/footer/footer-6.png',
              7   => APEIX_CS_IMAGES . '/footer/footer-7.png',
              8   => APEIX_CS_IMAGES . '/footer/footer-8.png',
              9   => APEIX_CS_IMAGES . '/footer/footer-9.png',
            ),
            'radio'       => true,
            'dependency'  => array('footer_widget_block', '==', true),
          ),
           array(
            'id'    => 'apeix_ft_bg',
            'type'  => 'image',
            'title' => esc_html__('Footer Background', 'apeix'),
            'info'  => esc_html__('Upload your footer background.', 'apeix'),
            'add_title' => esc_html__('footer background', 'apeix'),
            'dependency'  => array('footer_widget_block', '==', true),
          ),

        )
      ),

      // footer copyright
      array(
        'name'     => 'footer_copyright_tab',
        'title'    => esc_html__('Copyright Bar', 'apeix'),
        'icon'     => 'fa fa-copyright',
        'fields'   => array(

          // Copyright
          array(
            'type'    => 'notice',
            'class'   => 'info cs-apeix-heading',
            'content' => esc_html__('Copyright Layout', 'apeix'),
          ),
         array(
            'id'    => 'hide_copyright',
            'type'  => 'switcher',
            'title' => esc_html__('Hide Copyright?', 'apeix'),
            'default' => false,
            'on_text' => esc_html__('Yes', 'apeix'),
            'off_text' => esc_html__('No', 'apeix'),
            'label' => esc_html__('Yes, do it!', 'apeix'),
          ),
          array(
            'id'    => 'footer_copyright_layout',
            'type'  => 'image_select',
            'title' => esc_html__('Select Copyright Layout', 'apeix'),
            'info' => esc_html__('In above image, blue box is copyright text and yellow box is secondary text.', 'apeix'),
            'default'      => 'copyright-3',
            'options'      => array(
              'copyright-1'    => APEIX_CS_IMAGES .'/footer/copyright-1.png',
              ),
            'radio'        => true,
            'dependency'     => array('hide_copyright', '!=', true),
          ),
          array(
            'id'    => 'copyright_text',
            'type'  => 'textarea',
            'title' => esc_html__('Copyright Text', 'apeix'),
            'shortcode' => true,
            'dependency' => array('hide_copyright', '!=', true),
            'after'       => 'Helpful shortcodes: [current_year] [home_url] or any shortcode.',
          ),

          // Copyright Another Text
          array(
            'type'    => 'notice',
            'class'   => 'warning cs-apeix-heading',
            'content' => esc_html__('Copyright Secondary Text', 'apeix'),
             'dependency'     => array('hide_copyright', '!=', true),
          ),
          array(
            'id'    => 'secondary_text',
            'type'  => 'textarea',
            'title' => esc_html__('Secondary Text', 'apeix'),
            'shortcode' => true,
            'dependency'     => array('hide_copyright', '!=', true),
          ),

        )
      ),

    ),
  );

  // ------------------------------
  // Design
  // ------------------------------
  $options[] = array(
    'name'   => 'theme_design',
    'title'  => esc_html__('Theme Design', 'apeix'),
    'icon'   => 'fa fa-tachometer'
  );

  // ------------------------------
  // color section
  // ------------------------------
  $options[]   = array(
    'name'     => 'theme_color_section',
    'title'    => esc_html__('Colors', 'apeix'),
    'icon'     => 'fa fa-eyedropper',
    'fields' => array(

      array(
        'type'    => 'heading',
        'content' => esc_html__('Color Options', 'apeix'),
      ),
      array(
        'type'    => 'subheading',
        'wrap_class' => 'color-tab-content',
        'content' => esc_html__('All color options are available in our theme customizer. The reason of we used customizer options for color section is because, you can choose each part of color from there and see the changes instantly using customizer. Highly customizable colors are in Appearance > Customize', 'apeix'),
      ),

    ),
  );

  // ------------------------------
  // Typography section
  // ------------------------------
  $options[]   = array(
    'name'     => 'theme_typo_section',
    'title'    => esc_html__('Typography', 'apeix'),
    'icon'     => 'fa fa-header',
    'fields' => array(

      // Start fields
      array(
        'id'                  => 'typography',
        'type'                => 'group',
        'fields'              => array(
          array(
            'id'              => 'title',
            'type'            => 'text',
            'title'           => esc_html__('Title', 'apeix'),
          ),
          array(
            'id'              => 'selector',
            'type'            => 'textarea',
            'title'           => esc_html__('Selector', 'apeix'),
            'info'           => wp_kses( __('Enter css selectors like : <strong>body, .custom-class</strong>', 'apeix'), array( 'strong' => array() ) ),
          ),
          array(
            'id'              => 'font',
            'type'            => 'typography',
            'title'           => esc_html__('Font Family', 'apeix'),
          ),
          array(
            'id'              => 'size',
            'type'            => 'text',
            'title'           => esc_html__('Font Size', 'apeix'),
          ),
          array(
            'id'              => 'line_height',
            'type'            => 'text',
            'title'           => esc_html__('Line-Height', 'apeix'),
          ),
          array(
            'id'              => 'css',
            'type'            => 'textarea',
            'title'           => esc_html__('Custom CSS', 'apeix'),
          ),
        ),
        'button_title'        => esc_html__('Add New Typography', 'apeix'),
        'accordion_title'     => esc_html__('New Typography', 'apeix'),
      ),

      // Subset
      array(
        'id'                  => 'subsets',
        'type'                => 'select',
        'title'               => esc_html__('Subsets', 'apeix'),
        'class'               => 'chosen',
        'options'             => array(
          'latin'             => 'latin',
          'latin-ext'         => 'latin-ext',
          'cyrillic'          => 'cyrillic',
          'cyrillic-ext'      => 'cyrillic-ext',
          'greek'             => 'greek',
          'greek-ext'         => 'greek-ext',
          'vietnamese'        => 'vietnamese',
          'devanagari'        => 'devanagari',
          'khmer'             => 'khmer',
        ),
        'attributes'         => array(
          'data-placeholder' => 'Subsets',
          'multiple'         => 'multiple',
          'style'            => 'width: 200px;'
        ),
        'default'             => array( 'latin' ),
      ),

      array(
        'id'                  => 'font_weight',
        'type'                => 'select',
        'title'               => esc_html__('Font Weights', 'apeix'),
        'class'               => 'chosen',
        'options'             => array(
          '100'   => esc_html__('Thin 100', 'apeix'),
          '100i'  => esc_html__('Thin 100 Italic', 'apeix'),
          '200'   => esc_html__('Extra Light 200', 'apeix'),
          '200i'  => esc_html__('Extra Light 200 Italic', 'apeix'),
          '300'   => esc_html__('Light 300', 'apeix'),
          '300i'  => esc_html__('Light 300 Italic', 'apeix'),
          '400'   => esc_html__('Regular 400', 'apeix'),
          '400i'  => esc_html__('Regular 400 Italic', 'apeix'),
          '500'   => esc_html__('Medium 500', 'apeix'),
          '500i'  => esc_html__('Medium 500 Italic', 'apeix'),
          '600'   => esc_html__('Semi Bold 600', 'apeix'),
          '600i'  => esc_html__('Semi Bold 600 Italic', 'apeix'),
          '700'   => esc_html__('Bold 700', 'apeix'),
          '700i'  => esc_html__('Bold 700 Italic', 'apeix'),
          '800'   => esc_html__('Extra Bold 800', 'apeix'),
          '800i'  => esc_html__('Extra Bold 800 Italic', 'apeix'),
          '900'   => esc_html__('Black 900', 'apeix'),
          '900i'  => esc_html__('Black 900 Italic', 'apeix'),
        ),
        'attributes'         => array(
          'data-placeholder' => esc_html__('Font Weight', 'apeix'),
          'multiple'         => 'multiple',
          'style'            => 'width: 200px;'
        ),
        'default'             => array( '400' ),
      ),

      // Custom Fonts Upload
      array(
        'id'                 => 'font_family',
        'type'               => 'group',
        'title'              => esc_html__('Upload Custom Fonts', 'apeix'),
        'button_title'       => esc_html__('Add New Custom Font', 'apeix'),
        'accordion_title'    => esc_html__('Adding New Font', 'apeix'),
        'accordion'          => true,
        'desc'               => esc_html__('It is simple. Only add your custom fonts and click to save. After you can check "Font Family" selector. Do not forget to Save!', 'apeix'),
        'fields'             => array(

          array(
            'id'             => 'name',
            'type'           => 'text',
            'title'          => esc_html__('Font-Family Name', 'apeix'),
            'attributes'     => array(
              'placeholder'  => esc_html__('for eg. Arial', 'apeix')
            ),
          ),

          array(
            'id'             => 'ttf',
            'type'           => 'upload',
            'title'          => wp_kses(__('Upload .ttf <small><i>(optional)</i></small>', 'apeix'), array( 'small' => array(), 'i' => array() )),
            'settings'       => array(
              'upload_type'  => 'font',
              'insert_title' => esc_html__('Use this Font-Format', 'apeix'),
              'button_title' => wp_kses(__('Upload <i>.ttf</i>', 'apeix'), array( 'i' => array() )),
            ),
          ),

          array(
            'id'             => 'eot',
            'type'           => 'upload',
            'title'          => wp_kses(__('Upload .eot <small><i>(optional)</i></small>', 'apeix'), array( 'small' => array(), 'i' => array() )),
            'settings'       => array(
              'upload_type'  => 'font',
              'insert_title' => esc_html__('Use this Font-Format', 'apeix'),
              'button_title' => wp_kses(__('Upload <i>.eot</i>', 'apeix'), array( 'i' => array() )),
            ),
          ),

          array(
            'id'             => 'otf',
            'type'           => 'upload',
            'title'          => wp_kses(__('Upload .otf <small><i>(optional)</i></small>', 'apeix'), array( 'small' => array(), 'i' => array() )),
            'settings'       => array(
              'upload_type'  => 'font',
              'insert_title' => esc_html__('Use this Font-Format', 'apeix'),
              'button_title' => wp_kses(__('Upload <i>.otf</i>', 'apeix'), array( 'i' => array() )),
            ),
          ),

          array(
            'id'             => 'woff',
            'type'           => 'upload',
            'title'          => wp_kses(__('Upload .woff <small><i>(optional)</i></small>', 'apeix'), array( 'small' => array(), 'i' => array() )),
            'settings'       => array(
              'upload_type'  => 'font',
              'insert_title' => esc_html__('Use this Font-Format', 'apeix'),
              'button_title' =>wp_kses(__('Upload <i>.woff</i>', 'apeix'), array( 'i' => array() )),
            ),
          ),

          array(
            'id'             => 'css',
            'type'           => 'textarea',
            'title'          => wp_kses(__('Extra CSS Style <small><i>(optional)</i></small>', 'apeix'), array( 'small' => array(), 'i' => array() )),
            'attributes'     => array(
              'placeholder'  => esc_html__('for eg. font-weight: normal;', 'apeix'),
            ),
          ),

        ),
      ),
      // End All field

    ),
  );

  // ------------------------------
  // Pages
  // ------------------------------
  $options[] = array(
    'name'   => 'theme_pages',
    'title'  => esc_html__('Pages', 'apeix'),
    'icon'   => 'fa fa-files-o'
  );

  // ------------------------------
  // Service Section
  // ------------------------------
  $options[]   = array(
    'name'     => 'service_section',
    'title'    => esc_html__('Service', 'apeix'),
    'icon'     => 'fa fa-th-list',
    'fields' => array(

      // Team Start
      array(
        'type'    => 'notice',
        'class'   => 'info cs-apeix-heading',
        'content' => esc_html__('Service Single', 'apeix')
      ),
      array(
          'id'             => 'service_sidebar_position',
          'type'           => 'select',
          'title'          => esc_html__('Sidebar Position', 'apeix'),
          'options'        => array(
            'sidebar-right' => esc_html__('Right', 'apeix'),
            'sidebar-left' => esc_html__('Left', 'apeix'),
            'sidebar-hide' => esc_html__('Hide', 'apeix'),
          ),
          'default_option' => 'Select sidebar position',
          'info'          => esc_html__('Default option : Right', 'apeix'),
        ),
        array(
          'id'             => 'single_service_widget',
          'type'           => 'select',
          'title'          => esc_html__('Sidebar Widget', 'apeix'),
          'options'        => apeix_registered_sidebars(),
          'default_option' => esc_html__('Select Widget', 'apeix'),
          'dependency'     => array('service_sidebar_position', '!=', 'sidebar-hide'),
          'info'          => esc_html__('Default option : Main Widget Area', 'apeix'),
        ),
        array(
          'id'    => 'service_comment_form',
          'type'  => 'switcher',
          'title' => esc_html__('Comment Area/Form', 'apeix'),
          'info' => esc_html__('If need to hide comment area and that form on single blog page, please turn this OFF.', 'apeix'),
          'default' => true,
        ),
    ),
  );


  // ------------------------------
  // Project Section
  // ------------------------------
  $options[]   = array(
    'name'     => 'project_section',
    'title'    => esc_html__('Project', 'apeix'),
    'icon'     => 'fa fa-medkit',
    'fields' => array(

      // Team Start
      array(
        'type'    => 'notice',
        'class'   => 'info cs-apeix-heading',
        'content' => esc_html__('Project Single', 'apeix')
      ),
      array(
          'id'             => 'project_sidebar_position',
          'type'           => 'select',
          'title'          => esc_html__('Sidebar Position', 'apeix'),
          'options'        => array(
            'sidebar-right' => esc_html__('Right', 'apeix'),
            'sidebar-left' => esc_html__('Left', 'apeix'),
            'sidebar-hide' => esc_html__('Hide', 'apeix'),
          ),
          'default_option' => 'Select sidebar position',
          'info'          => esc_html__('Default option : Right', 'apeix'),
        ),
        array(
          'id'             => 'single_project_widget',
          'type'           => 'select',
          'title'          => esc_html__('Sidebar Widget', 'apeix'),
          'options'        => apeix_registered_sidebars(),
          'default_option' => esc_html__('Select Widget', 'apeix'),
          'dependency'     => array('project_sidebar_position', '!=', 'sidebar-hide'),
          'info'          => esc_html__('Default option : Main Widget Area', 'apeix'),
        ),
        array(
          'id'    => 'project_comment_form',
          'type'  => 'switcher',
          'title' => esc_html__('Comment Area/Form', 'apeix'),
          'info' => esc_html__('If need to hide comment area and that form on single blog page, please turn this OFF.', 'apeix'),
          'default' => true,
        ),
    ),
  );

  // ------------------------------
  // Blog Section
  // ------------------------------
  $options[]   = array(
    'name'     => 'blog_section',
    'title'    => esc_html__('Blog', 'apeix'),
    'icon'     => 'fa fa-newspaper-o',
    'sections' => array(

      // blog general section
      array(
        'name'     => 'blog_general_tab',
        'title'    => esc_html__('General', 'apeix'),
        'icon'     => 'fa fa-cog',
        'fields'   => array(

          // Layout
          array(
            'type'    => 'notice',
            'class'   => 'info cs-apeix-heading',
            'content' => esc_html__('Layout', 'apeix')
          ),
          array(
            'id'             => 'blog_sidebar_position',
            'type'           => 'select',
            'title'          => esc_html__('Sidebar Position', 'apeix'),
            'options'        => array(
              'sidebar-right' => esc_html__('Right', 'apeix'),
              'sidebar-left' => esc_html__('Left', 'apeix'),
              'sidebar-hide' => esc_html__('Hide', 'apeix'),
            ),
            'default_option' => 'Select sidebar position',
            'help'          => esc_html__('This style will apply, default blog pages - Like : Archive, Category, Tags, Search & Author.', 'apeix'),
            'info'          => esc_html__('Default option : Right', 'apeix'),
          ),
          array(
            'id'             => 'blog_widget',
            'type'           => 'select',
            'title'          => esc_html__('Sidebar Widget', 'apeix'),
            'options'        => apeix_registered_sidebars(),
            'default_option' => esc_html__('Select Widget', 'apeix'),
            'dependency'     => array('blog_sidebar_position', '!=', 'sidebar-hide'),
            'info'          => esc_html__('Default option : Main Widget Area', 'apeix'),
          ),
          // Layout
          // Global Options
          array(
            'type'    => 'notice',
            'class'   => 'info cs-apeix-heading',
            'content' => esc_html__('Global Options', 'apeix')
          ),
          array(
            'id'         => 'theme_exclude_categories',
            'type'       => 'checkbox',
            'title'      => esc_html__('Exclude Categories', 'apeix'),
            'info'      => esc_html__('Select categories you want to exclude from blog page.', 'apeix'),
            'options'    => 'categories',
          ),
          array(
            'id'      => 'theme_blog_excerpt',
            'type'    => 'text',
            'title'   => esc_html__('Excerpt Length', 'apeix'),
            'info'   => esc_html__('Blog short content length, in blog listing pages.', 'apeix'),
            'default' => '55',
          ),
          array(
            'id'      => 'theme_metas_hide',
            'type'    => 'checkbox',
            'title'   => esc_html__('Meta\'s to hide', 'apeix'),
            'info'    => esc_html__('Check items you want to hide from blog/post meta field.', 'apeix'),
            'class'      => 'horizontal',
            'options'    => array(
              'category'   => esc_html__('Category', 'apeix'),
              'date'    => esc_html__('Date', 'apeix'),
              'author'     => esc_html__('Author', 'apeix'),
              'comments'      => esc_html__('Comments', 'apeix'),
            ),
            // 'default' => '30',
          ),
          // End fields

        )
      ),

      // blog single section
      array(
        'name'     => 'blog_single_tab',
        'title'    => esc_html__('Single', 'apeix'),
        'icon'     => 'fa fa-sticky-note',
        'fields'   => array(

          // Start fields
          array(
            'type'    => 'notice',
            'class'   => 'info cs-apeix-heading',
            'content' => esc_html__('Enable / Disable', 'apeix')
          ),
          array(
            'id'    => 'single_featured_image',
            'type'  => 'switcher',
            'title' => esc_html__('Featured Image', 'apeix'),
            'info' => esc_html__('If need to hide featured image from single blog post page, please turn this OFF.', 'apeix'),
            'default' => true,
          ),
           array(
            'id'    => 'single_author_info',
            'type'  => 'switcher',
            'title' => esc_html__('Author Info', 'apeix'),
            'info' => esc_html__('If need to hide author info on single blog page, please turn this On.', 'apeix'),
            'default' => false,
          ),
          array(
            'id'    => 'single_share_option',
            'type'  => 'switcher',
            'title' => esc_html__('Share Option', 'apeix'),
            'info' => esc_html__('If need to hide share option on single blog page, please turn this OFF.', 'apeix'),
            'default' => true,
          ),
          array(
            'id'    => 'single_comment_form',
            'type'  => 'switcher',
            'title' => esc_html__('Comment Area/Form ?', 'apeix'),
            'info' => esc_html__('If need to hide comment area and that form on single blog page, please turn this On.', 'apeix'),
            'default' => false,
          ),
          array(
            'type'    => 'notice',
            'class'   => 'info cs-apeix-heading',
            'content' => esc_html__('Sidebar', 'apeix')
          ),
          array(
            'id'             => 'single_sidebar_position',
            'type'           => 'select',
            'title'          => esc_html__('Sidebar Position', 'apeix'),
            'options'        => array(
              'sidebar-right' => esc_html__('Right', 'apeix'),
              'sidebar-left' => esc_html__('Left', 'apeix'),
              'sidebar-hide' => esc_html__('Hide', 'apeix'),
            ),
            'default_option' => 'Select sidebar position',
            'info'          => esc_html__('Default option : Right', 'apeix'),
          ),
          array(
            'id'             => 'single_blog_widget',
            'type'           => 'select',
            'title'          => esc_html__('Sidebar Widget', 'apeix'),
            'options'        => apeix_registered_sidebars(),
            'default_option' => esc_html__('Select Widget', 'apeix'),
            'dependency'     => array('single_sidebar_position', '!=', 'sidebar-hide'),
            'info'          => esc_html__('Default option : Main Widget Area', 'apeix'),
          ),
          // End fields

        )
      ),

    ),
  );

if (class_exists( 'WooCommerce' )){
  // ------------------------------
  // WooCommerce Section
  // ------------------------------
  $options[]   = array(
    'name'     => 'woocommerce_section',
    'title'    => esc_html__('WooCommerce', 'apeix'),
    'icon'     => 'fa fa-shopping-basket',
    'fields' => array(

      // Start fields
      array(
        'type'    => 'notice',
        'class'   => 'info cs-apeix-heading',
        'content' => esc_html__('Layout', 'apeix')
      ),
     array(
        'id'             => 'woo_product_columns',
        'type'           => 'select',
        'title'          => esc_html__('Product Column', 'apeix'),
        'options'        => array(
          2 => esc_html__('Two Column', 'apeix'),
          3 => esc_html__('Three Column', 'apeix'),
          4 => esc_html__('Four Column', 'apeix'),
        ),
        'default_option' => esc_html__('Select Product Columns', 'apeix'),
        'help'          => esc_html__('This style will apply, default woocommerce shop and archive pages.', 'apeix'),
      ),
      array(
        'id'             => 'woo_sidebar_position',
        'type'           => 'select',
        'title'          => esc_html__('Sidebar Position', 'apeix'),
        'options'        => array(
          'right-sidebar' => esc_html__('Right', 'apeix'),
          'left-sidebar' => esc_html__('Left', 'apeix'),
          'sidebar-hide' => esc_html__('Hide', 'apeix'),
        ),
        'default_option' => esc_html__('Select sidebar position', 'apeix'),
        'info'          => esc_html__('Default option : Right', 'apeix'),
      ),
      array(
        'id'             => 'woo_widget',
        'type'           => 'select',
        'title'          => esc_html__('Sidebar Widget', 'apeix'),
        'options'        => apeix_registered_sidebars(),
        'default_option' => esc_html__('Select Widget', 'apeix'),
        'dependency'     => array('woo_sidebar_position', '!=', 'sidebar-hide'),
        'info'          => esc_html__('Default option : Shop Page', 'apeix'),
      ),

      array(
        'type'    => 'notice',
        'class'   => 'info cs-apeix-heading',
        'content' => esc_html__('Listing', 'apeix')
      ),
      array(
        'id'      => 'theme_woo_limit',
        'type'    => 'text',
        'title'   => esc_html__('Product Limit', 'apeix'),
        'info'   => esc_html__('Enter the number value for per page products limit.', 'apeix'),
      ),
      // End fields

      // Start fields
      array(
        'type'    => 'notice',
        'class'   => 'info cs-apeix-heading',
        'content' => esc_html__('Single Product', 'apeix')
      ),
      array(
        'id'             => 'woo_related_limit',
        'type'           => 'text',
        'title'          => esc_html__('Related Products Limit', 'apeix'),
      ),
      array(
        'id'    => 'woo_single_upsell',
        'type'  => 'switcher',
        'title' => esc_html__('You May Also Like', 'apeix'),
        'info' => esc_html__('If you don\'t want \'You May Also Like\' products in single product page, please turn this ON.', 'apeix'),
        'default' => false,
      ),
      array(
        'id'    => 'woo_single_related',
        'type'  => 'switcher',
        'title' => esc_html__('Related Products', 'apeix'),
        'info' => esc_html__('If you don\'t want \'Related Products\' in single product page, please turn this ON.', 'apeix'),
        'default' => false,
      ),
      // End fields

    ),
  );
}

  // ------------------------------
  // Extra Pages
  // ------------------------------
  $options[]   = array(
    'name'     => 'theme_extra_pages',
    'title'    => esc_html__('404 & Maintenance', 'apeix'),
    'icon'     => 'fa fa-clone',
    'sections' => array(

      // error 404 page
      array(
        'name'     => 'error_page_section',
        'title'    => esc_html__('404 Page', 'apeix'),
        'icon'     => 'fa fa-exclamation-triangle',
        'fields'   => array(

          // Start 404 Page
          array(
            'id'    => 'error_heading',
            'type'  => 'text',
            'title' => esc_html__('404 Page Heading', 'apeix'),
            'info'  => esc_html__('Enter 404 page heading.', 'apeix'),
          ),
          array(
            'id'    => 'error_subheading',
            'type'  => 'textarea',
            'title' => esc_html__('404 Page Sub Heading', 'apeix'),
            'info'  => esc_html__('Enter 404 page Sub heading.', 'apeix'),
          ),
          array(
            'id'    => 'error_page_content',
            'type'  => 'textarea',
            'title' => esc_html__('404 Page Content', 'apeix'),
            'info'  => esc_html__('Enter 404 page content.', 'apeix'),
            'shortcode' => true,
          ),
          array(
            'id'    => 'error_page_bg',
            'type'  => 'image',
            'title' => esc_html__('404 Page Background', 'apeix'),
            'info'  => esc_html__('Choose 404 page background styles.', 'apeix'),
            'add_title' => esc_html__('Add 404 Image', 'apeix'),
          ),
          array(
            'id'    => 'error_btn_text',
            'type'  => 'text',
            'title' => esc_html__('Button Text', 'apeix'),
            'info'  => esc_html__('Enter BACK TO HOME button text. If you want to change it.', 'apeix'),
          ),
          // End 404 Page

        ) // end: fields
      ), // end: fields section

      // maintenance mode page
      array(
        'name'     => 'maintenance_mode_section',
        'title'    => esc_html__('Maintenance Mode', 'apeix'),
        'icon'     => 'fa fa-hourglass-half',
        'fields'   => array(

          // Start Maintenance Mode
          array(
            'type'    => 'notice',
            'class'   => 'info cs-apeix-heading',
            'content' => esc_html__('If you turn this ON : Only Logged in users will see your pages. All other visiters will see, selected page of : <strong>Maintenance Mode Page</strong>', 'apeix')
          ),
          array(
            'id'             => 'enable_maintenance_mode',
            'type'           => 'switcher',
            'title'          => esc_html__('Maintenance Mode', 'apeix'),
            'default'        => false,
          ),
          array(
            'id'             => 'maintenance_mode_page',
            'type'           => 'select',
            'title'          => esc_html__('Maintenance Mode Page', 'apeix'),
            'options'        => 'pages',
            'default_option' => esc_html__('Select a page', 'apeix'),
            'dependency'   => array( 'enable_maintenance_mode', '==', 'true' ),
          ),
          array(
            'id'             => 'maintenance_mode_title',
            'type'           => 'text',
            'title'          => esc_html__('Maintenance Mode Text', 'apeix'),
          ),
          array(
            'id'             => 'maintenance_mode_text',
            'type'           => 'textarea',
            'title'          => esc_html__('Maintenance Mode Text', 'apeix'),
          ),
          array(
            'id'             => 'maintenance_mode_bg',
            'type'           => 'background',
            'title'          => esc_html__('Page Background', 'apeix'),
            'dependency'   => array( 'enable_maintenance_mode', '==', 'true' ),
          ),
          // End Maintenance Mode

        ) // end: fields
      ), // end: fields section

    )
  );

  // ------------------------------
  // Advanced
  // ------------------------------
  $options[] = array(
    'name'   => 'theme_advanced',
    'title'  => esc_html__('Advanced', 'apeix'),
    'icon'   => 'fa fa-cog'
  );

  // ------------------------------
  // Misc Section
  // ------------------------------
  $options[]   = array(
    'name'     => 'misc_section',
    'title'    => esc_html__('Miscellaneous', 'apeix'),
    'icon'     => 'fa fa-recycle',
    'sections' => array(

      // custom sidebar section
      array(
        'name'     => 'custom_sidebar_section',
        'title'    => esc_html__('Custom Sidebar', 'apeix'),
        'icon'     => 'fa fa-reorder',
        'fields'   => array(

          // start fields
          array(
            'id'              => 'custom_sidebar',
            'title'           => esc_html__('Sidebars', 'apeix'),
            'desc'            => esc_html__('Go to Appearance -> Widgets after create sidebars', 'apeix'),
            'type'            => 'group',
            'fields'          => array(
              array(
                'id'          => 'sidebar_name',
                'type'        => 'text',
                'title'       => esc_html__('Sidebar Name', 'apeix'),
              ),
              array(
                'id'          => 'sidebar_desc',
                'type'        => 'text',
                'title'       => esc_html__('Custom Description', 'apeix'),
              )
            ),
            'accordion'       => true,
            'button_title'    => esc_html__('Add New Sidebar', 'apeix'),
            'accordion_title' => esc_html__('New Sidebar', 'apeix'),
          ),
          // end fields

        )
      ),
      // custom sidebar section

      // Custom CSS/JS
      array(
        'name'        => 'custom_css_js_section',
        'title'       => esc_html__('Custom Codes', 'apeix'),
        'icon'        => 'fa fa-code',

        // begin: fields
        'fields'      => array(
          // Start Custom CSS/JS
          array(
            'type'    => 'notice',
            'class'   => 'info cs-apeix-heading',
            'content' => esc_html__('Custom JS', 'apeix')
          ),
          array(
            'id'             => 'theme_custom_js',
            'type'           => 'textarea',
            'attributes' => array(
              'rows'     => 10,
              'placeholder'     => esc_html__('Enter your JS code here...', 'apeix'),
            ),
          ),
          // End Custom CSS/JS

        ) // end: fields
      ),

      // Translation
      array(
        'name'        => 'theme_translation_section',
        'title'       => esc_html__('Translation', 'apeix'),
        'icon'        => 'fa fa-language',

        // begin: fields
        'fields'      => array(

          // Start Translation
          array(
            'type'    => 'notice',
            'class'   => 'info cs-apeix-heading',
            'content' => esc_html__('Common Texts', 'apeix')
          ),
          array(
            'id'          => 'read_more_text',
            'type'        => 'text',
            'title'       => esc_html__('Read More Text', 'apeix'),
          ),
          array(
            'id'          => 'view_more_text',
            'type'        => 'text',
            'title'       => esc_html__('View More Text', 'apeix'),
          ),
          array(
            'id'          => 'share_text',
            'type'        => 'text',
            'title'       => esc_html__('Share Text', 'apeix'),
          ),
          array(
            'id'          => 'share_on_text',
            'type'        => 'text',
            'title'       => esc_html__('Share On Tooltip Text', 'apeix'),
          ),
          array(
            'id'          => 'author_text',
            'type'        => 'text',
            'title'       => esc_html__('Author Text', 'apeix'),
          ),
          array(
            'id'          => 'post_comment_text',
            'type'        => 'text',
            'title'       => esc_html__('Post Comment Text [Submit Button]', 'apeix'),
          ),
          array(
            'type'    => 'notice',
            'class'   => 'info cs-apeix-heading',
            'content' => esc_html__('WooCommerce', 'apeix')
          ),
          array(
            'id'          => 'add_to_cart_text',
            'type'        => 'text',
            'title'       => esc_html__('Add to Cart Text', 'apeix'),
          ),
          array(
            'id'          => 'details_text',
            'type'        => 'text',
            'title'       => esc_html__('Details Text', 'apeix'),
          ),

          array(
            'type'    => 'notice',
            'class'   => 'info cs-apeix-heading',
            'content' => esc_html__('Pagination', 'apeix')
          ),
          array(
            'id'          => 'older_post',
            'type'        => 'text',
            'title'       => esc_html__('Older Posts Text', 'apeix'),
          ),
          array(
            'id'          => 'newer_post',
            'type'        => 'text',
            'title'       => esc_html__('Newer Posts Text', 'apeix'),
          ),

          array(
            'type'    => 'notice',
            'class'   => 'info cs-apeix-heading',
            'content' => esc_html__('Single Portfolio Pagination', 'apeix')
          ),
          array(
            'id'          => 'prev_port',
            'type'        => 'text',
            'title'       => esc_html__('Prev Case Text', 'apeix'),
          ),
          array(
            'id'          => 'next_port',
            'type'        => 'text',
            'title'       => esc_html__('Next Case Text', 'apeix'),
          ),
          // End Translation

        ) // end: fields
      ),

    ),
  );

  
  // ------------------------------
  // backup                       -
  // ------------------------------
  $options[]   = array(
    'name'     => 'backup_section',
    'title'    => 'Backup',
    'icon'     => 'fa fa-shield',
    'fields'   => array(

      array(
        'type'    => 'notice',
        'class'   => 'warning',
        'content' => esc_html__('You can save your current options. Download a Backup and Import.', 'apeix'),
      ),

      array(
        'type'    => 'backup',
      ),

    )
  );

  return $options;

}
add_filter( 'cs_framework_options', 'apeix_options' );