<?php
/*
 * All Metabox related options for Apeix theme.
 * Author & Copyright:wpoceans
 * URL: http://themeforest.net/user/wpoceans
 */

function apeix_metabox_options( $options ) {

 $cf7 = get_posts( 'post_type="wpcf7_contact_form"&numberposts=-1' );
    $contact_forms = array();
    if ( $cf7 ) {
      foreach ( $cf7 as $cform ) {
        $contact_forms[ $cform->ID ] = $cform->post_title;
      }
    } else {
      $contact_forms[ esc_html__( 'No contact forms found', 'apeix' ) ] = 0;
    }
  $options      = array();

  // -----------------------------------------
  // Post Metabox Options                    -
  // -----------------------------------------
  $options[]    = array(
    'id'        => 'post_type_metabox',
    'title'     => esc_html__('Post Options', 'apeix'),
    'post_type' => 'post',
    'context'   => 'normal',
    'priority'  => 'default',
    'sections'  => array(

      // All Post Formats
      array(
        'name'   => 'section_post_formats',
        'fields' => array(

          // Standard, Image
          array(
            'title' => 'Standard Image',
            'type'  => 'subheading',
            'content' => esc_html__('There is no Extra Option for this Post Format!', 'apeix'),
            'wrap_class' => 'apeix-minimal-heading hide-title',
          ),
          // Standard, Image

          // Gallery
          array(
            'type'    => 'notice',
            'title'   => 'Gallery Format',
            'wrap_class' => 'hide-title',
            'class'   => 'info cs-apeix-heading',
            'content' => esc_html__('Gallery Format', 'apeix')
          ),
          array(
            'id'          => 'gallery_post_format',
            'type'        => 'gallery',
            'title'       => esc_html__('Add Gallery', 'apeix'),
            'add_title'   => esc_html__('Add Image(s)', 'apeix'),
            'edit_title'  => esc_html__('Edit Image(s)', 'apeix'),
            'clear_title' => esc_html__('Clear Image(s)', 'apeix'),
          ),
          array(
            'type'    => 'text',
            'title'   => esc_html__('Add Video URL', 'apeix' ),
            'id'   => 'video_post_format',
            'desc' => esc_html__('Add youtube or vimeo video link', 'apeix' ),
            'wrap_class' => 'video_post_format',
          ),
          array(
            'type'    => 'icon',
            'title'   => esc_html__('Add Quote Icon', 'apeix' ),
            'id'   => 'quote_post_format',
            'desc' => esc_html__('Add Quote Icon here', 'apeix' ),
            'wrap_class' => 'quote_post_format',
          ),
          // Gallery

        ),
      ),

    ),
  );

  // -----------------------------------------
  // Page Metabox Options                    -
  // -----------------------------------------
  $options[]    = array(
    'id'        => 'page_type_metabox',
    'title'     => esc_html__('Page Custom Options', 'apeix'),
    'post_type' => array('post', 'page'),
    'context'   => 'normal',
    'priority'  => 'default',
    'sections'  => array(

      // Title Section
      array(
        'name'  => 'page_topbar_section',
        'title' => esc_html__('Top Bar', 'apeix'),
        'icon'  => 'fa fa-minus',

        // Fields Start
        'fields' => array(

          array(
            'id'           => 'topbar_options',
            'type'         => 'image_select',
            'title'        => esc_html__('Topbar', 'apeix'),
            'options'      => array(
              'default'     => APEIX_CS_IMAGES .'/topbar-default.png',
              'custom'      => APEIX_CS_IMAGES .'/topbar-custom.png',
              'hide_topbar' => APEIX_CS_IMAGES .'/topbar-hide.png',
            ),
            'attributes' => array(
              'data-depend-id' => 'hide_topbar_select',
            ),
            'radio'     => true,
            'default'   => 'default',
          ),
          array(
            'id'          => 'top_left',
            'type'        => 'textarea',
            'title'       => esc_html__('Top Left', 'apeix'),
            'dependency'  => array('hide_topbar_select', '==', 'custom'),
            'shortcode'       => true,
          ),
          array(
            'id'          => 'top_right',
            'type'        => 'textarea',
            'title'       => esc_html__('Top Right', 'apeix'),
            'dependency'  => array('hide_topbar_select', '==', 'custom'),
            'shortcode'       => true,
          ),
          array(
            'id'    => 'topbar_bg',
            'type'  => 'color_picker',
            'title' => esc_html__('Topbar Background Color', 'apeix'),
            'dependency'  => array('hide_topbar_select', '==', 'custom'),
          ),
          array(
            'id'    => 'topbar_border',
            'type'  => 'color_picker',
            'title' => esc_html__('Topbar Border Color', 'apeix'),
            'dependency'  => array('hide_topbar_select', '==', 'custom'),
          ),

        ), // End : Fields

      ), // Title Section

      // Header
      array(
        'name'  => 'header_section',
        'title' => esc_html__('Header', 'apeix'),
        'icon'  => 'fa fa-bars',
        'fields' => array(

          array(
            'id'           => 'select_header_design',
            'type'         => 'image_select',
            'title'        => esc_html__('Select Header Design', 'apeix'),
            'options'      => array(
              'default'     => APEIX_CS_IMAGES .'/hs-0.png',
              'style_one'   => APEIX_CS_IMAGES .'/hs-1.png',
              'style_two'   => APEIX_CS_IMAGES .'/hs-2.png',
              'style_three'   => APEIX_CS_IMAGES .'/hs-3.png',
            ),
            'attributes' => array(
              'data-depend-id' => 'header_design',
            ),
            'radio'     => true,
            'default'   => 'default',
            'info'      => esc_html__('Select your header design, following options will may differ based on your selection of header design.', 'apeix'),
          ),
          array(
            'id'    => 'apeix_search',
            'type'  => 'switcher',
            'title' => esc_html__('Header Search', 'apeix'),
            'info' => esc_html__('Turn On if you want to hide Header Search .', 'apeix'),
            'default' => false,
          ),
          array(
            'id'    => 'transparency_header',
            'type'  => 'switcher',
            'title' => esc_html__('Transparent Header', 'apeix'),
            'info' => esc_html__('Use Transparent Method', 'apeix'),
          ),
          array(
            'id'    => 'transparent_menu_color',
            'type'  => 'color_picker',
            'title' => esc_html__('Menu Color', 'apeix'),
            'info' => esc_html__('Pick your menu color. This color will only apply for non-sticky header mode.', 'apeix'),
            'dependency'   => array('transparency_header', '==', 'true'),
          ),
          array(
            'id'    => 'transparent_menu_hover_color',
            'type'  => 'color_picker',
            'title' => esc_html__('Menu Hover Color', 'apeix'),
            'info' => esc_html__('Pick your menu hover color. This color will only apply for non-sticky header mode.', 'apeix'),
            'dependency'   => array('transparency_header', '==', 'true'),
          ),
          array(
            'id'             => 'choose_menu',
            'type'           => 'select',
            'title'          => esc_html__('Choose Menu', 'apeix'),
            'desc'          => esc_html__('Choose custom menus for this page.', 'apeix'),
            'options'        => 'menus',
            'default_option' => esc_html__('Select your menu', 'apeix'),
          ),

          // Enable & Disable
          array(
            'type'    => 'notice',
            'class'   => 'info cs-apeix-heading',
            'content' => esc_html__('Enable & Disable', 'apeix'),
            'dependency' => array('header_design', '!=', 'default'),
          ),
          array(
            'id'    => 'sticky_header',
            'type'  => 'switcher',
            'title' => esc_html__('Sticky Header', 'apeix'),
            'info' => esc_html__('Turn On if you want your naviagtion bar on sticky.', 'apeix'),
            'default' => true,
            'dependency' => array('header_design', '!=', 'default'),
          ),
        ),
      ),
      // Header

      // Banner & Title Area
      array(
        'name'  => 'banner_title_section',
        'title' => esc_html__('Banner & Title Area', 'apeix'),
        'icon'  => 'fa fa-bullhorn',
        'fields' => array(

          array(
            'id'        => 'banner_type',
            'type'      => 'select',
            'title'     => esc_html__('Choose Banner Type', 'apeix'),
            'options'   => array(
              'default-title'    => 'Default Title',
              'revolution-slider' => 'Shortcode [Rev Slider]',
              'hide-title-area'   => 'Hide Title/Banner Area',
            ),
          ),
          array(
            'id'    => 'page_revslider',
            'type'  => 'textarea',
            'title' => esc_html__('Revolution Slider or Any Shortcodes', 'apeix'),
            'desc' => __('Enter any shortcodes that you want to show in this page title area. <br />Eg : Revolution Slider shortcode.', 'apeix'),
            'attributes' => array(
              'placeholder' => esc_html__('Enter your shortcode...', 'apeix'),
            ),
            'dependency'   => array('banner_type', '==', 'revolution-slider'),
          ),
          array(
            'id'    => 'page_custom_title',
            'type'  => 'text',
            'title' => esc_html__('Custom Title', 'apeix'),
            'attributes' => array(
              'placeholder' => esc_html__('Enter your custom title...', 'apeix'),
            ),
            'dependency'   => array('banner_type', '==', 'default-title'),
          ),
          array(
            'id'        => 'title_area_spacings',
            'type'      => 'select',
            'title'     => esc_html__('Title Area Spacings', 'apeix'),
            'options'   => array(
              'padding-default' => esc_html__('Default Spacing', 'apeix'),
              'padding-custom' => esc_html__('Custom Padding', 'apeix'),
            ),
            'dependency'   => array('banner_type', '==', 'default-title'),
          ),
          array(
            'id'    => 'title_top_spacings',
            'type'  => 'text',
            'title' => esc_html__('Top Spacing', 'apeix'),
            'attributes'  => array( 'placeholder' => '100px' ),
            'dependency'  => array('banner_type|title_area_spacings', '==|==', 'default-title|padding-custom'),
          ),
          array(
            'id'    => 'title_bottom_spacings',
            'type'  => 'text',
            'title' => esc_html__('Bottom Spacing', 'apeix'),
            'attributes'  => array( 'placeholder' => '100px' ),
            'dependency'  => array('banner_type|title_area_spacings', '==|==', 'default-title|padding-custom'),
          ),
          array(
            'id'    => 'title_area_bg',
            'type'  => 'background',
            'title' => esc_html__('Background', 'apeix'),
            'dependency'   => array('banner_type', '==', 'default-title'),
          ),
          array(
            'id'    => 'titlebar_bg_overlay_color',
            'type'  => 'color_picker',
            'title' => esc_html__('Overlay Color', 'apeix'),
            'dependency'   => array('banner_type', '==', 'default-title'),
          ),
          array(
            'id'    => 'title_color',
            'type'  => 'color_picker',
            'title' => esc_html__('Title Color', 'apeix'),
            'dependency'   => array('banner_type', '==', 'default-title'),
          ),

        ),
      ),
      // Banner & Title Area

      // Content Section
      array(
        'name'  => 'page_content_options',
        'title' => esc_html__('Content Options', 'apeix'),
        'icon'  => 'fa fa-file',

        'fields' => array(

          array(
            'id'        => 'content_spacings',
            'type'      => 'select',
            'title'     => esc_html__('Content Spacings', 'apeix'),
            'options'   => array(
              'padding-default' => esc_html__('Default Spacing', 'apeix'),
              'padding-custom' => esc_html__('Custom Padding', 'apeix'),
            ),
            'desc' => esc_html__('Content area top and bottom spacings.', 'apeix'),
          ),
          array(
            'id'    => 'content_top_spacings',
            'type'  => 'text',
            'title' => esc_html__('Top Spacing', 'apeix'),
            'attributes'  => array( 'placeholder' => '100px' ),
            'dependency'  => array('content_spacings', '==', 'padding-custom'),
          ),
          array(
            'id'    => 'content_bottom_spacings',
            'type'  => 'text',
            'title' => esc_html__('Bottom Spacing', 'apeix'),
            'attributes'  => array( 'placeholder' => '100px' ),
            'dependency'  => array('content_spacings', '==', 'padding-custom'),
          ),
        ), // End Fields
      ), // Content Section

      // Enable & Disable
      array(
        'name'  => 'hide_show_section',
        'title' => esc_html__('Enable & Disable', 'apeix'),
        'icon'  => 'fa fa-toggle-on',
        'fields' => array(

          array(
            'id'    => 'hide_header',
            'type'  => 'switcher',
            'title' => esc_html__('Hide Header', 'apeix'),
            'label' => esc_html__('Yes, Please do it.', 'apeix'),
          ),
          array(
            'id'    => 'hide_breadcrumbs',
            'type'  => 'switcher',
            'title' => esc_html__('Hide Breadcrumbs', 'apeix'),
            'label' => esc_html__('Yes, Please do it.', 'apeix'),
          ),
          array(
            'id'    => 'hide_footer',
            'type'  => 'switcher',
            'title' => esc_html__('Hide Footer', 'apeix'),
            'label' => esc_html__('Yes, Please do it.', 'apeix'),
          ),
          array(
            'id'    => 'box_style_page',
            'type'  => 'switcher',
            'title' => esc_html__('Box Style', 'apeix'),
            'label' => esc_html__('Yes, Please do it.', 'apeix'),
          ),

        ),
      ),
      // Enable & Disable

    ),
  );

  // -----------------------------------------
  // Page Layout
  // -----------------------------------------
  $options[]    = array(
    'id'        => 'page_layout_options',
    'title'     => esc_html__('Page Layout', 'apeix'),
    'post_type' => 'page',
    'context'   => 'side',
    'priority'  => 'default',
    'sections'  => array(

      array(
        'name'   => 'page_layout_section',
        'fields' => array(

          array(
            'id'        => 'page_layout',
            'type'      => 'image_select',
            'options'   => array(
              'full-width'    => APEIX_CS_IMAGES . '/page-1.png',
              'extra-width'   => APEIX_CS_IMAGES . '/page-2.png',
              'left-sidebar'  => APEIX_CS_IMAGES . '/page-3.png',
              'right-sidebar' => APEIX_CS_IMAGES . '/page-4.png',
            ),
            'attributes' => array(
              'data-depend-id' => 'page_layout',
            ),
            'default'    => 'full-width',
            'radio'      => true,
            'wrap_class' => 'text-center',
          ),
          array(
            'id'            => 'page_sidebar_widget',
            'type'           => 'select',
            'title'          => esc_html__('Sidebar Widget', 'apeix'),
            'options'        => apeix_registered_sidebars(),
            'default_option' => esc_html__('Select Widget', 'apeix'),
            'dependency'   => array('page_layout', 'any', 'left-sidebar,right-sidebar'),
          ),

        ),
      ),

    ),
  );


  // -----------------------------------------
  // Service
  // -----------------------------------------
  $options[]    = array(
    'id'        => 'service_options',
    'title'     => esc_html__('Service Extra Options', 'apeix'),
    'post_type' => 'service',
    'context'   => 'side',
    'priority'  => 'default',
    'sections'  => array(

      array(
        'name'   => 'service_option_section',
        'fields' => array(
         array(
            'id'    => 'service_title',
            'type'  => 'text',
            'title' => esc_html__('Service Title', 'apeix'),
            'info'    => esc_html__('Enter Service Title for Service Item.', 'apeix'),
          ),
         array(
            'id'    => 'service_icon',
            'type'  => 'icon',
            'title' => esc_html__('Service icon', 'apeix'),
            'info'    => esc_html__('Enter Service icon for Service Item.', 'apeix'),
          ),
        ),
      ),

    ),
  );

  // -----------------------------------------
  // Project
  // -----------------------------------------
  $options[]    = array(
    'id'        => 'project_options',
    'title'     => esc_html__('Project Extra Options', 'apeix'),
    'post_type' => 'project',
    'context'   => 'side',
    'priority'  => 'default',
    'sections'  => array(

      array(
        'name'   => 'project_option_section',
        'fields' => array(
          array(
            'id'           => 'project_title',
            'type'         => 'text',
            'title'        => esc_html__('Project title', 'apeix'),
            'add_title' => esc_html__('Add Project title', 'apeix'),
            'attributes' => array(
              'placeholder' => esc_html__('Project Title', 'apeix'),
            ),
            'info'    => esc_html__('Write Project Title.', 'apeix'),
          ),
          array(
            'id'      => 'project_subtitle',
            'type'    => 'text',
            'attributes' => array(
              'placeholder' => esc_html__('Project : Sub Title', 'apeix'),
            ),
            'info'    => esc_html__('Write Project Sub Title.', 'apeix'),
          ),
          array(
            'id'           => 'project_image',
            'type'         => 'image',
            'title'        => esc_html__('Project Grid Image', 'apeix'),
            'add_title' => esc_html__('Add Project Grid Image', 'apeix'),
          ),
          
           array(
            'id'      => 'project_infotitle',
            'type'    => 'text',
            'attributes' => array(
              'placeholder' => esc_html__('Project : Info Title', 'apeix'),
            ),
            'info'    => esc_html__('Write Project Info Title.', 'apeix'),
          ),
        // Start fields
          array(
            'id'                  => 'project_infos',
            'title'   => esc_html__('Project Info', 'apeix'),
            'type'                => 'group',
            'fields'              => array(
              array(
                'id'              => 'title',
                'type'            => 'text',
                'title'           => esc_html__('Info Title', 'apeix'),
              ),
              array(
                'id'              => 'desc',
                'type'            => 'text',
                'title'           => esc_html__('Info Description', 'apeix'),
              ),
            ),
            'button_title'        => esc_html__('Add Project info', 'apeix'),
            'accordion_title'     => esc_html__('project Info', 'apeix'),
          ),
           // Start fields
        ),
      ),

    ),
  );

  // -----------------------------------------
  // post options
  // -----------------------------------------
  $options[]    = array(
    'id'        => 'post_options',
    'title'     => esc_html__('Grid Image', 'apeix'),
    'post_type' => 'post',
    'context'   => 'side',
    'priority'  => 'default',
    'sections'  => array(
      array(
        'name'   => 'post_option_section',
        'fields' => array(
          array(
            'id'           => 'widget_post_title',
            'type'         => 'text',
            'title'        => esc_html__('Widget Post Title', 'apeix'),
            'add_title' => esc_html__('Add Widget Post Title here', 'apeix'),
          ),
          array(
            'id'           => 'grid_image',
            'type'         => 'image',
            'title'        => esc_html__('Post Grid Image', 'apeix'),
            'add_title' => esc_html__('Add Post Grid Image', 'apeix'),
          ),
        ),
      ),

    ),
  );


  return $options;

}
add_filter( 'cs_metabox_options', 'apeix_metabox_options' );