<?php
/*
 * All CSS and JS files are enqueued from this file
 * Author & Copyright:wpoceans
 * URL: http://themeforest.net/user/wpoceans
 */

/**
 * Enqueue Files for FrontEnd
 */
function apeix_google_font_url() {
    $font_url = '';
    if ( 'off' !== esc_html__( 'on', 'apeix' ) ) {
        $font_url = add_query_arg( 'family', urlencode( 'Lato:400,700|Source Sans Pro:400,400i,600' ), "//fonts.googleapis.com/css" );
    }
    return $font_url;
}

if ( ! function_exists( 'apeix_scripts_styles' ) ) {
  function apeix_scripts_styles() {

    // Styles
    wp_enqueue_style( 'themify-icons', APEIX_CSS .'/themify-icons.css', array(), '4.6.3', 'all' );
    wp_enqueue_style( 'flaticon', APEIX_CSS .'/flaticon.css', array(), '1.0.0', 'all' );
    wp_enqueue_style( 'bootstrap', APEIX_CSS .'/bootstrap.min.css', array(), '3.3.7', 'all' );
    wp_enqueue_style( 'animate', APEIX_CSS .'/animate.css', array(), '3.5.1', 'all' );
    wp_enqueue_style( 'odometer', APEIX_CSS .'/odometer.css', array(), '0.4.8', 'all' );
    wp_enqueue_style( 'owl-carousel', APEIX_CSS .'/owl.carousel.css', array(), '2.0.0', 'all' );
    wp_enqueue_style( 'owl-theme', APEIX_CSS .'/owl.theme.css', array(), '2.0.0', 'all' );
    wp_enqueue_style( 'slick', APEIX_CSS .'/slick.css', array(), '1.6.0', 'all' );
    wp_enqueue_style( 'swiper', APEIX_CSS .'/swiper.min.css', array(), '4.0.7', 'all' );
    wp_enqueue_style( 'slick-theme', APEIX_CSS .'/slick-theme.css', array(), '1.6.0', 'all' );
    wp_enqueue_style( 'owl-transitions', APEIX_CSS .'/owl.transitions.css', array(), '2.0.0', 'all' );
    wp_enqueue_style( 'fancybox', APEIX_CSS .'/fancybox.css', array(), '2.0.0', 'all' );
    wp_enqueue_style( 'apeix-style', APEIX_CSS .'/styles.css', array(), APEIX_VERSION, 'all' );
    wp_enqueue_style( 'theme-style', APEIX_CSS .'/theme-style.css', array(), APEIX_VERSION, 'all' );
    wp_enqueue_style( 'element', APEIX_CSS .'/elements.css', array(), APEIX_VERSION, 'all' );
    wp_enqueue_style( 'apeix-gutenberg-editor-styles', APEIX_CSS . '/gutenberg-editor-style.css' , false );
    if ( !function_exists('cs_framework_init') ) {
      wp_enqueue_style('apeix-default-style', get_template_directory_uri() . '/style.css', array(),  APEIX_VERSION, 'all' );
    }
    wp_enqueue_style( 'apeix-default-google-fonts', apeix_google_font_url(), array(), APEIX_VERSION, 'all' );
    // Scripts
    wp_enqueue_script( 'bootstrap', APEIX_SCRIPTS . '/bootstrap.min.js', array( 'jquery' ), '3.3.7', true );
    wp_enqueue_script( 'imagesloaded');
    wp_enqueue_script( 'isotope', APEIX_SCRIPTS . '/isotope.min.js', array( 'jquery' ), '2.2.2', true );
    wp_enqueue_script( 'fancybox', APEIX_SCRIPTS . '/fancybox.min.js', array( 'jquery' ), '2.1.5', true );
    wp_enqueue_script( 'masonry');
    wp_enqueue_script( 'owl-carousel', APEIX_SCRIPTS . '/owl-carousel.js', array( 'jquery' ), '2.0.0', true );
    wp_enqueue_script( 'jquery-easing', APEIX_SCRIPTS . '/jquery-easing.js', array( 'jquery' ), '1.4.0', true );
    wp_enqueue_script( 'wow', APEIX_SCRIPTS . '/wow.min.js', array( 'jquery' ), '1.4.0', true );
    wp_enqueue_script( 'odometer', APEIX_SCRIPTS . '/odometer.min.js', array( 'jquery' ), '0.4.8', true );
    wp_enqueue_script( 'magnific-popup', APEIX_SCRIPTS . '/magnific-popup.js', array( 'jquery' ), '1.1.0', true );
    wp_enqueue_script( 'slick-slider', APEIX_SCRIPTS . '/slick-slider.js', array( 'jquery' ), '1.6.0', true );
    wp_enqueue_script( 'swiper', APEIX_SCRIPTS . '/swiper.min.js', array( 'jquery' ), '4.0.7', true );
    wp_enqueue_script( 'wc-quantity-increment', APEIX_SCRIPTS . '/wc-quantity-increment.js', array( 'jquery' ), '1.0.0', true );
    wp_enqueue_script( 'apeix-scripts', APEIX_SCRIPTS . '/scripts.js', array( 'jquery' ), APEIX_VERSION, true );
    // Comments
    wp_enqueue_script( 'apeix-validate-js', APEIX_SCRIPTS . '/jquery.validate.min.js', array( 'jquery' ), '1.9.0', true );
    wp_add_inline_script( 'apeix-validate-js', 'jQuery(document).ready(function($) {$("#commentform").validate({rules: {author: {required: true,minlength: 2},email: {required: true,email: true},comment: {required: true,minlength: 10}}});});' );

    // Responsive Active
    $apeix_viewport = cs_get_option('theme_responsive');
    if( !$apeix_viewport ) {
      wp_enqueue_style( 'apeix-responsive', APEIX_CSS .'/responsive.css', array(), APEIX_VERSION, 'all' );
    }

    // Adds support for pages with threaded comments
    if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
      wp_enqueue_script( 'comment-reply' );
    }

  }
  add_action( 'wp_enqueue_scripts', 'apeix_scripts_styles' );
}

/**
 * Enqueue Files for BackEnd
 */
if ( ! function_exists( 'apeix_admin_scripts_styles' ) ) {
  function apeix_admin_scripts_styles() {

    wp_enqueue_style( 'apeix-admin-main', APEIX_CSS . '/admin-styles.css', true );
    wp_enqueue_style( 'flaticon', APEIX_CSS . '/flaticon.css', true );
    wp_enqueue_style( 'themify-icons', APEIX_CSS . '/themify-icons.css', true );
    wp_enqueue_script( 'apeix-admin-scripts', APEIX_SCRIPTS . '/admin-scripts.js', true );

  }
  add_action( 'admin_enqueue_scripts', 'apeix_admin_scripts_styles' );
}
