<?php
/*
 * The header for our theme.
 * Author & Copyright:wpoceans
 * URL: http://themeforest.net/user/wpoceans
 */
?><!DOCTYPE html>
<!--[if !IE]><!--> <html <?php language_attributes(); ?>> <!--<![endif]-->
<head>
<meta charset="<?php bloginfo( 'charset' ); ?>">
<?php
$apeix_viewport = cs_get_option( 'theme_responsive' );
if( !$apeix_viewport ) { ?>
	<meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1">
<?php } $apeix_all_element_color  = cs_get_customize_option( 'all_element_colors' ); ?>
<meta name="msapplication-TileColor" content="<?php echo esc_attr( $apeix_all_element_color ); ?>">
	<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/7.0.1/css/all.min.css" integrity="sha512-2SwdPD6INVrV/lHTZbO2nodKhrnDdJK9/kg2XD1r9uGqPo1cUbujc+IYdlYdEErWNu69gVcYgdxlmVmzTWnetw==" crossorigin="anonymous" referrerpolicy="no-referrer" />
<meta name="theme-color" content="<?php echo esc_attr( $apeix_all_element_color ); ?>">
<link rel="profile" href="https://gmpg.org/xfn/11">
<?php
// Metabox
global $post;
$apeix_id    = ( isset( $post ) ) ? $post->ID : false;
$apeix_id    = ( is_home() ) ? get_option( 'page_for_posts' ) : $apeix_id;
$apeix_id    = ( is_woocommerce_shop() ) ? wc_get_page_id( 'shop' ) : $apeix_id;
$apeix_id    = ( ! is_tag() && ! is_archive() && ! is_search() && ! is_404() && ! is_singular('testimonial') ) ? $apeix_id : false;
$apeix_meta  = get_post_meta( $apeix_id, 'page_type_metabox', true );
// Theme Layout Width
$apeix_layout_width  = cs_get_option( 'theme_layout_width' );
$theme_preloder  = cs_get_option( 'theme_preloder' );
$apeix_layout_width_class = ( $apeix_layout_width === 'container' ) ? 'layout-boxed' : 'layout-full';
// Header Style
if ( $apeix_meta ) {
  $apeix_header_design  = $apeix_meta['select_header_design'];
  $apeix_sticky_header = isset( $apeix_meta['sticky_header'] ) ? $apeix_meta['sticky_header'] : '' ;
} else {
  $apeix_header_design  = cs_get_option( 'select_header_design' );
  $apeix_sticky_header  = cs_get_option( 'sticky_header' );
}

if ( $apeix_header_design === 'default' ) {
  $apeix_header_design_actual  = cs_get_option( 'select_header_design' );
} else {
  $apeix_header_design_actual = ( $apeix_header_design ) ? $apeix_header_design : cs_get_option('select_header_design');
}

$apeix_header_design_actual = $apeix_header_design_actual ? $apeix_header_design_actual : 'style_three';

if ( $apeix_header_design_actual == 'style_one' ) {
  $header_class = 'header-style-1';
} elseif ( $apeix_header_design_actual == 'style_two' ) {
  $header_class = 'header-style-2';
}  else {
  $header_class = 'header-style-3';
}


if ( $apeix_sticky_header ) {
  $apeix_sticky_header = $apeix_sticky_header ? ' sticky-menu-on ' : '';
} else {
  $apeix_sticky_header = '';
}
// Header Transparent
if ( $apeix_meta ) {
  $apeix_transparent_header = $apeix_meta['transparency_header'];
  $apeix_transparent_header = $apeix_transparent_header ? ' header-transparent' : ' dont-transparent';
  // Shortcode Banner Type
  $apeix_banner_type = ' '. $apeix_meta['banner_type'];
} else { $apeix_transparent_header = ' dont-transparent'; $apeix_banner_type = ''; }
wp_head();
?>
</head>
<body <?php body_class(); ?>>
  <?php wp_body_open(); ?>
<div class="page-wrapper <?php echo esc_attr( $apeix_layout_width_class ); ?>"> <!-- #apeix-theme-wrapper -->
<?php if( $theme_preloder ) {
 get_template_part( 'theme-layouts/header/preloder' );
 } ?>
 <header id="header" class="site-header <?php echo esc_attr( $header_class ); ?>">
      <?php  get_template_part( 'theme-layouts/header/top','bar' ); ?>
      <nav class="navigation <?php echo esc_attr( $apeix_sticky_header ); ?> navbar navbar-default">
        <?php get_template_part( 'theme-layouts/header/menu','bar' ); ?>
      </nav>
  </header>
  <?php
  // Title Area
  $apeix_need_title_bar = cs_get_option('need_title_bar');
  if ( !$apeix_need_title_bar ) {
    get_template_part( 'theme-layouts/header/title', 'bar' );
  }
