<?php
/*
 * Apeix Theme's Functions
 * Author & Copyright:wpoceans
 * URL: http://themeforest.net/user/wpoceans
 */

/**
 * Define - Folder Paths
 */

define( 'APEIX_THEMEROOT_URI', get_template_directory_uri() );
define( 'APEIX_CSS', APEIX_THEMEROOT_URI . '/assets/css' );
define( 'APEIX_IMAGES', APEIX_THEMEROOT_URI . '/assets/images' );
define( 'APEIX_SCRIPTS', APEIX_THEMEROOT_URI . '/assets/js' );
define( 'APEIX_FRAMEWORK', get_template_directory() . '/includes' );
define( 'APEIX_LAYOUT', get_template_directory() . '/theme-layouts' );
define( 'APEIX_CS_IMAGES', APEIX_THEMEROOT_URI . '/includes/theme-options/framework-extend/images' );
define( 'APEIX_CS_FRAMEWORK', get_template_directory() . '/includes/theme-options/framework-extend' ); // Called in Icons field *.json
define( 'APEIX_ADMIN_PATH', get_template_directory() . '/includes/theme-options/cs-framework' ); // Called in Icons field *.json

/**
 * Define - Global Theme Info's
 */
if (is_child_theme()) { // If Child Theme Active
	$apeix_theme_child = wp_get_theme();
	$apeix_get_parent = $apeix_theme_child->Template;
	$apeix_theme = wp_get_theme($apeix_get_parent);
} else { // Parent Theme Active
	$apeix_theme = wp_get_theme();
}
define('APEIX_NAME', $apeix_theme->get( 'Name' ));
define('APEIX_VERSION', $apeix_theme->get( 'Version' ));
define('APEIX_BRAND_URL', $apeix_theme->get( 'AuthorURI' ));
define('APEIX_BRAND_NAME', $apeix_theme->get( 'Author' ));

/**
 * All Main Files Include
 */
require_once( APEIX_FRAMEWORK . '/init.php' );