<?php
/*
 * The template for displaying the footer.
 * Author & Copyright:wpoceans
 * URL: http://themeforest.net/user/wpoceans
 */

$apeix_id    = ( isset( $post ) ) ? $post->ID : 0;
$apeix_id    = ( is_home() ) ? get_option( 'page_for_posts' ) : $apeix_id;
$apeix_id    = ( is_woocommerce_shop() ) ? wc_get_page_id( 'shop' ) : $apeix_id;
$apeix_meta  = get_post_meta( $apeix_id, 'page_type_metabox', true );
$apeix_ft_bg = cs_get_option('apeix_ft_bg');
$apeix_attachment = wp_get_attachment_image_src( $apeix_ft_bg , 'full' );

$apeix_attachment = $apeix_attachment ? $apeix_attachment[0] : '';

if ($apeix_attachment) {
	$bg_url = ' style="';
	$bg_url .= ($apeix_attachment) ? 'background-image: url( ' . esc_url($apeix_attachment) . ' );' : '';
	$bg_url .= '"';
} else {
	$bg_url = '';
}

if ( $apeix_meta ) {
	$apeix_hide_footer  = $apeix_meta['hide_footer'];
} else { $apeix_hide_footer = ''; }
if ( !$apeix_hide_footer ) { // Hide Footer Metabox
	$hide_copyright = cs_get_option('hide_copyright');
?>
	<!-- Footer -->
	<footer class="site-footer" <?php echo wp_kses($bg_url, array('img' => array('src' => array(), 'alt' => array()),)); ?>>
		<?php
			$footer_widget_block = cs_get_option( 'footer_widget_block' );
			if ( $footer_widget_block ) {
	      get_template_part( 'theme-layouts/footer/footer', 'widgets' );
	    }
			if ( !$hide_copyright ) {
      	get_template_part( 'theme-layouts/footer/footer', 'copyright' );
	    }
    ?>
	</footer>
	<!-- Footer -->
<?php } // Hide Footer Metabox ?>
</div><!--apeix-theme-wrapper -->
<?php wp_footer(); ?>
</body>
</html>
