<?php
/*
 * The template for displaying 404 pages (not found).
 * Author & Copyright:wpoceans
 * URL: http://themeforest.net/user/wpoceans
 */
// Theme Options
$apeix_error_heading = cs_get_option('error_heading');
$apeix_error_subheading = cs_get_option('error_subheading');
$apeix_error_page_content = cs_get_option('error_page_content');
$apeix_error_page_bg = cs_get_option('error_page_bg');
$apeix_error_btn_text = cs_get_option('error_btn_text');
$apeix_error_heading = ( $apeix_error_heading ) ? $apeix_error_heading : esc_html__( '404', 'apeix' );
$apeix_error_subheading = ( $apeix_error_subheading ) ? $apeix_error_subheading : esc_html__( 'Oops! Page Not Found!', 'apeix' );
$apeix_error_page_content = ( $apeix_error_page_content ) ? $apeix_error_page_content : esc_html__( 'We’re sorry but we can’t seem to find the page you requested. This might be because you have typed the web address incorrectly.', 'apeix' );
$apeix_error_page_bg = ( $apeix_error_page_bg ) ? wp_get_attachment_url($apeix_error_page_bg) : APEIX_IMAGES . '/404.png';
$apeix_error_btn_text = ( $apeix_error_btn_text ) ? $apeix_error_btn_text : esc_html__( 'BACK TO HOME', 'apeix' );
$image_alt = get_post_meta( $apeix_error_page_bg , '_wp_attachment_image_alt', true);
get_header(); ?>
<section class="error-404-section section-padding">
  <div class="container">
      <div class="row">
          <div class="col col-xs-12">
              <div class="content clearfix">
                  <div class="error">
                      <h2><?php echo esc_html( $apeix_error_heading ); ?></h2>
                  </div>
                  <div class="error-message">
                      <h3><?php echo wp_kses_post( $apeix_error_subheading ); ?>!</h3>
                      <p><?php echo esc_html( $apeix_error_page_content ); ?></p>
                      <a href="<?php echo esc_url(home_url( '/' )); ?>" class="theme-btn-s2">
                        <?php echo esc_html( $apeix_error_btn_text ); ?>
                      </a>
                  </div>
              </div>
          </div>
      </div> <!-- end row -->
  </div> <!-- end container -->
</section>
<?php
get_footer();