<?php
/* ==========================================================
  Testimonials
=========================================================== */
if ( !function_exists('apeix_testimonial_function')) {
  function apeix_testimonial_function( $atts, $content = NULL ) {
    extract($atts);

    $e_uniqid       = uniqid();
    $inline_style   = '';

    if ( $title_size || $title_color ) {
      $title_style = ' style="';
      $title_style .= $title_size ? 'font-size: '. apeix_plugin_check_px($title_size) .';': '';
      $title_style .= $title_color ? 'color: '.$title_color : '';
      $title_style .= '"';
    } else {
      $title_style = '';
    }
    if ( $subtitle_size || $subtitle_color ) {
      $subtitle_style = ' style="';
      $subtitle_style .= $subtitle_size ? 'font-size: '. apeix_plugin_check_px($subtitle_size) .';': '';
      $subtitle_style .= $subtitle_color ? 'color: '.$subtitle_color : '';
      $subtitle_style .= '"';
    } else {
      $subtitle_style = '';
    }

    if ( $desc_size || $desc_color ) {
      $desc_style = ' style="';
      $desc_style .= $desc_size ? 'font-size: '. apeix_plugin_check_px($desc_size) .';': '';
      $desc_style .= $desc_color ? 'color: '.$desc_color : '';
      $desc_style .= '"';
    } else {
      $desc_style = '';
    }

  
    // add inline style
    add_inline_style( $inline_style );
    $styled_class  = 'testimonials-section-'.$e_uniqid.' ';
    $testimonial_items = ( $testimonial_items ) ? (array) $testimonial_items : array();

    ob_start(); ?>
    <div class="hx-testimonial-area <?php echo esc_attr( $styled_class.$class ); ?>">
        <div class="hx-testimonial-active owl-carousel">
         <?php if ( $testimonial_items ) {
            foreach ( $testimonial_items as $key => $testimonial_item ) { 
            $image_url = wp_get_attachment_url( $testimonial_item->image_url );
            $image_alt = get_post_meta($testimonial_item->image_url, '_wp_attachment_image_alt', true); ?>
            <div class="hx-testimonial-wrap">
                <div class="hx-testimonial-item">
                    <div class="hx-testimonial-icon">
                        <i class="fi et-quote"></i>
                    </div>
                    <div class="hx-testimonial-content">
                        <p <?php echo wp_kses_post( $desc_style ); ?>><?php echo esc_html( $testimonial_item->desc ); ?></p>
                    </div>
                    <div class="hx-testimonial-img">
                       <img src="<?php echo esc_url( $image_url ); ?>" alt="<?php echo esc_attr( $image_alt ); ?>">
                    </div>
                    <div class="hx-testimonial-content">
                        <h4 <?php echo wp_kses_post( $title_style ); ?>>
                          <?php echo esc_html( $testimonial_item->title ); ?>
                        </h4>
                        <span <?php echo wp_kses_post( $subtitle_style ); ?>>
                          <?php echo esc_html( $testimonial_item->subtitle ); ?>
                        </span>
                    </div>
                </div>
            </div>
           <?php } } ?>
        </div>
    </div>
   <?php return ob_get_clean();
  }
}
add_shortcode( 'mtc_testimonial', 'apeix_testimonial_function' );
