<?php
/* ==========================================================
  Team
=========================================================== */
if ( !function_exists('apeix_team_function')) {
  function apeix_team_function( $atts, $content = NULL ) {
    extract($atts);

    if ( $title_size || $title_color ) {
      $title_style = ' style="';
      $title_style .= $title_size ? 'font-size: '. apeix_plugin_check_px($title_size) .';': '';
      $title_style .= $title_color ? 'color: '.$title_color : '';
      $title_style .= '"';
    } else {
      $title_style = '';
    }
    if ( $desc_size || $desc_color ) {
      $desc_style = ' style="';
      $desc_style .= $desc_size ? 'font-size: '. apeix_plugin_check_px($desc_size) .';': '';
      $desc_style .= $desc_color ? 'color: '.$desc_color : '';
      $desc_style .= '"';
    } else {
      $desc_style = '';
    }

   $e_uniqid       = uniqid();
   $inline_style   = '';


    if ( $overly_color ) {
      $inline_style .= '.hx-team-area-'.$e_uniqid .'.hx-team-area .hx-team-img:before {';
      $inline_style .= ( $overly_color ) ? 'background-color:'. $overly_color .';' : '';
      $inline_style .= '}';
    }

      // add inline style
  add_inline_style( $inline_style );
  $styled_class  = 'hx-team-area-'.$e_uniqid.' ';

  $team_items = ( $team_items ) ? (array) $team_items : array();
  ob_start(); ?>
  <div class="hx-team-area <?php echo esc_attr( $styled_class.$class ); ?>">
      <div class="row">
        <?php if ( $team_items ) {
          foreach ( $team_items as $key => $team_item ) {
          $image_url = wp_get_attachment_url( $team_item->team_image );
          $image_alt = get_post_meta($team_item->team_image, '_wp_attachment_image_alt', true);
          ?>
          <div class="col-md-4 col-sm-6 col-12 col-g">
              <div class="hx-team-single">
                  <div class="hx-team-img">
                       <img src="<?php echo esc_url( $image_url ); ?>" alt="<?php echo esc_attr( $image_alt ); ?>">
                      <div class="SocialIcons">
                          <a href="<?php echo esc_url( $team_item->facebook_link ); ?>"><i class="<?php echo esc_attr( $team_item->facebook ); ?>"></i></a>
                          <a href="<?php echo esc_url( $team_item->twitter_link ); ?>"><i class="<?php echo esc_attr( $team_item->twitter ); ?>"></i></a>
                          <a href="<?php echo esc_url( $team_item->linkedin_link ); ?>"><i class="<?php echo esc_attr( $team_item->linkedin ); ?>"></i></a>
                      </div>
                      <div class="profileInfo">
                          <h3 <?php echo wp_kses_post( $title_style ); ?>><?php echo esc_html( $team_item->title ); ?>
                          <span <?php echo wp_kses_post( $desc_style ); ?>><?php echo esc_html( $team_item->subtitle ); ?></span></h3>  
                      </div>
                  </div>
              </div>
          </div>
        <?php } } ?>
      </div>
  </div>
  <?php return ob_get_clean();
  }
}
add_shortcode( 'mtc_team', 'apeix_team_function' );
