<?php
add_action('init', 'apeix_slider_kc_map', 99 );
function apeix_slider_kc_map() {

    if (function_exists('kc_add_map')){
        kc_add_map(
            array(
                'mtc_slider' => array(
                    'name' =>  esc_html__('Apeix Slider','apeix-core'),
                    'description' => esc_html__('Display single icon', 'apeix-core'),
                    'icon' => 'cpicon kc-icon-icarousel',
                    'category' => ApeixLibrary::apeix_kc_cat_name(),
                    'params' => array(
                    'Content' => array(
                     array(
                          'name' => 'slide_style',
                          'label' => esc_html__('Slide Style', 'apeix-core'),
                          'type' => 'select',
                          'options' => array(
                            'style_one' => esc_html__( 'Static Image', 'apeix-core' ),
                            'style_two' => esc_html__( 'Slide Style Two', 'apeix-core' ),
                            'style_three' => esc_html__( 'Slide Style Three', 'apeix-core' ),
                          ),
                          'admin_label' => true,
                      ),
                      array(
                          'name' => 'title',
                          'label' => esc_html__( 'Title','apeix-core'),
                          'type' => 'text',
                          'admin_label' => true,
                          'description' => esc_html__('Write Slider Title ', 'apeix-core'),
                          'relation' => array(
                            'parent'    => 'slide_style',
                            'show_when' => 'style_one'
                           ),
                        ),
                      array(
                          'name' => 'subtitle',
                          'label' => esc_html__( 'Sub Title','apeix-core'),
                          'type' => 'text',
                          'admin_label' => true,
                          'description' => esc_html__('Write Slider Sub Title ', 'apeix-core'),
                          'relation' => array(
                            'parent'    => 'slide_style',
                            'show_when' => 'style_one'
                           ),
                        ),
                      array(
                          'name' => 'button_text',
                          'label' => esc_html__( 'Button Text','apeix-core'),
                          'type' => 'text',
                          'admin_label' => true,
                          'description' => esc_html__('Write Slider Button Text ', 'apeix-core'),
                          'relation' => array(
                            'parent'    => 'slide_style',
                            'show_when' => 'style_one'
                           ),
                        ),
                      array(
                          'name' => 'button_link',
                          'label' => esc_html__( 'Button Link','apeix-core'),
                          'type' => 'text',
                          'admin_label' => true,
                          'description' => esc_html__('Write Slider Button Link ', 'apeix-core'),
                          'relation' => array(
                            'parent'    => 'slide_style',
                            'show_when' => 'style_one'
                           ),
                        ),
                      array(
                          'name' => 'slider_image',
                          'label' => esc_html__( 'Slider Image','apeix-core'),
                          'type' => 'attach_image',
                          'admin_label' => true,
                          'description' => esc_html__('Attach Slider Image ', 'apeix-core'),
                          'relation' => array(
                            'parent'    => 'slide_style',
                            'show_when' => 'style_one'
                           ),
                        ),
                      array(
                        'type'          => 'group',
                        'label'         => esc_html__(' Options', 'apeix-core'),
                        'name'          => 'slider_items',
                        'description'   => esc_html__( 'Slider Iteams Group Field', 'apeix-core' ),
                        'options'       => array('add_text' => esc_html__(' Add new Slider  Iteam', 'apeix-core')),
                        'relation' => array(
                            'parent'    => 'slide_style',
                            'hide_when' => 'style_one'
                           ),
                        'params' => array(
                          array(
                              'name' => 'title',
                              'label' => esc_html__( 'Title','apeix-core'),
                              'type' => 'text',
                              'admin_label' => true,
                              'description' => esc_html__('Write Slider Title ', 'apeix-core'),
                            ),
                          array(
                              'name' => 'subtitle',
                              'label' => esc_html__( 'Sub Title','apeix-core'),
                              'type' => 'text',
                              'admin_label' => true,
                              'description' => esc_html__('Write Slider Sub Title ', 'apeix-core'),
                            ),
                          array(
                              'name' => 'button_text',
                              'label' => esc_html__( 'Button Text','apeix-core'),
                              'type' => 'text',
                              'admin_label' => true,
                              'description' => esc_html__('Write Slider Button Text ', 'apeix-core'),
                            ),
                          array(
                              'name' => 'button_link',
                              'label' => esc_html__( 'Button Link','apeix-core'),
                              'type' => 'text',
                              'admin_label' => true,
                              'description' => esc_html__('Write Slider Button Link ', 'apeix-core'),
                            ),
                          array(
                              'name' => 'video_link',
                              'label' => esc_html__( 'Video Button Link','apeix-core'),
                              'type' => 'text',
                              'admin_label' => true,
                              'description' => esc_html__('Write Slider Button Link ', 'apeix-core'),
                            ),
                          array(
                              'name' => 'slider_image',
                              'label' => esc_html__( 'Slider Image','apeix-core'),
                              'type' => 'attach_image',
                              'admin_label' => true,
                              'description' => esc_html__('Attach Slider Image ', 'apeix-core'),
                            ),
                        ),
                      ),
                    ),
                  'Style' => array(
                    array(
                        'name' => 'class',
                        'label' => esc_html__('Extra Class','apeix-core'),
                        'type' => 'text',
                        'admin_label' => true,
                        'description' => esc_html__('Enter Extra Class for Titlte ..', 'apeix-core')
                      ),
                    array(
                        'name' => 'subtitle_size',
                        'label' => esc_html__('Slider Sub Title Size','apeix-core'),
                        'type' => 'number_slider',
                        'options' => array(
                          'min' => 25,
                          'max' => 60,
                          'unit' => 'px',
                          'show_input' => true
                        ),
                        'description' => esc_html__('Enter font-size for Sub title such as: 15px, 1em ..etc..', 'apeix-core')
                      ),
                    array(
                        'name' => 'subtitle_color',
                        'label' => esc_html__('Slider Sub Title Color','apeix-core'),
                        'type' => 'color_picker',
                        'admin_label' => true,
                        'description' => esc_html__('Set color for Sub title', 'apeix-core')
                      ),
                    array(
                        'name' => 'title_size',
                        'label' => esc_html__('Slider Title Size','apeix-core'),
                        'type' => 'number_slider',
                        'options' => array(
                          'min' => 25,
                          'max' => 60,
                          'unit' => 'px',
                          'show_input' => true
                        ),
                        'description' => esc_html__('Enter font-size for title such as: 15px, 1em ..etc..', 'apeix-core')
                      ),
                    array(
                        'name' => 'title_color',
                        'label' => esc_html__('Slider Title Color','apeix-core'),
                        'type' => 'color_picker',
                        'admin_label' => true,
                        'description' => esc_html__('Set color for title', 'apeix-core')
                      ),
                    array(
                        'name' => 'btn_bg_color',
                        'label' => esc_html__('Slider Button background','apeix-core'),
                        'type' => 'color_picker',
                        'admin_label' => true,
                        'description' => esc_html__('Set color for Slider Button background', 'apeix-core')
                      ),
                    array(
                        'name' => 'btn_color',
                        'label' => esc_html__('Slider Button Color','apeix-core'),
                        'type' => 'color_picker',
                        'admin_label' => true,
                        'description' => esc_html__('Set color for Slider Button', 'apeix-core')
                      ),
                   array(
                        'name' => 'btn_size',
                        'label' => esc_html__('Slider Button Size','apeix-core'),
                        'type' => 'number_slider',
                        'options' => array(
                          'min' => 25,
                          'max' => 60,
                          'unit' => 'px',
                          'show_input' => true
                        ),
                        'description' => esc_html__('Enter font-size for Button such as: 15px, 1em ..etc..', 'apeix-core')
                      ),
                    array(
                        'name' => 'video_bg_color',
                        'label' => esc_html__('Slider Video background','apeix-core'),
                        'type' => 'color_picker',
                        'admin_label' => true,
                        'description' => esc_html__('Set color for Slider Video background', 'apeix-core')
                      ),
                    array(
                        'name' => 'nav_color',
                        'label' => esc_html__('Slider Navigation Arrow Color','apeix-core'),
                        'type' => 'color_picker',
                        'admin_label' => true,
                        'description' => esc_html__('Set Navigation color for Slider', 'apeix-core')
                      ),
                    array(
                        'name' => 'nav_bgcolor',
                        'label' => esc_html__('Slider Navigation Arrow Background Color','apeix-core'),
                        'type' => 'color_picker',
                        'admin_label' => true,
                        'description' => esc_html__('Set Navigation Background color for Slider', 'apeix-core')
                      ),
                    )
                  )
                ),  // End of elemnt kc_icon

            )
        ); // End add map

    } // End if

}
