<?php
/* ==========================================================
  Project
=========================================================== */
if ( !function_exists('apeix_project_function')) {
  function apeix_project_function( $atts, $content = NULL ) {
    extract($atts);

      $e_uniqid       = uniqid();
      $inline_style   = '';
      if ( $title_color || $title_size ) {
        $inline_style .= '.project-section-'.$e_uniqid .' .project-grids .grid .project-content h2 a {';
        $inline_style .= ( $title_color ) ? 'color:'. $title_color .';' : '';
        $inline_style .= ( $title_size ) ? 'font-size:'.apeix_core_check_px($title_size) .';' : '';
        $inline_style .= '}';
      }
  
      if ( $subtitle_color || $subtitle_size ) {
        $inline_style .= '.page-wrapper .project-section-'.$e_uniqid .'.project-section .project-grids .project-content p {';
        $inline_style .= ( $subtitle_color ) ? 'color:'. $subtitle_color .';' : '';
        $inline_style .= ( $subtitle_size ) ? 'font-size:'.apeix_core_check_px($subtitle_size) .';' : '';
        $inline_style .= '}';
      }

      // add inline style
      add_inline_style( $inline_style );
      $styled_class  = ' project-section-'.$e_uniqid.' ';

      $aparticular_item = explode(',', $particular_item);
      $perticular_items = array();
      foreach ( $aparticular_item as $item ) {
        $perticular_items[] = substr($item, 0, strpos($item, ":"));;
      }
      $perticular_items = ($particular_item) ? $perticular_items : '';

      ob_start();
        $args = array(
          'post_type' => 'project',
          'posts_per_page' => (int) $project_limit,
          'orderby' => $project_orderby,
          'order' => $project_order,
          'post__in' => $perticular_items,
          'project_category' => esc_attr($project_show_category),
          'post__not_in' => array( $project_hide_post )
        );
        $apeix_project = new WP_Query( $args );
          if ($apeix_project->have_posts()) :
        ?>
        <section class="project-section <?php echo esc_attr( $styled_class.$class ) ?>">
          <div class="row">
            <div class="col col-xs-12">
              <div class="project-grids clearfix">
              <?php
                while ( $apeix_project->have_posts()) : $apeix_project->the_post();
                $project_options = get_post_meta( get_the_ID(), 'project_options', true );
                $project_title = isset( $project_options['project_title']) ? $project_options['project_title'] : '';
                $project_subtitle = isset( $project_options['project_subtitle']) ? $project_options['project_subtitle'] : '';
                $project_image = isset( $project_options['project_image']) ? $project_options['project_image'] : '';

                global $post;
                $grid_url = wp_get_attachment_url( $project_image );
                $grid_alt = get_post_meta( $project_image , '_wp_attachment_image_alt', true);

              ?>
              <div class="grid">
                  <div class="entry-media">
                      <img src="<?php echo esc_url( $grid_url ); ?>"  alt="<?php echo esc_attr( $grid_alt ); ?>">
                  </div>
                  <div class="project-content">
                     <h2><a href="<?php echo esc_url( get_permalink() ); ?>"><?php echo esc_html( $project_title ); ?></a></h2>
                      <p class="cat"><?php echo esc_html( $project_subtitle ) ?></p>
                  </div>
              </div>
             <?php endwhile;
              wp_reset_postdata();
             ?>
            </div>
          </div>
        </div>
      </section>
     <?php endif;
    return ob_get_clean();
  }
}
add_shortcode( 'mtnc_project', 'apeix_project_function' );
