<?php
add_action('init', 'apeix_funfact_kc_map', 99 );
function apeix_funfact_kc_map() {

	if (function_exists('kc_add_map')){
	    kc_add_map(
	        array(
	            'ole_funfact' => array(
	                'name' => esc_html__('Apeix Funfact','apeix-core'),
	                'description' => esc_html__('Display single icon', 'apeix-core'),
	                'icon' => 'cpicon kc-icon-coundown',
	                'category' => ApeixLibrary::apeix_kc_cat_name(),
	                'params' => array(
                  'Content' => array(
                    array(
                      'name' => 'funfact_style',
                      'label' => esc_html__('Funfact Style', 'apeix-core'),
                      'type' => 'select',
                      'options' => array(
                        'standard' => esc_html__( 'Standard', 'apeix-core' ),
                        'classic' => esc_html__( 'Classic', 'apeix-core' ),
                      ),
                    ),
                   array(
                      'name' => 'title',
                      'label' => esc_html__( 'Title','apeix-core'),
                      'type' => 'text',
                      'admin_label' => true,
                      'description' => esc_html__('Write Funfact  Title ', 'apeix-core'),
                      'relation' => array(
                          'parent'    => 'funfact_style',
                          'show_when' => 'standard'
                        ),
                    ),
                   array(
                      'name' => 'desc',
                      'label' => esc_html__( 'Desctription','apeix-core'),
                      'type' => 'textarea',
                      'admin_label' => true,
                      'description' => esc_html__('Write Funfact  Desctription', 'apeix-core'),
                      'relation' => array(
                          'parent'    => 'funfact_style',
                          'show_when' => 'standard'
                        ),
                    ),
                    array(
                        'type'          => 'group',
                        'label'         => esc_html__(' Options', 'apeix-core'),
                        'name'          => 'funfact_items',
                        'description'   => esc_html__( 'Funfact Iteams Group Field', 'apeix-core' ),
                        'options'       => array('add_text' => esc_html__(' Add new Funfact Iteam', 'apeix-core')),
                        'params' => array(
                            array(
                              'name' => 'icon',
                              'label' => esc_html__( 'Icon','apeix-core'),
                              'type' => 'icon_picker',
                              'admin_label' => true,
                              'description' => esc_html__('Write Funfact Icon ', 'apeix-core'),
                              'relation' => array(
                                  'parent'    => 'funfact_style',
                                  'hide_when' => 'standard'
                                ),
                            ),
                            array(
                              'name' => 'title',
                              'label' => esc_html__( 'Title','apeix-core'),
                              'type' => 'text',
                              'admin_label' => true,
                              'description' => esc_html__('Write Funfact Title ', 'apeix-core'),
                            ),
                            array(
                              'name' => 'number',
                              'label' => esc_html__('Number','apeix-core'),
                              'type' => 'text',
                              'admin_label' => false,
                              'description' => esc_html__('Write Funfact Number ', 'apeix-core'),
                            ),
                            array(
                              'name' => 'percent',
                              'label' => esc_html__('Percent','apeix-core'),
                              'type' => 'text',
                              'admin_label' => false,
                              'description' => esc_html__('Write Funfact Percent ', 'apeix-core'),
                            ),
                        ),
                      ),
                    ),
                    'Style' => array(
	                    array(
                        'name' => 'class',
                        'label' => esc_html__('Extra Class','apeix-core'),
                        'type' => 'text',
                        'admin_label' => true,
                        'description' => esc_html__('Enter Extra Class for Titlte .', 'apeix-core')
                      )
                      ,array(
                        'name' => 'title_size',
                        'label' => esc_html__('Title Size','apeix-core'),
                        'type' => 'number_slider',
                        'options' => array(
                          'min' => 15,
                          'max' => 60,
                          'unit' => 'px',
                          'show_input' => true
                        ),
                        'description' => esc_html__('Enter font-size for title such as: 15px, 1em .etc.', 'apeix-core')
	                    ),
	                    array(
                        'name' => 'title_color',
                        'label' => esc_html__('Title Color','apeix-core'),
                        'type' => 'color_picker',
                        'admin_label' => true,
                        'description' => esc_html__('Set color for title', 'apeix-core')
	                    ),
                      array(
                        'name' => 'number_size',
                        'label' => esc_html__('Number Size','apeix-core'),
                        'type' => 'number_slider',
                        'options' => array(
                          'min' => 15,
                          'max' => 60,
                          'unit' => 'px',
                          'show_input' => true
                        ),
                        'description' => esc_html__('Enter font-size for Funfact Number such as: 15px, 1em ..etc..', 'apeix-core')
                      ),
                      array(
                        'name' => 'number_color',
                        'label' => esc_html__('Number Color','apeix-core'),
                        'type' => 'color_picker',
                        'admin_label' => true,
                        'description' => esc_html__('Set color for Funfact Number', 'apeix-core')
                      ),
	                    array(
                        'name' => 'icon_size',
                        'label' => esc_html__('Icon Size','apeix-core'),
                        'type' => 'number_slider',
                        'options' => array(
                          'min' => 15,
                          'max' => 60,
                          'unit' => 'px',
                          'show_input' => true
                        ),
                        'description' => esc_html__('Enter font-size for Funfact Icon such as: 15px, 1em ..etc..', 'apeix-core')
	                    ),
                      array(
                        'name' => 'icon_color',
                        'label' => esc_html__('Icon Color','apeix-core'),
                        'type' => 'color_picker',
                        'admin_label' => true,
                        'description' => esc_html__('Set color for Funfact Icon', 'apeix-core')
                      ),
	                    array(
                        'name' => 'funfact_bg',
                        'label' => esc_html__('Funfact Background Color','apeix-core'),
                        'type' => 'color_picker',
                        'admin_label' => true,
                        'description' => esc_html__('Set Background color for Funfact', 'apeix-core')
	                    ),
		                )
	                )
	            ),  // End of elemnt kc_icon
	        )
	    ); // End add map
	} // End if
}
