<?php
if (!function_exists( 'apeix_button_kc_map' ) ) {
  add_action('init', 'apeix_button_kc_map', 99 );
  function apeix_button_kc_map() {
    kc_add_map(
      array(
        'apeix_button' => array(
          'name' => esc_html__('Apeix Button', 'apeix-core'),
          'description' => esc_html__( 'Button Styles', 'apeix-core' ),
          'category' => ApeixLibrary::apeix_kc_cat_name(),
          'icon' => 'cpicon kc-icon-button',
          'title' => esc_html__('Button Settings', 'apeix-core'),
          'params' => array(
            esc_html__( 'General', 'apeix-core' ) => array(
              array(
                  'name' => 'button_style',
                  'label' => esc_html__('Button Style', 'apeix-core'),
                  'type' => 'select',
                  'options' => array(
                    'standard' => esc_html__( 'Standard', 'apeix-core' ),
                    'classic' => esc_html__( 'Classic', 'apeix-core' ),
                  ),
                ),
              array(
                'name' => 'title',
                'label' => esc_html__('Button Title', 'apeix-core'),
                'type' => 'text',
                'admin_label' => true
              ),
              array(
                'name' => 'link',
                'label' => esc_html__('Button Link', 'apeix-core'),
                'type' => 'link',
                'admin_label' => true,
                'description' => esc_html__( 'Add your relative URL. Each URL contains link, anchor text and target attributes.', 'apeix-core' ),
              ),
              array(
                'name' => 'class',
                'label' => esc_html__('Extra class name', 'apeix-core'),
                'type' => 'text',
                'description' => esc_html__(' ', 'apeix-core')
              )
            ),
            esc_html__( 'Style', 'apeix-core' ) => array(
              array(
                'name' => 'button_color',
                'label' => esc_html__('Button Text Color', 'apeix-core'),
                'type' => 'color_picker'
              ),
              array(
                'name' => 'button_size',
                'label' => esc_html__('Button Text Size', 'apeix-core'),
                'type' => 'number_slider',
                'options' => array(
                  'min' => 14,
                  'max' =>24,
                  'unit' => 'px',
                  'show_input' => true
                ),
              ),
              array(
                'name' => 'background',
                'label' => esc_html__('Background Color', 'apeix-core'),
                'type' => 'color_picker'
              ),
              array(
                'name' => 'hover_color',
                'label' => esc_html__('Hover Color', 'apeix-core'),
                'type' => 'color_picker'
              ),
              array(
                'name' => 'hover_bg',
                'label' => esc_html__('Hover Background', 'apeix-core'),
                'type' => 'color_picker'
              ),
              array(
                'name' => 'border_color',
                'label' => esc_html__('Border Color', 'apeix-core'),
                'type' => 'color_picker'
              ),
              array(
                'name' => 'border_hover_color',
                'label' => esc_html__('Border Color', 'apeix-core'),
                'type' => 'color_picker'
              ),
              array(
                'name' => 'border_size',
                'label' => esc_html__('Border Size', 'apeix-core'),
                'type' => 'number_slider',
                'options' => array(
                  'min' => 2,
                  'max' => 5,
                  'unit' => 'px',
                  'show_input' => true
                ),
              ),
            ),
          )
        ),
      )
    ); // End add map
  }
} // End if