<?php
add_action('init', 'apeix_blog_kc_map', 99 );
function apeix_blog_kc_map() {
  if (function_exists('kc_add_map')){
      kc_add_map(
        array(
        'blog_section' => array(
        'name' => esc_html__('Apeix Blog', 'apeix-core'),
        'description' => esc_html__( 'Blog content', 'apeix-core' ),
        'category' => ApeixLibrary::apeix_kc_cat_name(),
        'icon' => 'cpicon kc-icon-blog-posts',
        'title' => esc_html__('Blog Settings', 'apeix-core'),
        'is_container' => true,
        'priority'  => 130,
        'params' => array(
          esc_html__( 'General', 'apeix-core' )  => array(
            array(
              "label"     =>esc_html__('Post Limit', 'apeix-core'),
              "name"  => "blog_limit",
              'type' => 'number_slider',
                'options' => array(
                    'min' => 1,
                    'max' => 50,
                    'show_input' => true
                ),
              "description" => esc_html__( "Enter the number of items to show.", 'apeix-core'),
            ),
            array(
              'type' => 'select',
              'label' => esc_html__( 'Order', 'apeix-core' ),
              'options' => array(
                '' => esc_html__( 'Select Order', 'apeix-core' ),
                'ASC' => esc_html__( 'Asending', 'apeix-core' ),
                'DESC' => esc_html__( 'Desending', 'apeix-core' ),
              ),
              'name' => 'blog_order',
            ),
            array(
              'name' => 'blog_orderby',
              'type' => 'select',
              'label' => esc_html__( 'Order By', 'apeix-core' ),
              'options' => array(
                '' => esc_html__( 'Select Order', 'apeix-core' ),
                'none' => esc_html__( 'None', 'apeix-core' ),
                'ID' => esc_html__( 'ID', 'apeix-core' ),
                'author' => esc_html__( 'Author', 'apeix-core' ),
                'title' => esc_html__( 'Title', 'apeix-core' ),
                'date' => esc_html__( 'Date', 'apeix-core' ),
                'menu_order' => esc_html__( 'Menu Order', 'apeix-core' ),
              ),
            ),
            array(
              'name' => 'particular_item',
              'type' => 'post_taxonomy',
              'label' => esc_html__( 'Set particular category for display post from these category.', 'apeix-core' ),
            ),
            array(
              "type"        =>'text',
              "label"     =>esc_html__('Content Length', 'medikare-core'),
              "name"  => "short_content",
            ),
            array(
              'name' => 'pagination',
              'type' => 'toggle',
              'label' => esc_html__( 'Pagination', 'apeix-core' ),
              'description' => esc_html__('Turn On if you want to Show Blog Date.', 'apeix-core'),
            ),
           array(
              'name' => 'blog_date',
              'label' => esc_html__('Blog Date','apeix-core'),
              'type' => 'toggle',
              'value'     => 'yes',
              'admin_label' => true,
              'description' => esc_html__('Turn On if you want to Hide Blog Date.', 'apeix-core')
            ),
           array(
              'name' => 'blog_author',
              'label' => esc_html__('Blog Author','apeix-core'),
              'type' => 'toggle',
              'value'     => 'yes',
              'admin_label' => true,
              'description' => esc_html__('Turn On if you want to Hide Blog Author.', 'apeix-core')
            ),
            array(
              'name' => 'class',
              'type' => 'text',
              'label' => esc_html__( 'Custom Class', 'apeix-core' ),
            ),
          ),
          esc_html__( 'Style', 'apeix-core' ) => array(
            array(
              "name"  => "title_color",
              "type"        =>'color_picker',
              "label"     =>esc_html__('Title Color', 'apeix-core'),
            ),
            array(
              "name"  => "title_size",
              "type"        =>'number_slider',
              "label"     =>esc_html__('Title Size', 'apeix-core'),
              'options' => array(
                'min' => 10,
                'max' => 40,
                'unit' => 'px',
                'show_input' => true
              )
            ),
            array(
                  'name' => 'desc_size',
                  'label' => esc_html__('Blog Description Size','apeix-core'),
                  'type' => 'number_slider',
                  'options' => array(
                    'min' => 15,
                    'max' => 60,
                    'unit' => 'px',
                    'show_input' => true
                  ),
                  'description' => esc_html__('Enter font-size for Description such as: 15px, 1em ..etc..', 'apeix-core')
                ),
              array(
                  'name' => 'desc_color',
                  'label' => esc_html__('Blog Description Color','apeix-core'),
                  'type' => 'color_picker',
                  'admin_label' => true,
                  'description' => esc_html__('Set color for Description', 'apeix-core')
              ),
            array(
              'name' => 'meta_color',
              'label' => esc_html__('Post Meta Color', 'apeix-core'),
              'type' => 'color_picker',
            ),

          ),
        ),
      ),
      )
    ); // End add map
    }
} // End if