<?php
/**
 * King Composer Library
 * Common Fields
 */
class ApeixLibrary {

	// Get Theme Name
	public static function apeix_kc_cat_name() {
		return esc_html__( "by Apeix", 'apeix-core' );
	}

	// Extra Class
	public static function apeix_class_option() {
		return array(
		  "type" => "text",
		  "label" => esc_html__( "Extra class name", 'apeix-core' ),
		  "name" => "class",
		  "description" => esc_html__( "Custom styled class name.", 'apeix-core')
		);
	}

	// ID
	public static function apeix_id_option() {
		return array(
		  "type" => "text",
		  "label" => esc_html__( "Element ID", 'apeix-core' ),
		  "name" => "id",
		  'value' => '',
		  "description" => esc_html__( "Enter your ID for this element. If you want.", 'apeix-core')
		);
	}

	// Open Link in New Tab
	public static function apeix_open_link_tab() {
		return array(
			"type" => "toggle",
			"label" => esc_html__( "Open New Tab? (Links)", 'apeix-core' ),
			"name" => "open_link",
		);
	}

	/**
	 * Carousel Default Options
	 */

	// Loop
	public static function apeix_carousel_loop() {
		return array(
			"type" => "toggle",
			"label" => esc_html__( "Disable Loop?", 'apeix-core' ),
			"name" => "carousel_loop",
			"description" => esc_html__( "Continuously moving carousel, if enabled.", 'apeix-core')
		);
	}
	// Items
	public static function apeix_carousel_items() {
		return array(
		  "type" => "text",
			"label" => esc_html__( "Items", 'apeix-core' ),
		  "name" => "carousel_items",
		  "description" => esc_html__( "Enter the numeric value of how many items you want in per slide.", 'apeix-core')
		);
	}
	// Margin
	public static function apeix_carousel_margin() {
		return array(
		  "type" => "text",
			"label" => esc_html__( "Margin", 'apeix-core' ),
		  "name" => "carousel_margin",
		  "description" => esc_html__( "Enter the numeric value of how much space you want between each carousel item.", 'apeix-core')
		);
	}
	// Dots
	public static function apeix_carousel_dots() {
		return array(
		  "type" => "toggle",
			"label" => esc_html__( "Dots", 'apeix-core' ),
		  "name" => "carousel_dots",
		  "description" => esc_html__( "If you want Carousel Dots, enable it.", 'apeix-core')
		);
	}
	// Nav
	public static function apeix_carousel_nav() {
		return array(
		  "type" => "toggle",
			"label" => esc_html__( "Navigation", 'apeix-core' ),
		  "name" => "carousel_nav",
		  "description" => esc_html__( "If you want Carousel Navigation, enable it.", 'apeix-core')
		);
	}
	// Autoplay Timeout
	public static function apeix_carousel_autoplay_timeout() {
		return array(
		  "type" => "text",
			"label" => esc_html__( "Autoplay Timeout", 'apeix-core' ),
		  "group" => esc_html__( "Carousel", 'apeix-core' ),
		  "name" => "carousel_autoplay_timeout",
		  "description" => esc_html__( "Change carousel Autoplay timing value. Default : 5000. Means 5 seconds.", 'apeix-core')
		);
	}
	// Autoplay
	public static function apeix_carousel_autoplay() {
		return array(
		  "type" => "toggle",
			"label" => esc_html__( "Autoplay", 'apeix-core' ),
		  "name" => "carousel_autoplay",
		  "description" => esc_html__( "If you want to start Carousel automatically, enable it.", 'apeix-core')
		);
	}
	// Animate Out
	public static function apeix_carousel_animateout() {
		return array(
		  "type" => "toggle",
			"label" => esc_html__( "Animate Out", 'apeix-core' ),
		  "name" => "carousel_animate_out",
		  "description" => esc_html__( "CSS3 animation out.", 'apeix-core')
		);
	}
	// Mouse Drag
	public static function apeix_carousel_mousedrag() {
		return array(
		  "type" => "toggle",
			"label" => esc_html__( "Disable Mouse Drag?", 'apeix-core' ),
		  "name" => "carousel_mousedrag",
		  "description" => esc_html__( "If you want to disable Mouse Drag, check it.", 'apeix-core')
		);
	}
	// Auto Width
	public static function apeix_carousel_autowidth() {
		return array(
		  "type" => "toggle",
			"label" => esc_html__( "Auto Width", 'apeix-core' ),
		  "name" => "carousel_autowidth",
		  "description" => esc_html__( "Adjust Auto Width automatically for each carousel items.", 'apeix-core')
		);
	}
	// Auto Height
	public static function apeix_carousel_autoheight() {
		return array(
		  "type" => "toggle",
			"label" => esc_html__( "Auto Height", 'apeix-core' ),
		  "name" => "carousel_autoheight",
		  "description" => esc_html__( "Adjust Auto Height automatically for each carousel items.", 'apeix-core')
		);
	}
	// Tablet
	public static function apeix_carousel_tablet() {
		return array(
		  "type" => "text",
			"label" => esc_html__( "Tablet", 'apeix-core' ),
		  "name" => "carousel_tablet",
		  "description" => esc_html__( "Enter number of items to show in tablet.", 'apeix-core')
		);
	}
	// Mobile
	public static function apeix_carousel_mobile() {
		return array(
		  "type" => "text",
			"label" => esc_html__( "Mobile", 'apeix-core' ),
		  "name" => "carousel_mobile",
		  "description" => esc_html__( "Enter number of items to show in mobile.", 'apeix-core')
		);
	}
	// Small Mobile
	public static function apeix_carousel_small_mobile() {
		return array(
		  "type" => "text",
			"label" => esc_html__( "Small Mobile", 'apeix-core' ),
		  "name" => "carousel_small_mobile",
		  "description" => esc_html__( "Enter number of items to show in small mobile.", 'apeix-core')
		);
	}
}