<?php

/**
 * Plugin language
 */
function apeix_plugin_language_setup()
{
  load_plugin_textdomain('apeix-core', false, dirname(plugin_basename(__FILE__)) . '/languages');
}
add_action('init', 'apeix_plugin_language_setup');

/* WPAUTOP for shortcode output */
if (!function_exists('apeix_set_wpautop')) {
  function apeix_set_wpautop($content, $force = true)
  {
    if ($force) {
      $content = wpautop(preg_replace('/<\/?p\>/', "\n", $content) . "\n");
    }
    return do_shortcode(shortcode_unautop($content));
  }
}

/* Use shortcodes in text widgets */
add_filter('widget_text', 'do_shortcode');

/* Shortcodes enable in the_excerpt */
add_filter('the_excerpt', 'do_shortcode');

/* Remove p tag and add by our self in the_excerpt */
remove_filter('the_excerpt', 'wpautop');


/* Add Extra Social Fields in Admin User Profile */
function apeix_add_twitter_facebook($contactmethods)
{
  $contactmethods['twitter']    = 'Twitter';
  $contactmethods['facebook']   = 'Facebook';
  $contactmethods['instagram']  = 'Instagram';
  $contactmethods['pinterest']   = 'Pinterest';
  return $contactmethods;
}
add_filter('user_contactmethods', 'apeix_add_twitter_facebook', 10, 1);

/**
 *
 * Encode string for backup options
 *
 * @since 1.0.0
 * @version 1.0.0
 *
 */
if (!function_exists('cs_encode_string')) {
  function cs_encode_string($string)
  {
    return rtrim(strtr(call_user_func('base' . '64' . '_encode', addslashes(gzcompress(serialize($string), 9))), '+/', '-_'), '=');
  }
}

/**
 *
 * Decode string for backup options
 *
 * @since 1.0.0
 * @version 1.0.0
 *
 */
if (!function_exists('cs_decode_string')) {
  function cs_decode_string($string)
  {
    return unserialize(gzuncompress(stripslashes(call_user_func('base' . '64' . '_decode', rtrim(strtr($string, '-_', '+/'), '=')))));
  }
}


/* Inline Style */
global $all_inline_styles;
$all_inline_styles = array();
if (!function_exists('add_inline_style')) {
  function add_inline_style($style)
  {
    global $all_inline_styles;
    array_push($all_inline_styles, $style);
  }
}

/* Enqueue Inline Styles */
if (!function_exists('apeix_enqueue_inline_styles')) {
  function apeix_enqueue_inline_styles()
  {

    global $all_inline_styles;

    if (!empty(array_filter($all_inline_styles))) {
      echo '<style id="apeix-inline-style" type="text/css">' . apeix_compress_css_lines(join('', $all_inline_styles)) . '</style>';
    }
  }
  add_action('wp_footer', 'apeix_enqueue_inline_styles');
}

/* Validate px entered in field */
if (!function_exists('apeix_core_check_px')) {
  function apeix_core_check_px($num)
  {
    return (is_numeric($num)) ? $num . 'px' : $num;
  }
}



/* Share Options */
if ( ! function_exists( 'apeix_wp_share_option' ) ) {
  function apeix_wp_share_option() {

    global $post;
    $page_url = get_permalink($post->ID );
    $title = $post->post_title;
    $share_text = cs_get_option('share_text');
    $share_text = $share_text ? $share_text : esc_html__( 'Share', 'apeix' );
    $share_on_text = cs_get_option('share_on_text');
    $share_on_text = $share_on_text ? $share_on_text : esc_html__( 'Share On', 'apeix' );
    ?>
     <div class="share tag">
      <?php  echo '<span>'.esc_html__('Share:','apeix').'</span>'; ?>
      <ul>
        <li>
          <a href="//www.facebook.com/sharer/sharer.php?u=<?php print(urlencode($page_url)); ?>&amp;t=<?php print(urlencode($title)); ?>" class="facebook" data-toggle="tooltip" data-placement="top" title="<?php echo esc_attr( $share_on_text .' '); echo esc_attr('Facebook', 'apeix'); ?>" target="_blank"><i class="ti-facebook"></i></a>
        </li>
        <li>
          <a href="//twitter.com/home?status=<?php print(urlencode($title)); ?>+<?php print(urlencode($page_url)); ?>" class="twitter" data-toggle="tooltip" data-placement="top" title="<?php echo esc_attr( $share_on_text .' '); echo esc_attr('Twitter', 'apeix'); ?>" target="_blank"><i class="ti-twitter-alt"></i></a>
        </li>
        <li>
          <a href="//linkedin.com/shareArticle?mini=true&amp;url=<?php print(urlencode($page_url)); ?>&amp;title=<?php print(urlencode($title)); ?>" class="linkedin" data-toggle="tooltip" data-placement="top" title="<?php echo esc_attr( $share_on_text .' '); echo esc_attr('Linkedin', 'apeix'); ?>" target="_blank"><i class="ti-linkedin"></i></a>
        </li>
        <li>
          <a href="//pinterest.com/pin/create/button/?url=<?php print(urlencode($page_url)); ?>" class="pinterest" data-toggle="tooltip" data-placement="top" title="<?php echo esc_attr( $share_on_text .' '); echo esc_attr('Pinterest', 'apeix'); ?>" target="_blank"><i class="ti-pinterest"></i></a>
        </li>
      </ul>
    </div>
<?php
  }
}


/* Maintenance Mode */
if (!function_exists('apeix_maintenance_mode')) {
  function apeix_maintenance_mode()
  {

    $maintenance_mode_page = cs_get_option('maintenance_mode_page') && cs_get_option('enable_maintenance_mode');

    if (!empty($maintenance_mode_page) && !is_user_logged_in()) {
      get_template_part('theme-layouts/post/content', 'maintenance');
      exit;
    }
  }
  add_action('wp', 'apeix_maintenance_mode', 1);
}

/* Support WordPress uploader to following file extensions */
if (!function_exists('apeix_upload_mimes')) {
  function apeix_upload_mimes($mimes)
  {

    $mimes['ttf']   = 'font/ttf';
    $mimes['eot']   = 'font/eot';
    $mimes['woff']  = 'font/woff';
    $mimes['otf']   = 'font/otf';

    return $mimes;
  }
  add_filter('upload_mimes', 'apeix_upload_mimes');
}

/* Custom WordPress admin login logo */
if (!function_exists('apeix_theme_login_logo')) {
  function apeix_theme_login_logo()
  {
    $login_logo = cs_get_option('brand_logo_wp');
    if ($login_logo) {
      $login_logo_url = wp_get_attachment_url($login_logo);
    } else {
      $login_logo_url = APEIX_PLUGIN_IMGS . '/logo.png';
    }
    if ($login_logo) {
      echo "
      <style>
        body.login #login h1 a {
        background: url('$login_logo_url') no-repeat scroll center bottom transparent;
        height: 100px;
        width: 100%;
        margin-bottom:0px;
        }
      </style>";
    }
  }
  add_action('login_head', 'apeix_theme_login_logo');
}

/* WordPress admin login logo link */
if (!function_exists('apeix_login_url')) {
  function apeix_login_url()
  {
    return site_url();
  }
  add_filter('login_headerurl', 'apeix_login_url', 10, 4);
}

/* WordPress admin login logo link */
if (!function_exists('apeix_login_title')) {
  function apeix_login_title()
  {
    return get_bloginfo('name');
  }
  add_filter('login_headertext', 'apeix_login_title');
}


/* Support WordPress uploader to following file extensions */
if( ! function_exists( 'apeix_upload_mimes' ) ) {
  function apeix_upload_mimes( $mimes ) {

    $mimes['ttf']   = 'font/ttf';
    $mimes['eot']   = 'font/eot';
    $mimes['woff']  = 'font/woff';
    $mimes['otf']   = 'font/otf';

    return $mimes;

  }
  add_filter( 'upload_mimes', 'apeix_upload_mimes' );
}
