<?php
/*
 * All Custom Shortcode for [theme_name] theme.
 * Author & Copyright: helloexpert
 * URL: http://themeforest.net/user/helloexpert
 */

if( ! function_exists( 'apeix_shortcodes' ) ) {
  function apeix_shortcodes( $options ) {

    $options       = array();

    /* Topbar Shortcodes */
    $options[]     = array(
      'title'      => esc_html__('Topbar Shortcodes', 'apeix'),
      'shortcodes' => array(

        // Topbar item
        array(
          'name'          => 'apeix_widget_topbars',
          'title'         => esc_html__('Topbar info', 'apeix'),
          'view'          => 'clone',
          'clone_id'      => 'apeix_widget_topbar',
          'clone_title'   => esc_html__('Add New', 'apeix'),
          'fields'        => array(

            array(
              'id'        => 'custom_class',
              'type'      => 'text',
              'title'     => esc_html__('Custom Class', 'apeix'),
            ),

          ),
          'clone_fields'  => array(

            array(
              'id'        => 'info_icon',
              'type'      => 'icon',
              'title'     => esc_html__('Header Info icon', 'apeix')
            ),
            array(
              'id'        => 'dest',
              'type'      => 'text',
              'title'     => esc_html__('Header Info Description', 'apeix')
            ),

          ),

        ),
        // Topbar CTA
        array(
          'name'          => 'apeix_topbar_cta',
          'title'         => esc_html__('Tobar Right CTA', 'apeix'),
          'fields'        => array(
            array(
              'id'        => 'custom_class',
              'type'      => 'text',
              'title'     => esc_html__('Custom Class', 'apeix'),
            ),
            array(
              'id'        => 'title',
              'type'      => 'text',
              'title'     => esc_html__('Title', 'apeix'),
            ),
            array(
              'id'        => 'link_text',
              'type'      => 'text',
              'title'     => esc_html__('Link text', 'apeix'),
            ),
            array(
              'id'        => 'link',
              'type'      => 'text',
              'title'     => esc_html__('Link', 'apeix'),
            ),

          ),
        ),

      ),
    );

    /* Header Shortcodes */
    $options[]     = array(
      'title'      => esc_html__('Header Shortcodes', 'apeix'),
      'shortcodes' => array(

        // header Social
        array(
          'name'          => 'apeix_header_socials',
          'title'         => esc_html__('Header Social', 'apeix'),
          'view'          => 'clone',
          'clone_id'      => 'apeix_header_social',
          'clone_title'   => esc_html__('Add New Social', 'apeix'),
          'fields'        => array(

            array(
              'id'        => 'custom_class',
              'type'      => 'text',
              'title'     => esc_html__('Custom Class', 'apeix'),
            ),

          ),
          'clone_fields'  => array(
            array(
              'id'        => 'social_icon',
              'type'      => 'icon',
              'title'     => esc_html__('Social Icon', 'apeix')
            ),
            array(
              'id'        => 'social_icon_color',
              'type'      => 'color_picker',
              'title'     => esc_html__('Icon Color', 'apeix'),
            ),
            array(
              'id'        => 'social_link',
              'type'      => 'text',
              'title'     => esc_html__('Social Link', 'apeix')
            ),
            array(
              'id'        => 'target_tab',
              'type'      => 'switcher',
              'title'     => esc_html__('Open New Tab?', 'apeix'),
              'yes'     => esc_html__('Yes', 'apeix'),
              'no'     => esc_html__('No', 'apeix'),
            ),

          ),

        ),
        // header Social End

        // header Middle Infos
        array(
          'name'          => 'apeix_header_middle_infos',
          'title'         => esc_html__('Header Middle Info', 'apeix'),
          'view'          => 'clone',
          'clone_id'      => 'apeix_header_middle_info',
          'clone_title'   => esc_html__('Add New Info', 'apeix'),
          'fields'        => array(

            array(
              'id'        => 'custom_class',
              'type'      => 'text',
              'title'     => esc_html__('Custom Class', 'apeix'),
            ),

          ),
          'clone_fields'  => array(
            array(
              'id'        => 'social_icon',
              'type'      => 'icon',
              'title'     => esc_html__('Social Icon', 'apeix')
            ),
            array(
              'id'        => 'social_icon_color',
              'type'      => 'color_picker',
              'title'     => esc_html__('Icon Color', 'apeix'),
            ),
            array(
              'id'        => 'address_text',
              'type'      => 'text',
              'title'     => esc_html__('Address Text', 'apeix')
            ),
            array(
              'id'        => 'address_desc',
              'type'      => 'text',
              'title'     => esc_html__('Address Details', 'apeix')
            ),
          ),

        ),
        // header Middle Infos End



      ),
    );

    /* Content Shortcodes */
    $options[]     = array(
      'title'      => esc_html__('Content Shortcodes', 'apeix'),
      'shortcodes' => array(

        // Spacer
        array(
          'name'          => 'vc_empty_space',
          'title'         => esc_html__('Spacer', 'apeix'),
          'fields'        => array(

            array(
              'id'        => 'height',
              'type'      => 'text',
              'title'     => esc_html__('Height', 'apeix'),
              'attributes' => array(
                'placeholder'     => '20px',
              ),
            ),

          ),
        ),
        // Spacer

        // Social Icons
        array(
          'name'          => 'apeix_socials',
          'title'         => esc_html__('Social Icons', 'apeix'),
          'view'          => 'clone',
          'clone_id'      => 'apeix_social',
          'clone_title'   => esc_html__('Add New', 'apeix'),
          'fields'        => array(
            array(
              'id'        => 'custom_class',
              'type'      => 'text',
              'title'     => esc_html__('Custom Class', 'apeix'),
            ),

            // Colors
            array(
              'type'    => 'notice',
              'class'   => 'info',
              'content' => esc_html__('Colors', 'apeix')
            ),
            array(
              'id'        => 'icon_color',
              'type'      => 'color_picker',
              'title'     => esc_html__('Icon Color', 'apeix'),
              'wrap_class' => 'column_third',
            ),
            array(
              'id'        => 'icon_hover_color',
              'type'      => 'color_picker',
              'title'     => esc_html__('Icon Hover Color', 'apeix'),
              'wrap_class' => 'column_third',
              'dependency'  => array('social_select', '!=', 'style-three'),
            ),
            array(
              'id'        => 'bg_color',
              'type'      => 'color_picker',
              'title'     => esc_html__('Backrgound Color', 'apeix'),
              'wrap_class' => 'column_third',
              'dependency'  => array('social_select', '!=', 'style-one'),
            ),
            array(
              'id'        => 'bg_hover_color',
              'type'      => 'color_picker',
              'title'     => esc_html__('Backrgound Hover Color', 'apeix'),
              'wrap_class' => 'column_third',
              'dependency'  => array('social_select', '==', 'style-two'),
            ),
            array(
              'id'        => 'border_color',
              'type'      => 'color_picker',
              'title'     => esc_html__('Border Color', 'apeix'),
              'wrap_class' => 'column_third',
              'dependency'  => array('social_select', '==', 'style-three'),
            ),

            // Icon Size
            array(
              'id'        => 'icon_size',
              'type'      => 'text',
              'title'     => esc_html__('Icon Size', 'apeix'),
              'wrap_class' => 'column_full',
            ),

          ),
          'clone_fields'  => array(

            array(
              'id'        => 'social_link',
              'type'      => 'text',
              'attributes' => array(
                'placeholder'     => 'http://',
              ),
              'title'     => esc_html__('Link', 'apeix')
            ),
            array(
              'id'        => 'social_icon',
              'type'      => 'icon',
              'title'     => esc_html__('Social Icon', 'apeix')
            ),
            array(
              'id'        => 'target_tab',
              'type'      => 'switcher',
              'title'     => esc_html__('Open New Tab?', 'apeix'),
              'on_text'     => esc_html__('Yes', 'apeix'),
              'off_text'     => esc_html__('No', 'apeix'),
            ),

          ),

        ),
        // Social Icons

        // Useful Links
        array(
          'name'          => 'apeix_useful_links',
          'title'         => esc_html__('Useful Links', 'apeix'),
          'view'          => 'clone',
          'clone_id'      => 'apeix_useful_link',
          'clone_title'   => esc_html__('Add New', 'apeix'),
          'fields'        => array(

            array(
              'id'        => 'column_width',
              'type'      => 'select',
              'title'     => esc_html__('Column Width', 'apeix'),
              'options'        => array(
                'full-width' => esc_html__('One Column', 'apeix'),
                'half-width' => esc_html__('Two Column', 'apeix'),
                'third-width' => esc_html__('Three Column', 'apeix'),
              ),
            ),
            array(
              'id'        => 'custom_class',
              'type'      => 'text',
              'title'     => esc_html__('Custom Class', 'apeix'),
            ),

          ),
          'clone_fields'  => array(

            array(
              'id'        => 'title_link',
              'type'      => 'text',
              'title'     => esc_html__('Link', 'apeix')
            ),
            array(
              'id'        => 'target_tab',
              'type'      => 'switcher',
              'title'     => esc_html__('Open New Tab?', 'apeix'),
              'on_text'     => esc_html__('Yes', 'apeix'),
              'off_text'     => esc_html__('No', 'apeix'),
            ),
            array(
              'id'        => 'link_title',
              'type'      => 'text',
              'title'     => esc_html__('Title', 'apeix')
            ),

          ),

        ),
        // Useful Links

        // Simple Image List
        array(
          'name'          => 'apeix_image_lists',
          'title'         => esc_html__('Simple Image List', 'apeix'),
          'view'          => 'clone',
          'clone_id'      => 'apeix_image_list',
          'clone_title'   => esc_html__('Add New', 'apeix'),
          'fields'        => array(

            array(
              'id'        => 'custom_class',
              'type'      => 'text',
              'title'     => esc_html__('Custom Class', 'apeix'),
            ),

          ),
          'clone_fields'  => array(

            array(
              'id'        => 'get_image',
              'type'      => 'upload',
              'title'     => esc_html__('Image', 'apeix')
            ),
            array(
              'id'        => 'link',
              'type'      => 'text',
              'attributes' => array(
                'placeholder'     => 'http://',
              ),
              'title'     => esc_html__('Link', 'apeix')
            ),
            array(
              'id'    => 'open_tab',
              'type'  => 'switcher',
              'std'   => false,
              'title' => esc_html__('Open link to new tab?', 'apeix')
            ),

          ),

        ),
        // Simple Image List

        // Simple Link
        array(
          'name'          => 'apeix_simple_link',
          'title'         => esc_html__('Simple Link', 'apeix'),
          'fields'        => array(

            array(
              'id'        => 'link_style',
              'type'      => 'select',
              'title'     => esc_html__('Link Style', 'apeix'),
              'options'        => array(
                'link-underline' => esc_html__('Link Underline', 'apeix'),
                'link-arrow-right' => esc_html__('Link Arrow (Right)', 'apeix'),
                'link-arrow-left' => esc_html__('Link Arrow (Left)', 'apeix'),
              ),
            ),
            array(
              'id'        => 'link_icon',
              'type'      => 'icon',
              'title'     => esc_html__('Icon', 'apeix'),
              'value'      => 'fa fa-caret-right',
              'dependency'  => array('link_style', '!=', 'link-underline'),
            ),
            array(
              'id'        => 'link_text',
              'type'      => 'text',
              'title'     => esc_html__('Link Text', 'apeix'),
            ),
            array(
              'id'        => 'link',
              'type'      => 'text',
              'title'     => esc_html__('Link', 'apeix'),
              'attributes' => array(
                'placeholder'     => 'http://',
              ),
            ),
            array(
              'id'        => 'target_tab',
              'type'      => 'switcher',
              'title'     => esc_html__('Open New Tab?', 'apeix'),
              'on_text'     => esc_html__('Yes', 'apeix'),
              'off_text'     => esc_html__('No', 'apeix'),
            ),
            array(
              'id'        => 'custom_class',
              'type'      => 'text',
              'title'     => esc_html__('Custom Class', 'apeix'),
            ),

            // Normal Mode
            array(
              'type'    => 'notice',
              'class'   => 'info',
              'content' => esc_html__('Normal Mode', 'apeix')
            ),
            array(
              'id'        => 'text_color',
              'type'      => 'color_picker',
              'title'     => esc_html__('Text Color', 'apeix'),
              'wrap_class' => 'column_half el-hav-border',
            ),
            array(
              'id'        => 'border_color',
              'type'      => 'color_picker',
              'title'     => esc_html__('Border Color', 'apeix'),
              'wrap_class' => 'column_half el-hav-border',
              'dependency'  => array('link_style', '==', 'link-underline'),
            ),
            // Hover Mode
            array(
              'type'    => 'notice',
              'class'   => 'info',
              'content' => esc_html__('Hover Mode', 'apeix')
            ),
            array(
              'id'        => 'text_hover_color',
              'type'      => 'color_picker',
              'title'     => esc_html__('Text Hover Color', 'apeix'),
              'wrap_class' => 'column_half el-hav-border',
            ),
            array(
              'id'        => 'border_hover_color',
              'type'      => 'color_picker',
              'title'     => esc_html__('Border Hover Color', 'apeix'),
              'wrap_class' => 'column_half el-hav-border',
              'dependency'  => array('link_style', '==', 'link-underline'),
            ),

            // Size
            array(
              'type'    => 'notice',
              'class'   => 'info',
              'content' => esc_html__('Font Sizes', 'apeix')
            ),
            array(
              'id'        => 'text_size',
              'type'      => 'text',
              'title'     => esc_html__('Text Size', 'apeix'),
              'attributes' => array(
                'placeholder'     => 'Eg: 14px',
              ),
            ),

          ),
        ),
        // Simple Link

        // Blockquotes
        array(
          'name'          => 'apeix_blockquote',
          'title'         => esc_html__('Blockquote', 'apeix'),
          'fields'        => array(

            array(
              'id'        => 'blockquote_style',
              'type'      => 'select',
              'title'     => esc_html__('Blockquote Style', 'apeix'),
              'options'        => array(
                '' => esc_html__('Select Blockquote Style', 'apeix'),
                'style-one' => esc_html__('Style One', 'apeix'),
                'style-two' => esc_html__('Style Two', 'apeix'),
              ),
            ),
            array(
              'id'        => 'text_size',
              'type'      => 'text',
              'title'     => esc_html__('Text Size', 'apeix'),
            ),
            array(
              'id'        => 'custom_class',
              'type'      => 'text',
              'title'     => esc_html__('Custom Class', 'apeix'),
            ),
            array(
              'id'        => 'content_color',
              'type'      => 'color_picker',
              'title'     => esc_html__('Content Color', 'apeix'),
            ),
            array(
              'id'        => 'left_color',
              'type'      => 'color_picker',
              'title'     => esc_html__('Left Border Color', 'apeix'),
            ),
            array(
              'id'        => 'border_color',
              'type'      => 'color_picker',
              'title'     => esc_html__('Border Color', 'apeix'),
            ),
            array(
              'id'        => 'bg_color',
              'type'      => 'color_picker',
              'title'     => esc_html__('Background Color', 'apeix'),
            ),
            // Content
            array(
              'id'        => 'content',
              'type'      => 'textarea',
              'title'     => esc_html__('Content', 'apeix'),
            ),

          ),

        ),
        // Blockquotes

      ),
    );

    /* Widget Shortcodes */
    $options[]     = array(
      'title'      => esc_html__('Widget Shortcodes', 'apeix'),
      'shortcodes' => array(
        // widget Contact info
        array(
          'name'          => 'apeix_widget_contact_info',
          'title'         => esc_html__('Contact info', 'apeix'),
          'fields'        => array(
            array(
              'id'        => 'custom_class',
              'type'      => 'text',
              'title'     => esc_html__('Custom Class', 'apeix'),
            ),
            array(
              'id'        => 'image_url',
              'type'      => 'image',
              'title'     => esc_html__('Background Image', 'apeix'),
            ),
             array(
              'id'        => 'text_number',
              'type'      => 'text',
              'title'     => esc_html__('Number text', 'apeix'),
            ),
             array(
              'id'        => 'number',
              'type'      => 'text',
              'title'     => esc_html__('Number', 'apeix'),
            ),
             array(
              'id'        => 'number_text',
              'type'      => 'text',
              'title'     => esc_html__('Number text', 'apeix'),
            ),
            array(
              'id'        => 'title',
              'type'      => 'text',
              'title'     => esc_html__('Title', 'apeix'),
            ),
           
          ),
        ),


      // Service Contact Widget
        array(
          'name'          => 'apeix_service_widget_contacts',
          'title'         => esc_html__('Service Contact Widget', 'apeix'),
          'view'          => 'clone',
          'clone_id'      => 'apeix_service_widget_contact',
          'clone_title'   => esc_html__('Add New', 'apeix'),
          'fields'        => array(

            array(
              'id'        => 'custom_class',
              'type'      => 'text',
              'title'     => esc_html__('Custom Class', 'apeix'),
            ),
            array(
              'id'        => 'contact_title',
              'type'      => 'text',
              'title'     => esc_html__('Title', 'apeix')
            ),
          ),
          'clone_fields'  => array(
           
            array(
              'id'        => 'title',
              'type'      => 'text',
              'title'     => esc_html__('Contact Title', 'apeix')
            ),
             array(
              'id'        => 'info',
              'type'      => 'text',
              'title'     => esc_html__('Contact Info', 'apeix')
            ),

          ),

        ),
      // Service Contact Widget End
        // widget download-widget
        array(
          'name'          => 'apeix_download_widgets',
          'title'         => esc_html__('Download Widget', 'apeix'),
          'view'          => 'clone',
          'clone_id'      => 'apeix_download_widget',
          'clone_title'   => esc_html__('Add New', 'apeix'),
          'fields'        => array(

            array(
              'id'        => 'custom_class',
              'type'      => 'text',
              'title'     => esc_html__('Custom Class', 'apeix'),
            ),
          ),
          'clone_fields'  => array(

            array(
              'id'        => 'download_icon',
              'type'      => 'icon',
              'title'     => esc_html__('Download Icon', 'apeix')
            ),
            array(
              'id'        => 'title',
              'type'      => 'text',
              'title'     => esc_html__('Download Title', 'apeix')
            ),
            array(
              'id'        => 'link',
              'type'      => 'text',
              'title'     => esc_html__('Download Link', 'apeix')
            ),

          ),

        ),

      ),
    );

    /* Footer Shortcodes */
    $options[]     = array(
      'title'      => esc_html__('Footer Shortcodes', 'apeix'),
      'shortcodes' => array(

        // Footer Menus
        array(
          'name'          => 'apeix_footer_menus',
          'title'         => esc_html__('Footer Menu Links', 'apeix'),
          'view'          => 'clone',
          'clone_id'      => 'apeix_footer_menu',
          'clone_title'   => esc_html__('Add New', 'apeix'),
          'fields'        => array(

            array(
              'id'        => 'custom_class',
              'type'      => 'text',
              'title'     => esc_html__('Custom Class', 'apeix'),
            ),

          ),
          'clone_fields'  => array(

            array(
              'id'        => 'menu_title',
              'type'      => 'text',
              'title'     => esc_html__('Menu Title', 'apeix')
            ),
            array(
              'id'        => 'menu_link',
              'type'      => 'text',
              'title'     => esc_html__('Menu Link', 'apeix')
            ),
            array(
              'id'        => 'target_tab',
              'type'      => 'switcher',
              'title'     => esc_html__('Open New Tab?', 'apeix'),
              'on_text'     => esc_html__('Yes', 'apeix'),
              'off_text'     => esc_html__('No', 'apeix'),
            ),

          ),

        ),
        // Footer Menus
        array(
          'name'          => 'footer_infos',
          'title'         => esc_html__('footer logo and Text', 'apeix'),
          'view'          => 'clone',
          'clone_id'      => 'footer_info',
          'clone_title'   => esc_html__('Add New', 'apeix'),
          'fields'        => array(
            array(
              'id'        => 'custom_class',
              'type'      => 'text',
              'title'     => esc_html__('Custom Class', 'apeix'),
            ),
            array(
              'id'        => 'footer_logo',
              'type'      => 'image',
              'title'     => esc_html__('Footer logo', 'apeix'),
            ),
            array(
              'id'        => 'desc',
              'type'      => 'textarea',
              'title'     => esc_html__('Description', 'apeix'),
            ),
            
          ),
          'clone_fields'  => array(
            array(
              'id'        => 'social_icon',
              'type'      => 'icon',
              'title'     => esc_html__('Social Icon', 'apeix')
            ),
            array(
              'id'        => 'social_link',
              'type'      => 'text',
              'title'     => esc_html__('Social Link', 'apeix')
            ),
          ),

        ),

      // footer contact info
      array(
        'name'          => 'apeix_footer_contact_infos',
        'title'         => esc_html__('Contact info', 'apeix'),
        'view'          => 'clone',
        'clone_id'      => 'apeix_footer_contact_info',
        'clone_title'   => esc_html__('Add New', 'apeix'),
        'fields'        => array(

          array(
            'id'        => 'custom_class',
            'type'      => 'text',
            'title'     => esc_html__('Custom Class', 'apeix'),
          ),
          array(
            'id'        => 'title',
            'type'      => 'textarea',
            'title'     => esc_html__('Heading Title', 'apeix'),
          ),

        ),
        'clone_fields'  => array(

          array(
            'id'        => 'item',
            'type'      => 'text',
            'title'     => esc_html__('Contact info item', 'apeix')
          ),
          array(
            'id'        => 'desc',
            'type'      => 'text',
            'title'     => esc_html__('Widget Contact item description', 'apeix')
          ),

        ),

      ),

      // footer Address
       array(
          'name'          => 'apeix_footer_address_item',
          'title'         => esc_html__('Address', 'apeix'),
          'view'          => 'clone',
          'clone_id'      => 'apeix_footer_address_items',
          'clone_title'   => esc_html__('Add New', 'apeix'),
          'fields'        => array(

            array(
              'id'        => 'custom_class',
              'type'      => 'text',
              'title'     => esc_html__('Custom Class', 'apeix'),
            ),

          ),
          'clone_fields'  => array(
            array(
              'id'        => 'item',
              'type'      => 'text',
              'title'     => esc_html__('Address item', 'apeix')
            ),
          ),
        ),

      ),
    );

  return $options;

  }
  add_filter( 'cs_shortcode_options', 'apeix_shortcodes' );
}