<?php

/**
 * Initialize Custom Post Type - Apeix Theme
 */

function apeix_custom_post_type()
{

  // Service - Start
  $service_slug = 'service';
  $services = esc_html__('Service', 'apeix-core');

  // Register custom post type - Service
  register_post_type(
    'service',
    array(
      'labels' => array(
        'name' => $services,
        'singular_name' => sprintf(esc_html__('%s Post', 'apeix-core'), $services),
        'all_items' => sprintf(esc_html__('%s', 'apeix-core'), $services),
        'add_new' => esc_html__('Add New', 'apeix-core'),
        'add_new_item' => sprintf(esc_html__('Add New %s', 'apeix-core'), $services),
        'edit' => esc_html__('Edit', 'apeix-core'),
        'edit_item' => sprintf(esc_html__('Edit %s', 'apeix-core'), $services),
        'new_item' => sprintf(esc_html__('New %s', 'apeix-core'), $services),
        'view_item' => sprintf(esc_html__('View %s', 'apeix-core'), $services),
        'search_items' => sprintf(esc_html__('Search %s', 'apeix-core'), $services),
        'not_found' => esc_html__('Nothing found in the Database.', 'apeix-core'),
        'not_found_in_trash' => esc_html__('Nothing found in Trash', 'apeix-core'),
        'parent_item_colon' => ''
      ),
      'public' => true,
      'publicly_queryable' => true,
      'exclude_from_search' => false,
      'show_ui' => true,
      'query_var' => true,
      'menu_position' => 11,
      'menu_icon' => 'dashicons-welcome-add-page',
      'rewrite' => array(
        'slug' => $service_slug,
        'with_front' => false
      ),
      'has_archive' => true,
      'capability_type' => 'post',
      'hierarchical' => true,
      'supports' => array(
        'title',
        'editor',
        'thumbnail',
        'excerpt',
        'revisions',
      )
    )
  );
  // Service - End


  // Project - Start
  $project_slug = 'project';
  $projects = esc_html__('Project', 'apeix-core');

  // Register custom post type - project
  register_post_type(
    'project',
    array(
      'labels' => array(
        'name' => $projects,
        'singular_name' => sprintf(esc_html__('%s Post', 'apeix-core'), $projects),
        'all_items' => sprintf(esc_html__('%s', 'apeix-core'), $projects),
        'add_new' => esc_html__('Add New', 'apeix-core'),
        'add_new_item' => sprintf(esc_html__('Add New %s', 'apeix-core'), $projects),
        'edit' => esc_html__('Edit', 'apeix-core'),
        'edit_item' => sprintf(esc_html__('Edit %s', 'apeix-core'), $projects),
        'new_item' => sprintf(esc_html__('New %s', 'apeix-core'), $projects),
        'view_item' => sprintf(esc_html__('View %s', 'apeix-core'), $projects),
        'search_items' => sprintf(esc_html__('Search %s', 'apeix-core'), $projects),
        'not_found' => esc_html__('Nothing found in the Database.', 'apeix-core'),
        'not_found_in_trash' => esc_html__('Nothing found in Trash', 'apeix-core'),
        'parent_item_colon' => ''
      ),
      'public' => true,
      'publicly_queryable' => true,
      'exclude_from_search' => false,
      'show_ui' => true,
      'query_var' => true,
      'menu_position' => 12,
      'menu_icon' => 'dashicons-portfolio',
      'rewrite' => array(
        'slug' => $project_slug,
        'with_front' => false
      ),
      'has_archive' => true,
      'capability_type' => 'post',
      'hierarchical' => true,
      'supports' => array(
        'title',
        'editor',
        'thumbnail',
      )
    )
  );
  // project - End



}


// After Theme Setup
function apeix_custom_flush_rules()
{
  // Enter post type function, so rewrite work within this function
  apeix_custom_post_type();
  // Flush it
  flush_rewrite_rules();
}
register_activation_hook(__FILE__, 'apeix_custom_flush_rules');
add_action('init', 'apeix_custom_post_type');


/* ---------------------------------------------------------------------------
 * Custom columns - Service
 * --------------------------------------------------------------------------- */
add_filter("manage_edit-service_columns", "apeix_service_edit_columns");
function apeix_service_edit_columns($columns)
{
  $new_columns['cb'] = '<input type="checkbox" />';
  $new_columns['title'] = esc_html__('Title', 'apeix-core');
  $new_columns['thumbnail'] = esc_html__('Image', 'apeix-core');
  $new_columns['date'] = esc_html__('Date', 'apeix-core');

  return $new_columns;
}

add_action('manage_service_posts_custom_column', 'apeix_manage_service_columns', 10, 2);
function apeix_manage_service_columns($column_name)
{
  global $post;

  switch ($column_name) {

      /* If displaying the 'Image' column. */
    case 'thumbnail':
      echo get_the_post_thumbnail($post->ID, array(100, 100));
      break;

      /* Just break out of the switch statement for everything else. */
    default:
      break;
      break;
  }
}


/* ---------------------------------------------------------------------------
 * Custom columns - case
 * --------------------------------------------------------------------------- */
add_filter("manage_edit-project_columns", "apeix_project_edit_columns");
function apeix_project_edit_columns($columns)
{
  $new_columns['cb'] = '<input type="checkbox" />';
  $new_columns['title'] = esc_html__('Title', 'apeix-core');
  $new_columns['thumbnail'] = esc_html__('Image', 'apeix-core');
  $new_columns['date'] = esc_html__('Date', 'apeix-core');

  return $new_columns;
}

add_action('manage_project_posts_custom_column', 'apeix_manage_project_columns', 10, 2);
function apeix_manage_project_columns($column_name)
{
  global $post;

  switch ($column_name) {

      /* If displaying the 'Image' column. */
    case 'thumbnail':
      echo get_the_post_thumbnail($post->ID, array(100, 100));
      break;

      /* Just break out of the switch statement for everything else. */
    default:
      break;
      break;
  }
}
