<?php
/*
 * Elementor Apeix Funfact Widget
 * Author & Copyright: wpoceans
*/

namespace Elementor;

if (!defined('ABSPATH')) exit; // Exit if accessed directly

class Apeix_Funfact extends Widget_Base
{

	/**
	 * Retrieve the widget name.
	 */
	public function get_name()
	{
		return 'wpo-apeix_funfact';
	}

	/**
	 * Retrieve the widget title.
	 */
	public function get_title()
	{
		return esc_html__('Funfact', 'apeix-core');
	}

	/**
	 * Retrieve the widget icon.
	 */
	public function get_icon()
	{
		return 'eicon-counter';
	}

	/**
	 * Retrieve the list of categories the widget belongs to.
	 */
	public function get_categories()
	{
		return ['wpoceans-category'];
	}

	/**
	 * Retrieve the list of scripts the Apeix Funfact widget depended on.
	 * Used to set scripts dependencies required to run the widget.
	 */
	public function get_script_depends()
	{
		return ['wpo-apeix_funfact'];
	}

	/**
	 * Register Apeix Funfact widget controls.
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 */
	protected function register_controls()
	{

		$this->start_controls_section(
			'section_funfact',
			[
				'label' => esc_html__('Funfact Options', 'apeix-core'),
			]
		);
		$repeater = new Repeater();
		$repeater->add_control(
			'funfact_icon',
			[
				'label' => __('Icon', 'apeix-core'),
				'type' => \Elementor\Controls_Manager::ICONS,
				'default' => [
					'value' => 'fi flaticon-worker',
					'library' => 'solid',
				],
			]
		);
		$repeater->add_control(
			'funfact_title',
			[
				'label' => esc_html__('Title Text', 'apeix-core'),
				'type' => Controls_Manager::TEXT,
				'default' => esc_html__('Title Text', 'apeix-core'),
				'placeholder' => esc_html__('Type title text here', 'apeix-core'),
				'label_block' => true,
			]
		);
		$repeater->add_control(
			'funfact_number',
			[
				'label' => esc_html__('Funfact Number', 'apeix-core'),
				'type' => Controls_Manager::TEXT,
				'default' => esc_html__('250', 'apeix-core'),
				'placeholder' => esc_html__('Type funfact Number here', 'apeix-core'),
				'label_block' => true,
			]
		);
		$repeater->add_control(
			'funfact_plus',
			[
				'label' => esc_html__('Funfact Plus/Percentage', 'apeix-core'),
				'type' => Controls_Manager::TEXT,
				'default' => esc_html__('+', 'apeix-core'),
				'placeholder' => esc_html__('Type funfact Plus/Percentage here', 'apeix-core'),
				'label_block' => true,
			]
		);
		$this->add_control(
			'funfactItems_groups',
			[
				'label' => esc_html__('Funfact Items', 'apeix-core'),
				'type' => Controls_Manager::REPEATER,
				'default' => [
					[
						'funfact_title' => esc_html__('Funfact', 'apeix-core'),
					],

				],
				'fields' =>  $repeater->get_controls(),
				'title_field' => '{{{ funfact_title }}}',
			]
		);
		$this->end_controls_section(); // end: Section

		// Section
		$this->start_controls_section(
			'funfact_section_style',
			[
				'label' => esc_html__('BG', 'apeix-core'),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'funfact_bg_color',
			[
				'label' => esc_html__('Background Color', 'apeix-core'),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .fun-fact-section-s2 .fun-fact-grids .grid' => 'background-color: {{VALUE}};',
				],
			]
		);
		$this->end_controls_section(); // end: Section

		// Section
		$this->start_controls_section(
			'funfact_section_icon_style',
			[
				'label' => esc_html__('Icon', 'apeix-core'),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'label' => esc_html__('Typography', 'apeix-core'),
				'name' => 'service_apeix_icon_typography',
				'selector' => '{{WRAPPER}} .fun-fact .hx-counter-icon .fi',
			]
		);
		$this->add_control(
			'funfact_icon_color',
			[
				'label' => esc_html__('Color', 'apeix-core'),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .fun-fact .hx-counter-icon .fi' => 'color: {{VALUE}};',
				],
			]
		);
		$this->end_controls_section(); // end: Section

		// Funfact Number
		$this->start_controls_section(
			'funfact_number_style',
			[
				'label' => esc_html__('Number', 'apeix-core'),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'label' => esc_html__('Typography', 'apeix-core'),
				'name' => 'apeix_number_typography',
				'selector' => '{{WRAPPER}} .fun-fact-section-s2 .fun-fact-grids .grid h2',
			]
		);
		$this->add_control(
			'funfact_item_number_color',
			[
				'label' => esc_html__('Number Color', 'apeix-core'),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .fun-fact-section-s2 .fun-fact-grids .grid h2' => 'color: {{VALUE}};',
				],
			]
		);
		$this->add_control(
			'funfact_item_number_line_color',
			[
				'label' => esc_html__('Number Color', 'apeix-core'),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .fun-fact-section-s2 .fun-fact-grids .grid h2:before' => 'background-color: {{VALUE}};',
				],
			]
		);
		$this->add_control(
			'number_padding',
			[
				'label' => __('Number Padding', 'apeix-core'),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', 'em'],
				'selectors' => [
					'{{WRAPPER}} .fun-fact-section-s2 .fun-fact-grids .grid h2' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		$this->end_controls_section(); // end: Section

		// Funfact Title
		$this->start_controls_section(
			'funfact_title_style',
			[
				'label' => esc_html__('Funfact Title', 'apeix-core'),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'label' => esc_html__('Typography', 'apeix-core'),
				'name' => 'ntrsvt_funfact_title_typography',
				'selector' => '{{WRAPPER}} .fun-fact .grid h2+p',
			]
		);
		$this->add_control(
			'funfact_title',
			[
				'label' => esc_html__('Color', 'apeix-core'),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .fun-fact .grid h2+p' => 'color: {{VALUE}};',
				],
			]
		);
		$this->add_control(
			'funfact_title_padding',
			[
				'label' => __('Number Padding', 'apeix-core'),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', 'em'],
				'selectors' => [
					'{{WRAPPER}} .fun-fact .grid h2+p' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		$this->end_controls_section(); // end: Section


	}

	/**
	 * Render Funfact widget output on the frontend.
	 * Written in PHP and used to generate the final HTML.
	 */
	protected function render()
	{
		$settings = $this->get_settings_for_display();
		$funfactItems_groups = !empty($settings['funfactItems_groups']) ? $settings['funfactItems_groups'] : [];
		// Turn output buffer on
		ob_start(); ?>
		<div class="fun-fact fun-fact-section-s2">
			<div class="container">
				<div class="row">
					<div class="fun-fact-grids clearfix">
						<?php 	// Group Param Output
						if (is_array($funfactItems_groups) && !empty($funfactItems_groups)) {
							foreach ($funfactItems_groups as $each_item) {

								$funfact_title = !empty($each_item['funfact_title']) ? $each_item['funfact_title'] : '';
								$funfact_number = !empty($each_item['funfact_number']) ? $each_item['funfact_number'] : '';
								$funfact_plus = !empty($each_item['funfact_plus']) ? $each_item['funfact_plus'] : '';

								$funfact_icon = !empty($each_item['funfact_icon']['value']) ? $each_item['funfact_icon']['value'] : '';
								$funfact_svg_url = !empty($each_item['funfact_icon']['value']['url']) ? $each_item['funfact_icon']['value']['url'] : '';
								$svg_alt = get_post_meta($funfact_svg_url, '_wp_attachment_image_alt', true);

						?>
								<div class="grid">
									<div class="hx-counter-icon">
										<?php if ($funfact_svg_url) {
											echo '<img src="' . esc_url($funfact_svg_url) . '" alt="' . esc_url($svg_alt) . '">';
										} else {
											echo ' <i class="' . esc_attr($funfact_icon) . '"></i>';
										} ?>
									</div>
									<div>
										<?php
										if ($funfact_number) {
											echo '<h2><span class="odometer" data-count="' . esc_attr($funfact_number) . '">' . esc_html__('00', 'apeix-core') . '</span><span class="plus">' . esc_html($funfact_plus) . '</span></h2>';
										}
										?>
									</div>
									<p><?php if ($funfact_title) {
											echo '<p>' . esc_html__($funfact_title) . '</p>';
										} ?></p>
								</div>
						<?php }
						} ?>
					</div>
				</div>
			</div> <!-- end container -->
		</div>
<?php
		// Return outbut buffer
		echo ob_get_clean();
	}
	/**
	 * Render Funfact widget output in the editor.
	 * Written as a Backbone JavaScript template and used to generate the live preview.
	 */

	//protected function _content_template(){}

}
Plugin::instance()->widgets_manager->register(new Apeix_Funfact());
