<?php
/*
 * Elementor Apeix ContactInfo Widget
 * Author & Copyright: wpoceans
*/

namespace Elementor;

if (!defined('ABSPATH')) exit; // Exit if accessed directly

class Apeix_ContactInfo extends Widget_Base
{

	/**
	 * Retrieve the widget name.
	 */
	public function get_name()
	{
		return 'tmx-apeix_contactinfo';
	}

	/**
	 * Retrieve the widget title.
	 */
	public function get_title()
	{
		return esc_html__('ContactInfo', 'apeix-core');
	}

	/**
	 * Retrieve the widget item.
	 */
	public function get_item()
	{
		return 'eicon-site-identity';
	}

	/**
	 * Retrieve the list of categories the widget belongs to.
	 */
	public function get_categories()
	{
		return ['wpoceans-category'];
	}

	/**
	 * Retrieve the list of scripts the Apeix ContactInfo widget depended on.
	 * Used to set scripts dependencies required to run the widget.
	 */
	public function get_script_depends()
	{
		return ['tmx-apeix_contactinfo'];
	}

	/**
	 * Register Apeix ContactInfo widget controls.
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 */
	protected function register_controls()
	{

		$this->start_controls_section(
			'section_contactinfo',
			[
				'label' => esc_html__('ContactInfo Options', 'apeix-core'),
			]
		);
		$this->add_control(
			'section_title',
			[
				'label' => esc_html__('Title Text', 'apeix-core'),
				'type' => Controls_Manager::TEXT,
				'default' => esc_html__('Title Text', 'apeix-core'),
				'placeholder' => esc_html__('Type title text here', 'apeix-core'),
				'label_block' => true,
			]
		);
		$this->add_control(
			'section_content',
			[
				'label' => esc_html__('Content Text', 'apeix-core'),
				'type' => Controls_Manager::TEXTAREA,
				'default' => esc_html__('Title Sub Text', 'apeix-core'),
				'placeholder' => esc_html__('Type Content text here', 'apeix-core'),
				'label_block' => true,
			]
		);
		$repeater = new Repeater();
		$repeater->add_control(
			'contact_icon',
			[
				'label' => __('Icon', 'apeix-core'),
				'type' => \Elementor\Controls_Manager::ICONS,
				'default' => [
					'value' => 'ti-location-pin',
					'library' => 'solid',
				],
			]
		);
		$repeater->add_control(
			'contact_title',
			[
				'label' => esc_html__('Title Text', 'apeix-core'),
				'type' => Controls_Manager::TEXT,
				'default' => esc_html__('54, Dahs udin sorok, Melborn Austria', 'apeix-core'),
				'placeholder' => esc_html__('Type title text here', 'apeix-core'),
				'label_block' => true,
			]
		);
		$repeater->add_control(
			'contact_content',
			[
				'label' => esc_html__('Content Text', 'apeix-core'),
				'type' => Controls_Manager::TEXTAREA,
				'default' => esc_html__('54, Dahs udin sorok, Melborn Austria', 'apeix-core'),
				'placeholder' => esc_html__('Type title Content here', 'apeix-core'),
				'label_block' => true,
			]
		);
		$this->add_control(
			'contactinfoItems_groups',
			[
				'label' => esc_html__('Contact Info Items', 'apeix-core'),
				'type' => Controls_Manager::REPEATER,
				'default' => [
					[
						'contact_title' => esc_html__('Contact Info', 'apeix-core'),
					],

				],
				'fields' =>  $repeater->get_controls(),
				'title_field' => '{{{ contact_title }}}',
			]
		);
		$this->end_controls_section(); // end: Section


		// Title
		$this->start_controls_section(
			'contactinfo_section_title_style',
			[
				'label' => esc_html__('Title', 'apeix-core'),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'label' => esc_html__('Typography', 'apeix-core'),
				'name' => 'apeix_title_typography',
				'selector' => '{{WRAPPER}} .contact-pg-contact-section .contact-details h5',
			]
		);
		$this->add_control(
			'contactinfo_title_color',
			[
				'label' => esc_html__('Color', 'apeix-core'),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .contact-pg-contact-section .contact-details h5' => 'color: {{VALUE}};',
				],
			]
		);
		$this->add_control(
			'contactinfo_title_padding',
			[
				'label' => esc_html__('Title Padding', 'apeix-core'),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', 'em'],
				'selectors' => [
					'{{WRAPPER}} .contact-pg-contact-section .contact-details h5' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		$this->end_controls_section(); // end: Section



		// Content
		$this->start_controls_section(
			'contactinfo_section_content_style',
			[
				'label' => esc_html__('Content', 'apeix-core'),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'label' => esc_html__('Typography', 'apeix-core'),
				'name' => 'contactinfo_content_typography',
				'selector' => '{{WRAPPER}} .contact-pg-contact-section .contact-details p',
			]
		);
		$this->add_control(
			'contactinfo_content_color',
			[
				'label' => esc_html__('Color', 'apeix-core'),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .contact-pg-contact-section .contact-details p' => 'color: {{VALUE}};',
				],
			]
		);
		$this->add_control(
			'contactinfo_content_padding',
			[
				'label' => __('Sub Title Padding', 'apeix-core'),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', 'em'],
				'selectors' => [
					'{{WRAPPER}} .contact-pg-contact-section .contact-details p' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		$this->end_controls_section(); // end: Section

		// Icon
		$this->start_controls_section(
			'contactinfo_section_icon_style',
			[
				'label' => esc_html__('Icon', 'apeix-core'),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'contactinfo_icon_color',
			[
				'label' => esc_html__('Icon Color', 'apeix-core'),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .contact-pg-contact-section .icon i' => 'color: {{VALUE}};',
				],
			]
		);
		$this->add_control(
			'contactinfo_icon_bg_color',
			[
				'label' => esc_html__('BG Color', 'apeix-core'),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .contact-pg-contact-section .icon' => 'background-color: {{VALUE}};',
				],
			]
		);
		$this->end_controls_section(); // end: Section


	}

	/**
	 * Render ContactInfo widget output on the frontend.
	 * Written in PHP and used to generate the final HTML.
	 */
	protected function render()
	{
		$settings = $this->get_settings_for_display();
		$contactinfoItems_groups = !empty($settings['contactinfoItems_groups']) ? $settings['contactinfoItems_groups'] : [];

		$section_content = !empty($settings['section_content']) ? $settings['section_content'] : '';
		$section_title = !empty($settings['section_title']) ? $settings['section_title'] : '';

		// Turn output buffer on
		ob_start();
?>
		<div class="contact-pg-contact-section">
			<div class="section-title-s3">
				<?php if ($section_title) {
					echo '<h2>' . wp_kses_post($section_title) . '</h2>';
				} ?>
			</div>
			<div class="contact-details">
				<?php if ($section_content) {
					echo '<p>' . esc_html($section_content) . '</p>';
				} ?>
				<ul>
					<?php 	// Group Param Output
					if (is_array($contactinfoItems_groups) && !empty($contactinfoItems_groups)) {
						foreach ($contactinfoItems_groups as $each_items) {
							$contact_content = !empty($each_items['contact_content']) ? $each_items['contact_content'] : '';
							$contact_title = !empty($each_items['contact_title']) ? $each_items['contact_title'] : '';

							$contact_icon = !empty($each_items['contact_icon']['value']) ? $each_items['contact_icon']['value'] : '';
							$contact_svg_url = !empty($each_items['contact_icon']['value']['url']) ? $each_items['contact_icon']['value']['url'] : '';
							$svg_alt = get_post_meta($contact_svg_url, '_wp_attachment_image_alt', true);

							$contact_content = preg_replace('~\s*<br ?/?>\s*~', "<br />", $contact_content);
							$contact_content = nl2br($contact_content);

					?>
							<li>
								<div class="icon">
									<?php if ($contact_svg_url) {
										echo '<img src="' . esc_url($contact_svg_url) . '" alt="' . esc_url($svg_alt) . '">';
									} else {
										echo ' <i class="' . esc_attr($contact_icon) . '"></i>';
									} ?>
								</div>
								<?php
								if ($contact_title) {
									echo '<h5>' . esc_html($contact_title) . '</h5>';
								}
								if ($contact_content) {
									echo '<p>' . wp_kses_post($contact_content) . '</p>';
								}
								?>
							</li>
					<?php
						}
					}
					?>
				</ul>
			</div>
		</div>
<?php
		// Return outbut buffer
		echo ob_get_clean();
	}
	/**
	 * Render ContactInfo widget output in the editor.
	 * Written as a Backbone JavaScript template and used to generate the live preview.
	 */

	//protected function _content_template(){}

}
Plugin::instance()->widgets_manager->register(new Apeix_ContactInfo());
