<?php
/*
 * Elementor Apeix About Widget
 * Author & Copyright: wpoceans
*/

namespace Elementor;

if (!defined('ABSPATH')) exit; // Exit if accessed directly

class Apeix_About extends Widget_Base
{

	/**
	 * Retrieve the widget name.
	 */
	public function get_name()
	{
		return 'tmx-apeix_about';
	}

	/**
	 * Retrieve the widget title.
	 */
	public function get_title()
	{
		return esc_html__('About', 'apeix-core');
	}

	/**
	 * Retrieve the widget icon.
	 */
	public function get_icon()
	{
		return 'eicon-single-post';
	}

	/**
	 * Retrieve the list of categories the widget belongs to.
	 */
	public function get_categories()
	{
		return ['wpoceans-category'];
	}

	/**
	 * Retrieve the list of scripts the Apeix About widget depended on.
	 * Used to set scripts dependencies required to run the widget.
	 */
	public function get_script_depends()
	{
		return ['tmx-apeix_about'];
	}

	/**
	 * Register Apeix About widget controls.
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 */
	protected function register_controls()
	{

		$this->start_controls_section(
			'section_about',
			[
				'label' => esc_html__('About Options', 'apeix-core'),
			]
		);
		$this->add_control(
			'about_title',
			[
				'label' => esc_html__('Title Text', 'apeix-core'),
				'type' => Controls_Manager::TEXT,
				'default' => esc_html__('Title Text', 'apeix-core'),
				'placeholder' => esc_html__('Type title text here', 'apeix-core'),
				'label_block' => true,
			]
		);
		$this->add_control(
			'about_content',
			[
				'label' => esc_html__('Content', 'apeix-core'),
				'default' => esc_html__('your content text', 'apeix-core'),
				'placeholder' => esc_html__('Type your content here', 'apeix-core'),
				'type' => Controls_Manager::TEXTAREA,
				'label_block' => true,
			]
		);
		$this->add_control(
			'about_image',
			[
				'label' => esc_html__('About Image', 'apeix-core'),
				'type' => Controls_Manager::MEDIA,
				'frontend_available' => true,
				'default' => [
					'url' => Utils::get_placeholder_image_src(),
				],
				'description' => esc_html__('Set your image.', 'apeix-core'),
			]
		);
		$this->add_control(
			'btn_text',
			[
				'label' => esc_html__('Button/Link Text', 'apeix-core'),
				'type' => Controls_Manager::TEXT,
				'default' => esc_html__('Button Text', 'apeix-core'),
				'placeholder' => esc_html__('Type btn text here', 'apeix-core'),
				'label_block' => true,
			]
		);
		$this->add_control(
			'btn_link',
			[
				'label' => esc_html__('Button Link', 'apeix-core'),
				'type' => Controls_Manager::URL,
				'placeholder' => 'https://your-link.com',
				'default' => [
					'url' => '',
				],
				'label_block' => true,
			]
		);
		$repeater = new Repeater();
		$repeater->add_control(
			'feature_icon',
			[
				'label' => __('Icon', 'apeix-core'),
				'type' => \Elementor\Controls_Manager::ICONS,
				'default' => [
					'value' => 'flaticon-electricity',
					'library' => 'solid',
				],
			]
		);
		$repeater->add_control(
			'feature_title',
			[
				'label' => esc_html__('Title Text', 'apeix-core'),
				'type' => Controls_Manager::TEXT,
				'default' => esc_html__('High Quality Service', 'apeix-core'),
				'placeholder' => esc_html__('Type title text here', 'apeix-core'),
				'label_block' => true,
			]
		);
		$repeater->add_control(
			'feature_content',
			[
				'label' => esc_html__('Content Text', 'apeix-core'),
				'type' => Controls_Manager::TEXTAREA,
				'default' => esc_html__('Content Text', 'apeix-core'),
				'placeholder' => esc_html__('Type title Content here', 'apeix-core'),
				'label_block' => true,
			]
		);
		$this->add_control(
			'featureinfoItems_groups',
			[
				'label' => esc_html__('Contact Info Items', 'apeix-core'),
				'type' => Controls_Manager::REPEATER,
				'default' => [
					[
						'feature_title' => esc_html__('Contact Info', 'apeix-core'),
					],

				],
				'fields' =>  $repeater->get_controls(),
				'title_field' => '{{{ feature_title }}}',
			]
		);
		$this->end_controls_section(); // end: Section


		// Title
		$this->start_controls_section(
			'section_title_style',
			[
				'label' => esc_html__('Title', 'apeix-core'),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'label' => esc_html__('Typography', 'apeix-core'),
				'name' => 'apeix_title_typography',
				'selector' => '{{WRAPPER}} .hx-about-content h2',
			]
		);
		$this->add_control(
			'title_color',
			[
				'label' => esc_html__('Color', 'apeix-core'),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .hx-about-content h2' => 'color: {{VALUE}};',
				],
			]
		);
		$this->add_control(
			'title_padding',
			[
				'label' => esc_html__('Title Padding', 'apeix-core'),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', 'em'],
				'selectors' => [
					'{{WRAPPER}} .hx-about-content h2' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		$this->end_controls_section(); // end: Section

		// Content
		$this->start_controls_section(
			'section_content_style',
			[
				'label' => esc_html__('Content', 'apeix-core'),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'label' => esc_html__('Typography', 'apeix-core'),
				'name' => 'section_content_typography',
				'selector' => '{{WRAPPER}} .hx-about-area .hx-about-content > p',
			]
		);
		$this->add_control(
			'content_color',
			[
				'label' => esc_html__('Color', 'apeix-core'),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .hx-about-area .hx-about-content > p' => 'color: {{VALUE}};',
				],
			]
		);
		$this->add_responsive_control(
			'content_padding',
			[
				'label' => esc_html__('Padding', 'apeix-core'),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', 'em'],
				'selectors' => [
					'{{WRAPPER}} .hx-about-area .hx-about-content > p' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		$this->end_controls_section(); // end: Section


		// Icon
		$this->start_controls_section(
			'section_icon_style',
			[
				'label' => esc_html__('Icon', 'apeix-core'),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'label' => esc_html__('Typography', 'apeix-core'),
				'name' => 'apeix_icon_typography',
				'selector' => '{{WRAPPER}} .hx-about-icon .fi',
			]
		);
		$this->add_control(
			'icon_color',
			[
				'label' => esc_html__('Color', 'apeix-core'),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .hx-about-icon .fi' => 'color: {{VALUE}};',
				],
			]
		);
		$this->add_responsive_control(
			'icon_padding',
			[
				'label' => esc_html__('Sub Title Padding', 'apeix-core'),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', 'em'],
				'selectors' => [
					'{{WRAPPER}} .hx-about-icon .fi' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		$this->end_controls_section(); // end: Section

		// Feature
		$this->start_controls_section(
			'section_feature_title_style',
			[
				'label' => esc_html__('Feature Title', 'apeix-core'),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'label' => esc_html__('Typography', 'apeix-core'),
				'name' => 'section_feature_title_typography',
				'selector' => '{{WRAPPER}} .hx-about-content h4',
			]
		);
		$this->add_control(
			'feature_title_color',
			[
				'label' => esc_html__('Color', 'apeix-core'),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .hx-about-content h4' => 'color: {{VALUE}};',
				],
			]
		);
		$this->add_control(
			'feature_title_padding',
			[
				'label' => esc_html__('Title Padding', 'apeix-core'),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', 'em'],
				'selectors' => [
					'{{WRAPPER}} .hx-about-content h4' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		$this->end_controls_section(); // end: Section

		// Feature Paragraph
		$this->start_controls_section(
			'section_feature_desc_style',
			[
				'label' => esc_html__('Paragraph', 'apeix-core'),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'label' => esc_html__('Typography', 'apeix-core'),
				'name' => 'section_feature_desc_typography',
				'selector' => '{{WRAPPER}} .hx-about-text > p',
			]
		);
		$this->add_control(
			'feature_desc_color',
			[
				'label' => esc_html__('Color', 'apeix-core'),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .hx-about-text > p' => 'color: {{VALUE}};',
				],
			]
		);
		$this->add_control(
			'feature_desc_padding',
			[
				'label' => esc_html__('Padding', 'apeix-core'),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', 'em'],
				'selectors' => [
					'{{WRAPPER}} .hx-about-text > p' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		$this->end_controls_section(); // end: Section


		// Button
		$this->start_controls_section(
			'section_button_style',
			[
				'label' => esc_html__('Button', 'apeix-core'),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'button_typography',
				'selector' => '{{WRAPPER}} .about-btns .theme-btn-s2',
			]
		);

		$this->start_controls_tabs('button_one_style');
		$this->start_controls_tab(
			'button_one_normal',
			[
				'label' => esc_html__('Normal', 'apeix-core'),
			]
		);
		$this->add_control(
			'button_color',
			[
				'label' => esc_html__('Color', 'apeix-core'),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .about-btns .theme-btn-s2' => 'color: {{VALUE}};',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Background::get_type(),
			[
				'name' => 'button_bg_color',
				'label' => esc_html__('Button BG Color', 'apeix-core'),
				'types' => ['gradient'],
				'selector' => '{{WRAPPER}} .about-btns .theme-btn-s2',
			]
		);
		$this->add_control(
			'button_padding',
			[
				'label' => __('Padding', 'apeix-core'),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', 'em'],
				'selectors' => [
					'{{WRAPPER}} .about-btns .theme-btn-s2' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		$this->end_controls_tab();  // end:Normal tab

		$this->start_controls_tab(
			'button_hover',
			[
				'label' => esc_html__('Hover', 'apeix-core'),
			]
		);
		$this->add_control(
			'button_hover_color',
			[
				'label' => esc_html__('Color', 'apeix-core'),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .about-btns .theme-btn-s2:hover' => 'color: {{VALUE}};',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Background::get_type(),
			[
				'name' => 'button_bg_hover_color',
				'label' => esc_html__('Button BG Color', 'apeix-core'),
				'types' => ['gradient'],
				'selector' => '{{WRAPPER}} .about-btns .theme-btn-s2:hover',
			]
		);
		$this->end_controls_tab();  // end:Hover tab
		$this->end_controls_tabs(); // end tabs

		$this->end_controls_section(); // end: Section

	}

	/**
	 * Render About widget output on the frontend.
	 * Written in PHP and used to generate the final HTML.
	 */
	protected function render()
	{
		$settings = $this->get_settings_for_display();
		$featureinfoItems_groups = !empty($settings['featureinfoItems_groups']) ? $settings['featureinfoItems_groups'] : [];

		$about_title = !empty($settings['about_title']) ? $settings['about_title'] : '';
		$about_content = !empty($settings['about_content']) ? $settings['about_content'] : '';

		$bg_image = !empty($settings['about_image']['id']) ? $settings['about_image']['id'] : '';
		// Image
		$image_url = wp_get_attachment_url($bg_image);
		$image_alt = get_post_meta($bg_image, '_wp_attachment_image_alt', true);

		$btn_text = !empty($settings['btn_text']) ? $settings['btn_text'] : '';
		$btn_paragraph = !empty($settings['btn_paragraph']) ? $settings['btn_paragraph'] : '';

		$btn_link = !empty($settings['btn_link']['url']) ? $settings['btn_link']['url'] : '';
		$btn_external = !empty($settings['btn_link']['is_external']) ? 'target="_blank"' : '';
		$btn_nofollow = !empty($settings['btn_link']['nofollow']) ? 'rel="nofollow"' : '';
		$btn_link_attr = !empty($btn_link) ?  $btn_external . ' ' . $btn_nofollow : '';

		$button = $btn_link ? '<a href="' . esc_url($btn_link) . '" ' . esc_attr($btn_link_attr) . ' class="theme-btn-s2" >' . esc_html($btn_text) . '</a>' : '';
		// Turn output buffer on
		ob_start(); ?>

		<div class="hx-about-area">
			<div class="container">
				<div class="row">
					<div class="col-md-6 col-sm-16 col-xs-12">
						<div class="hx-about-img">
							<?php if ($image_url) {
								echo '<img src="' . esc_url($image_url) . '" alt="' . esc_url($image_alt) . '">';
							} ?>
						</div>
					</div>
					<div class="col-md-6 col-sm-16 col-xs-12">

						<div class="hx-about-content">
							<?php
							if ($about_title) {
								echo '<h2>' . esc_html($about_title) . '</h2>';
							}
							if ($about_content) {
								echo '<p>' . esc_html($about_content) . '</p>';
							}
							?>
							<?php 	// Group Param Output
							if (is_array($featureinfoItems_groups) && !empty($featureinfoItems_groups)) {
								foreach ($featureinfoItems_groups as $each_items) {
									$feature_content = !empty($each_items['feature_content']) ? $each_items['feature_content'] : '';
									$feature_title = !empty($each_items['feature_title']) ? $each_items['feature_title'] : '';

									$feature_icon = !empty($each_items['feature_icon']['value']) ? $each_items['feature_icon']['value'] : '';
									$feature_svg_url = !empty($each_items['feature_icon']['value']['url']) ? $each_items['feature_icon']['value']['url'] : '';
									$svg_alt = get_post_meta($feature_svg_url, '_wp_attachment_image_alt', true);

							?>
									<div class="hx-about-wrap">
										<div class="hx-about-icon">
											<?php if ($feature_svg_url) {
												echo '<img src="' . esc_url($feature_svg_url) . '" alt="' . esc_url($svg_alt) . '">';
											} else {
												echo ' <i class="fi ' . esc_attr($feature_icon) . '"></i>';
											} ?>
										</div>
										<div class="hx-about-text">
											<?php
											if ($feature_title) {
												echo '<h4>' . esc_html($feature_title) . '</h4>';
											}
											if ($feature_content) {
												echo '<p>' . esc_html($feature_content) . '</p>';
											}
											?>
										</div>
									</div>
							<?php }
							} ?>
							<div class="about-btns">
								<?php echo $button; ?>
							</div>

						</div>
					</div>
				</div>
			</div>
		</div>
<?php // Return outbut buffer
		echo ob_get_clean();
	}
	/**
	 * Render About widget output in the editor.
	 * Written as a Backbone JavaScript template and used to generate the live preview.
	 */

	//protected function _content_template(){}

}
Plugin::instance()->widgets_manager->register(new Apeix_About());
