/*
Template Name: Apeix
Author: wpoceans
Version: 1.0
*/

(function($){
'use strict';

/*----- ELEMENTOR LOAD FUNTION CALL ---*/

$( window ).on( 'elementor/frontend/init', function() {

	var hero_slider = function(){

     // HERO SLIDER
            var menu = [];
            jQuery('.swiper-slide').each( function(index){
                menu.push( jQuery(this).find('.slide-inner').attr("data-text") );
            });
            var interleaveOffset = 0.5;
            var swiperOptions = {
                loop: true,
                speed: 1000,
                parallax: true,
                autoplay: {
                    delay: 650000,
                    disableOnInteraction: false,
                },
                watchSlidesProgress: true,
                pagination: {
                    el: '.swiper-pagination',
                    clickable: true,
                },

                navigation: {
                    nextEl: '.swiper-button-next',
                    prevEl: '.swiper-button-prev',
                },

                on: {
                    progress: function() {
                        var swiper = this;
                        for (var i = 0; i < swiper.slides.length; i++) {
                            var slideProgress = swiper.slides[i].progress;
                            var innerOffset = swiper.width * interleaveOffset;
                            var innerTranslate = slideProgress * innerOffset;
                            swiper.slides[i].querySelector(".slide-inner").style.transform =
                            "translate3d(" + innerTranslate + "px, 0, 0)";
                        }      
                    },

                    touchStart: function() {
                      var swiper = this;
                      for (var i = 0; i < swiper.slides.length; i++) {
                        swiper.slides[i].style.transition = "";
                      }
                    },

                    setTransition: function(speed) {
                        var swiper = this;
                        for (var i = 0; i < swiper.slides.length; i++) {
                            swiper.slides[i].style.transition = speed + "ms";
                            swiper.slides[i].querySelector(".slide-inner").style.transition =
                            speed + "ms";
                        }
                    }
                }
            };

            var swiper = new Swiper(".swiper-container", swiperOptions);

    }; // end

  
    var sliderBgSetting = function(){
     
        // SLIDER BACKGROUND IMAGE
        var sliderBgSetting = $(".slide-bg-image");
        sliderBgSetting.each(function(indx){
            if ($(this).attr("data-background")){
                $(this).css("background-image", "url(" + $(this).data("background") + ")");
            }
        });

    }; // end

    var services_slider = function(){
     
       /*------------------------------------------
        = SERVICE SLIDER
        -------------------------------------------*/
        if ($(".service-slider").length) {
            $(".service-slider").owlCarousel({
                autoplay:true,
                smartSpeed: 300,
                margin: 30,
                stagePadding: 15,
                loop:true,
                autoplayHoverPause:true,
                responsive: {
                    0 : {
                        items: 1
                    },

                    650 : {
                        items: 2
                    },

                    992 : {
                        items: 2
                    },

                    1200 : {
                        items: 3
                    }
                }
            });
        }

    }; // end


    var testimonials_slider = function(){
   
       if ($(".wpo-testimonial-active").length) {
            $(".wpo-testimonial-active").owlCarousel({
                loop: true,
                margin: 30,
                nav: false,
                items: 5,
                smartSpeed: 2000,
                dots: true,
                autoplay: false,
                autoplayTimeout: 5000,
                responsive: {
                    0: {
                        items: 1
                    },
                    480: {
                        items: 1
                    },
                    760: {
                        items: 2
                    },
                    1080: {
                        items: 2
                    }
                }
            });
        }

    }; // end
    
    var projects_slider = function(){
   
   /*================================
      Isotope Portfolio
     ==================================*/
    $('.grid-2').imagesLoaded(function() {

        // filter items on button click
        $('.wpo-projects-menu').on('click', 'button', function() {
            var filterValue = $(this).attr('data-filter');
            $grid.isotope({
                filter: filterValue
            });
        });

        // init Isotope
        var $grid = $('.grid-2').isotope({
            itemSelector: '.grid-item',
            percentPosition: true,
            masonry: {
                // use outer width of grid-sizer for columnWidth
                columnWidth: '.grid-item',
            }
        });



    });

    $('.wpo-projects-menu button').on('click', function() {
        $('.wpo-projects-menu button').removeClass('active');
        $(this).addClass('active');
    });


    }; // end
    
    var team_slider = function(){
   
  /*------------------------------------------
        = TEAM SLIDER
    -------------------------------------------*/
    if ($(".team-slider").length) {
        $(".team-slider").owlCarousel({
            autoplay:true,
            smartSpeed: 300,
            margin: 30,
            stagePadding: 15,
            loop:true,
            autoplayHoverPause:true,
            responsive: {
                0 : {
                    items: 1
                },

                600 : {
                    items: 2
                },

                992 : {
                    items: 3
                },

                1200 : {
                    items: 4
                }
            }
        });
    }

    }; // end


    
    var odometer = function(){

       
        /*------------------------------------------
            = FUNFACT
        -------------------------------------------*/
        if ($(".odometer").length) {
            $('.odometer').appear();
            $(document.body).on('appear', '.odometer', function(e) {
                var odo = $(".odometer");
                odo.each(function() {
                    var countNumber = $(this).attr("data-count");
                    $(this).html(countNumber);
                });
            });
        }



    }; // end


    var partners_slider = function(){

       /*------------------------------------------
        = PARTNERS SLIDER
        -------------------------------------------*/
        if ($(".partners-slider").length) {
            $(".partners-slider").owlCarousel({
                autoplay:true,
                smartSpeed: 300,
                margin: 30,
                loop:true,
                autoplayHoverPause:true,
                dots: false,
                responsive: {
                    0 : {
                        items: 2
                    },

                    550 : {
                        items: 3
                    },

                    992 : {
                        items: 4
                    },

                    1200 : {
                        items: 5
                    }
                }
            });
        }



    }; // end



	//Slider
	elementorFrontend.hooks.addAction( 'frontend/element_ready/tmx-apeix_slider.default', function($scope, $){
		hero_slider();
	} );
    
    //sliderBgSetting
    elementorFrontend.hooks.addAction( 'frontend/element_ready/tmx-apeix_slider.default', function($scope, $){
        sliderBgSetting();
    } );

    //services_slider
    elementorFrontend.hooks.addAction( 'frontend/element_ready/tmx-apeix_service.default', function($scope, $){
        services_slider();
    } );

    //projects
    elementorFrontend.hooks.addAction( 'frontend/element_ready/tmx-apeix_project.default', function($scope, $){
        projects_slider();
    } );

    //testimonials_slider
    elementorFrontend.hooks.addAction( 'frontend/element_ready/tmx-apeix_testimonial.default', function($scope, $){
        testimonials_slider();
    } );

    //team_slider
    elementorFrontend.hooks.addAction( 'frontend/element_ready/tmx-apeix_team.default', function($scope, $){
        team_slider();
    } );

    //odometer
    elementorFrontend.hooks.addAction( 'frontend/element_ready/wpo-apeix_funfact.default', function($scope, $){
        odometer();
    } );

    //partners_slider
    elementorFrontend.hooks.addAction( 'frontend/element_ready/tmx-apeix_client.default', function($scope, $){
        partners_slider();
    } );

	
} );


})(jQuery);  