<?php
/*
Plugin Name: Apeix Core
Plugin URI: http://themeforest.net/user/helloexpert
Description: Plugin to contain shortcodes and custom post types of the apeix theme.
Author: helloexpert
Author URI: http://themeforest.net/user/helloexpert/portfolio
Version: 2.0.2
Text Domain: apeix-core
*/

if (!function_exists('apeix_block_direct_access')) {
  function apeix_block_direct_access()
  {
    if (!defined('ABSPATH')) {
      exit('Forbidden');
    }
  }
}

// Plugin URL
define('APEIX_PLUGIN_URL', plugins_url('/', __FILE__));

// Plugin PATH
define('APEIX_PLUGIN_PATH', plugin_dir_path(__FILE__));
define('APEIX_PLUGIN_ASTS', APEIX_PLUGIN_URL . 'assets');
define('APEIX_PLUGIN_IMGS', APEIX_PLUGIN_ASTS . '/images');
define('APEIX_PLUGIN_INC', APEIX_PLUGIN_PATH . 'include');

// DIRECTORY SEPARATOR
define('DS', DIRECTORY_SEPARATOR);


// APEIX Elementor Shortcode Path
define('APEIX_EM_SHORTCODE_BASE_PATH', APEIX_PLUGIN_PATH . 'elementor/');
define('APEIX_EM_SHORTCODE_PATH', APEIX_EM_SHORTCODE_BASE_PATH . 'widgets/');


/**
 * Check if Codestar Framework is Active or Not!
 */
function apeix_framework_active()
{
  return (defined('CS_VERSION')) ? true : false;
}

/* APEIX_THEME_NAME_PLUGIN */
define('APEIX_THEME_NAME_PLUGIN', 'Apeix');

// Initial File
include_once(ABSPATH . 'wp-admin/includes/plugin.php');
if (is_plugin_active('apeix-core/apeix-core.php')) {

  // Custom Post Type
  require_once(APEIX_PLUGIN_INC . '/custom-post-type.php');

  if (is_plugin_active('kingcomposer/kingcomposer.php')) {

    define('APEIX_KC_SHORTCODE_BASE_PATH', APEIX_PLUGIN_PATH . 'kc/');
    define('APEIX_KC_SHORTCODE_PATH', APEIX_KC_SHORTCODE_BASE_PATH . 'shortcodes/');
    // Shortcodes
    require_once(APEIX_KC_SHORTCODE_BASE_PATH . '/kc-setup.php');
    require_once(APEIX_KC_SHORTCODE_BASE_PATH . '/library.php');
  }

  // Theme Custom Shortcode
  require_once(APEIX_PLUGIN_INC . '/custom-shortcodes/theme-shortcodes.php');
  require_once(APEIX_PLUGIN_INC . '/custom-shortcodes/custom-shortcodes.php');

  // Importer
  require_once(APEIX_PLUGIN_INC . '/demo/importer.php');


  if (class_exists('WP_Widget') && is_plugin_active('codestar-framework/cs-framework.php')) {
    // Widgets

    require_once(APEIX_PLUGIN_INC . '/widgets/nav-widget.php');
    require_once(APEIX_PLUGIN_INC . '/widgets/recent-posts.php');
    require_once(APEIX_PLUGIN_INC . '/widgets/footer-posts.php');
    require_once(APEIX_PLUGIN_INC . '/widgets/text-widget.php');
    require_once(APEIX_PLUGIN_INC . '/widgets/widget-extra-fields.php');

    // Elementor
    if (file_exists(APEIX_EM_SHORTCODE_BASE_PATH . '/em-setup.php')) {
      require_once(APEIX_EM_SHORTCODE_BASE_PATH . '/em-setup.php');
      require_once(APEIX_EM_SHORTCODE_BASE_PATH . 'lib/fields/icons.php');
      require_once(APEIX_EM_SHORTCODE_BASE_PATH . 'lib/icons-manager/icons-manager.php');
    }
  }

  add_action('wp_enqueue_scripts', 'apeix_plugin_enqueue_scripts');
  function apeix_plugin_enqueue_scripts()
  {
    wp_enqueue_script('plugin-scripts', APEIX_PLUGIN_ASTS . '/plugin-scripts.js', array('jquery'), '', true);
  }
}

// Extra functions
require_once(APEIX_PLUGIN_INC . '/theme-functions.php');
