<?php
/* ==========================================================
  Workprocess
=========================================================== */
if ( !function_exists('apeix_work_function')) {
  function apeix_work_function( $atts, $content = NULL ) {
    extract($atts);

    $e_uniqid       = uniqid();
    $inline_style   = '';
    if ( $title_size || $title_color ) {
      $inline_style .= '.work-process-section-'. $e_uniqid .' .workprocess-grids h3 {';
      $inline_style .= $title_size ? 'font-size: '. apeix_plugin_check_px($title_size) .';': '';
      $inline_style .= ( $title_color ) ? 'color:'. $title_color .';' : '';
      $inline_style .= '}';
    }
    if ( $desc_size || $desc_color ) {
      $inline_style .= '.work-process-section-'. $e_uniqid .' .workprocess-grids p {';
      $inline_style .= $desc_size ? 'font-size: '. apeix_plugin_check_px($desc_size) .';': '';
      $inline_style .= ( $desc_color ) ? 'color:'. $desc_color .';' : '';
      $inline_style .= '}';
    }
    if ( $icon_color ) {
      $inline_style .= '.work-process-section-'. $e_uniqid .' .workprocess-grids .grid .icon i:before  {';
      $inline_style .= ( $icon_color ) ? 'color:'. $icon_color .';' : '';
      $inline_style .= '}';
    }
    if ( $bg_color ) {
      $inline_style .= '.work-process-section-'. $e_uniqid .' .workprocess-grids .grid .icon {';
      $inline_style .= ( $bg_color ) ? 'background-color:'. $bg_color .';' : '';
      $inline_style .= '}';
    }
    // add inline style
    add_inline_style( $inline_style );
    $styled_class  = ' work-process-section-'. $e_uniqid.' ';
    $work_items = ( $work_items ) ? (array) $work_items : array();

  ob_start(); ?>
<section class="work-process-section <?php echo esc_attr( $class.$styled_class ); ?>">
   <div class="row">
      <div class="col col-xs-12">
         <div class="workprocess-grids clearfix">
          <?php if ( $work_items ) {
            foreach ( $work_items as $key => $work_item ) { ?>
            <div class="grid">
               <div class="icon">
                  <i class="fi <?php echo esc_attr( $work_item->icon ); ?>"></i>
               </div>
               <h3><?php echo esc_html( $work_item->title ); ?></h3>
                <p><?php echo esc_html( $work_item->desc ); ?></p>
            </div>
          <?php } } ?>
         </div>
      </div>
   </div>
</section>
 <?php return ob_get_clean();
  }
}
add_shortcode( 'xzb_work', 'apeix_work_function' );
