<?php
/* ==========================================================
  Accordion Info
=========================================================== */
if ( !function_exists('apeix_title_shortcode_function')) {
  function apeix_title_shortcode_function( $atts, $content = true ) {
  	extract($atts);
  	$uniqid = uniqid( '-', false);
  	$inline_style = '';
  if ( $title_color || $title_size ) {
      $inline_style .= '.section-title-area'.$uniqid.'.apeix-title h2 {';
      $inline_style .= $title_color ? 'color: '.$title_color.'; ' : '';
      $inline_style .= $title_size ? 'font-size: '.$title_size.'; ' : '';
      $inline_style .= '}';
    }

  if ( $subtitle_color || $subtitle_size ) {
      $inline_style .= '.section-title-area'.$uniqid.'.apeix-title span {';
      $inline_style .= $subtitle_color ? 'color: '.$subtitle_color.'; ' : '';
      $inline_style .= $subtitle_size ? 'font-size: '.$subtitle_size.'; ' : '';
      $inline_style .= '}';
    }

  if ( $desc_color || $desc_size ) {
      $inline_style .= '.section-title-area'.$uniqid.'.apeix-title  p {';
      $inline_style .= $desc_color ? 'color: '.$desc_color.'; ' : '';
      $inline_style .= $desc_size ? 'font-size: '.$desc_size.'; ' : '';
      $inline_style .= '}';
    }

  if ( $use_line != 'yes') {
      $inline_style .= '.section-title-area'.$uniqid.'.apeix-title span:after,.section-title-area'.$uniqid.'.apeix-title span:before {';
      $inline_style .= 'content: none;';
      $inline_style .= '}';
    } else {
      if ( $line_color ) {
        $inline_style .= '.section-title-area'.$uniqid.'.apeix-title span:before,.section-title-area'.$uniqid.'.apeix-title span:after {';
        $inline_style .= $line_color? 'background-color: '.$line_color.'; ' : '';
        $inline_style .= '}';
      }
    }

  	// integrate css
  	add_inline_style( $inline_style );
  	$inline_class = ' section-title-area'.$uniqid;

    if ( $title_style == 'standard' ) {
      $title_col = 'col col-md-4 col-sm-5';
      $title_class = ' section-title';
    } elseif ( $title_style == 'classic' ) {
      $title_col = 'col col-md-6 col-sm-8 ';
      $title_class = ' section-title';
    } else {
      $title_col = 'col col-md-8 col-md-offset-2 col-sm-10 col-sm-offset-1';
      $title_class = ' section-title-s2 text-center';
    }

    $title = preg_replace('~\s*<br ?/?>\s*~',"<br />",$title);
    $title = nl2br($title);
    ob_start(); ?>
    <div class="section-title-area apeix-title <?php echo esc_attr( $class.$inline_class ); ?>">
      <div class="row">
          <div class="<?php echo esc_attr( $title_col ); ?>">
              <div class="<?php echo esc_attr( $title_class ); ?>">
                  <?php if ( $subtitle ) { ?>
                      <span><?php echo esc_html( $subtitle ); ?></span>
                    <?php }
                    if ( $title ) { ?>
                      <h2><?php echo wp_kses_post( $title ); ?></h2>
                   <?php }
                   if ( $desc ) { ?>
                      <p><?php echo esc_html( $desc ) ?></p>
                  <?php } ?>
              </div>
          </div>
      </div>
    </div>
   <?php return ob_get_clean();
  }
}
add_shortcode( 'section_title', 'apeix_title_shortcode_function' );