<?php
if (!function_exists( 'apeix_section_title_kc_map' ) ) {
  add_action('init', 'apeix_section_title_kc_map', 99 );
  function apeix_section_title_kc_map() {
    kc_add_map(
      array(
        'section_title' => array(
          'name' => esc_html__('Apeix Title', 'apeix-core'),
          'description' => esc_html__( 'Apeix Title Styles', 'apeix-core' ),
          'category' => ApeixLibrary::apeix_kc_cat_name(),
          'icon' => 'cpicon kc-icon-title',
          'title' => esc_html__('Title Settings', 'apeix-core'),
          'is_container' => true,
          'priority'  => 130,
          'params' => array(
            esc_html__( 'General', 'apeix-core' ) => array(
              array(
                'name' => 'title_style',
                'label' => esc_html__('Title Style', 'apeix-core'),
                'type' => 'select',
                'options' => array(
                  'standard' => esc_html__( 'Standard', 'apeix-core' ),
                  'classic' => esc_html__( 'Classic', 'apeix-core' ),
                  'center' => esc_html__( 'Center', 'apeix-core' ),
                ),
                'admin_label' => true,
              ),
              array(
                'name' => 'subtitle',
                'label' => esc_html__('Sub Title', 'apeix-core'),
                'type' => 'text',
                'admin_label' => true
              ),
              array(
                'name' => 'title',
                'label' => esc_html__('Title', 'apeix-core'),
                'type' => 'textarea',
                'admin_label' => true,
              ),
              array(
                'name' => 'desc',
                'label' => esc_html__('Description', 'apeix-core'),
                'type' => 'textarea',
                'admin_label' => true,
              ),
              array(
                'name' => 'class',
                'label' => esc_html__(' Extra class name', 'apeix-core'),
                'type' => 'text',
                'description' => esc_html__(' ', 'apeix-core')
              )
            ),
            esc_html__( 'Style', 'apeix-core' ) => array(
            array(
                'name' => 'title_color',
                'label' => esc_html__(' Title Color', 'apeix-core'),
                'type' => 'color_picker'
              ),
              array(
                'name' => 'title_size',
                'label' => esc_html__(' Title Size', 'apeix-core'),
                'type' => 'number_slider',
                'options' => array(
                  'min' => 15,
                  'max' => 60,
                  'unit' => 'px',
                  'show_input' => true
                ),
              ),
             array(
                'name' => 'subtitle_color',
                'label' => esc_html__('Sub Title Color', 'apeix-core'),
                'type' => 'color_picker'
              ),
              array(
                'name' => 'subtitle_size',
                'label' => esc_html__('Sub Title Size', 'apeix-core'),
                'type' => 'number_slider',
                'options' => array(
                  'min' => 15,
                  'max' => 60,
                  'unit' => 'px',
                  'show_input' => true
                ),
              ),
             array(
                'name' => 'desc_color',
                'label' => esc_html__('Description Title Color', 'apeix-core'),
                'type' => 'color_picker'
              ),
              array(
                'name' => 'desc_size',
                'label' => esc_html__('Description Title Size', 'apeix-core'),
                'type' => 'number_slider',
                'options' => array(
                  'min' => 15,
                  'max' => 60,
                  'unit' => 'px',
                  'show_input' => true
                ),
              ),
              array(
                'name' => 'use_line',
                'type' => 'toggle',
                'value'     => 'yes',
                'label' => esc_html__( 'Section line', 'apeix-core' ),
                'description' => esc_html__('Turn On if you want to Show Section line.', 'apeix-core'),
              ),
              array(
                'name' => 'line_color',
                'label' => esc_html__('Title Line Color', 'apeix-core'),
                'type' => 'color_picker'
              ),
            ),
          )
        ),
      )
    ); // End add map
  }
} // End if