<?php
add_action('init', 'apeix_tabs_kc_map', 99 );
function apeix_tabs_kc_map() {

	if (function_exists('kc_add_map')){
	    kc_add_map(
	        array(
	            'ole_tabs' => array(
	                'name' => esc_html__('Tabs','apeix-core'),
	                'description' => esc_html__('Display single icon', 'apeix-core'),
	                'icon' => 'cpicon kc-icon-tabs',
	                'category' => ApeixLibrary::apeix_kc_cat_name(),
	                'params' => array(
                  'Content' => array(
                    array(
                        'type'          => 'group',
                        'label'         => esc_html__(' Options', 'apeix-core'),
                        'name'          => 'tabs_items',
                        'description'   => esc_html__( 'Items Group Field', 'apeix-core' ),
                        'options'       => array('add_text' => esc_html__(' Add new Accordion', 'apeix-core')),
                        'params' => array(
                        array(
                            'name' => 'tab_title',
                            'label' => esc_html__( 'Tabs Title','apeix-core'),
                            'type' => 'text',
                            'admin_label' => true,
                            'description' => esc_html__('Write Tabs Title Here', 'apeix-core'),
                          ),
                        array(
                            'name' => 'tab_desc',
                            'label' => esc_html__( 'Tabs Description','apeix-core'),
                            'type' => 'editor',
                            'admin_label' => true,
                            'description' => esc_html__('Write Tabs Description Here', 'apeix-core'),
                          ),
                          array(
                            'name' => 'active_tabs',
                            'type' => 'toggle',
                            'label' => esc_html__( 'Active Tab', 'apeix-core' ),
                            'description' => esc_html__('Please Turn On to active Accordion, Please Only One Accordion turn on, Otherwise tab stop working', 'apeix-core'),
                          ),
                        ),
                      ),
                    ),
                    'Style' => array(
	                    array(
                        'name' => 'class',
                        'label' => esc_html__('Extra Class','apeix-core'),
                        'type' => 'text',
                        'admin_label' => true,
                        'description' => esc_html__('Enter Extra Class for Titlte ..', 'apeix-core')
                      ),
                     array(
                        'name' => 'title_size',
                        'label' => esc_html__('Title Text Size', 'apeix-plugin'),
                        'type' => 'number_slider',
                        'options' => array(
                          'min' => 10,
                          'max' => 60,
                          'unit' => 'px',
                          'show_input' => true
                        ),
                       ),
                     array(
                        'name' => 'title_color',
                        'label' => esc_html__('Title Color','apeix-core'),
                        'type' => 'color_picker',
                        'admin_label' => true,
                        'description' => esc_html__('Set color for title', 'apeix-core')
                     ),
                    array(
                        'name' => 'desc_color',
                        'label' => esc_html__('Accordion Description Text Color','apeix-core'),
                        'type' => 'color_picker',
                        'admin_label' => true,
                        'description' => esc_html__('Set color for Accordion Description Text', 'apeix-core')
                      ),
                     array(
                        'name' => 'title_border',
                        'label' => esc_html__('Tab title border Color','apeix-core'),
                        'type' => 'color_picker',
                        'admin_label' => true,
                        'description' => esc_html__('Set Tab title border Color', 'apeix-core')
                     ),
                     array(
                        'name' => 'title_active',
                        'label' => esc_html__('Title Background Active Color','apeix-core'),
                        'type' => 'color_picker',
                        'admin_label' => true,
                        'description' => esc_html__('Set Background active color for title', 'apeix-core')
                     ),
		                )
	                )
	            ),  // End of elemnt kc_icon
	        )
	    ); // End add map
	} // End if
}
