<?php
if (!function_exists('apeix_slider_function')) {
    add_shortcode( 'mtc_slider', 'apeix_slider_function' );
    function apeix_slider_function($atts, $content ){
      extract($atts);

      $e_uniqid       = uniqid();
      $inline_style   = '';
     
      if ( $title_size || $title_color ) {
        $inline_style .= '.apeix-hero-'.$e_uniqid .'.hero-slider .slide-title > h2 {';
        $inline_style .= ( $title_size ) ? 'font-size:'.apeix_core_check_px($title_size) .';' : '';
        $inline_style .= ( $title_color ) ? 'color:'. $title_color .';' : '';
        $inline_style .= '}';
      }

      if ( $subtitle_size || $subtitle_color ) {
        $inline_style .= '.apeix-hero-'.$e_uniqid .'.hero-slider .slide-text p {';
        $inline_style .= ( $subtitle_size ) ? 'font-size:'.apeix_core_check_px($subtitle_size) .';' : '';
        $inline_style .= ( $subtitle_color ) ? 'color:'. $subtitle_color .';' : '';
        $inline_style .= '}';
      }

      if ( $btn_size || $btn_color ) {
        $inline_style .= '.page-wraper .apeix-hero-'.$e_uniqid .'.hero-slider .slide-btns a.theme-btn {';
        $inline_style .= ( $btn_size ) ? 'font-size:'.apeix_core_check_px($btn_size) .';' : '';
        $inline_style .= ( $btn_color ) ? 'color:'. $btn_color .';' : '';
        $inline_style .= '}';
      }
      if ( $btn_color ) {
        $inline_style .= '.page-wraper .apeix-hero-'.$e_uniqid .'.hero-slider .slide-btns .hero-video-btn {';
        $inline_style .= ( $btn_color ) ? 'color:'. $btn_color .';' : '';
        $inline_style .= '}';
      }
 
      if ( $btn_bg_color ) {
        $inline_style .= '.page-wraper .apeix-hero-'.$e_uniqid .'.hero-slider .slide-btns a.theme-btn {';
        $inline_style .= ( $btn_bg_color ) ? 'background-color:'. $btn_bg_color .';' : '';
        $inline_style .= '}';
      }

      if ( $btn_bg_color ) {
        $inline_style .= '.page-wraper .apeix-hero-'.$e_uniqid .'.hero-slider .slide-video-btn a.video-btn {';
        $inline_style .= ( $btn_bg_color ) ? 'background-color:'. $btn_bg_color .';' : '';
        $inline_style .= '}';
      }
 
      if ( $nav_color ) {
        $inline_style .= '.page-wraper .apeix-hero-'.$e_uniqid .'.hero-slider .swiper-button-prev:before , .page-wraper .apeix-hero-'.$e_uniqid .'.hero-slider .swiper-button-next:before  {';
        $inline_style .= ( $nav_color ) ? 'color:'. $nav_color .';' : '';
        $inline_style .= '}';
      }
      if ( $nav_bgcolor ) {
        $inline_style .= '.page-wraper .apeix-hero-'.$e_uniqid .'.hero-slider .swiper-button-prev , .page-wraper .apeix-hero-'.$e_uniqid .'.hero-slider .swiper-button-next  {';
        $inline_style .= ( $nav_bgcolor ) ? 'background-color:'. $nav_bgcolor .';' : '';
        $inline_style .= '}';
      }

      if ( $slide_style == 'style_one' ) {
        $slide_class = '';
      } elseif( $slide_style == 'style_two' )  {
        $slide_class = ' hero-style-2 ';
      } else {
         $slide_class = ' hero-style-3 ';
      }

    $slider_items = ( $slider_items ) ? (array) $slider_items : array();
    // add inline style
    add_inline_style( $inline_style );
    $styled_class  = ' apeix-hero-'.$e_uniqid.' ';

    $stimage_url = wp_get_attachment_url( $slider_image );
    $stimage_alt = get_post_meta($slider_image, '_wp_attachment_image_alt', true);

  ob_start(); ?>
  <?php if ( $slide_style == 'style_one' ) { ?>
  <section class="hero-slider static-hero apeix-hero <?php echo esc_attr( $styled_class.$class ); ?>">
    <div class="hero-shape">
        <div></div>
        <div></div>
        <div></div>
    </div>
    <div class="hero-container">
        <div class="hero-inner">
            <div class="container">
               <?php if ( $title ) { ?>
                <div data-swiper-parallax="300" class="slide-title">
                    <h2><?php echo esc_html( $title ); ?></h2>
                </div>
               <?php } 
               if ( $subtitle ) { ?>
                <div data-swiper-parallax="400" class="slide-text">
                    <p><?php echo esc_html( $subtitle ); ?></p>
                </div>
                <?php } ?>
                <div class="clearfix"></div>
                <div data-swiper-parallax="500" class="slide-btns">
                  <?php if ( $button_text ) { ?>
                    <a href="<?php echo esc_attr( $button_link ); ?>" class="theme-btn">
                      <?php echo esc_html( $button_text ); ?>
                    </a>
                  <?php } 
                  ?>
                </div>
                <div class="consultant-pic">
                    <img src="<?php echo esc_url( $stimage_url ); ?>" alt="<?php echo esc_attr( $stimage_alt ); ?>">
                </div>
            </div>
        </div>
    </div>
</section>
<?php } else { ?>
<section class="hero-slider <?php echo esc_attr( $slide_class.$styled_class.$class ); ?>">
    <div class="swiper-container">
        <div class="swiper-wrapper">
          <?php if ( $slider_items ) {
            foreach ( $slider_items as $key => $slider_item ) {
            if ( isset( $slider_item->slider_image ) && !empty( $slider_item->slider_image ) ) {
            $image_url = wp_get_attachment_url( $slider_item->slider_image );
            $image_alt = get_post_meta($slider_item->slider_image, '_wp_attachment_image_alt', true);
            ?>
            <div class="swiper-slide">
                <div class="slide-inner slide-bg-image" data-background="<?php echo esc_url( $image_url ); ?>">
                    <div class="gradient-overlay"></div>
                    <div class="container">
                      <?php if ( $slider_item->title ) { ?>
                        <div data-swiper-parallax="300" class="slide-title">
                            <h2> <?php echo esc_html( $slider_item->title ); ?></h2>
                        </div>
                      <?php }
                      if ( $slider_item->subtitle ) { ?>
                        <div data-swiper-parallax="400" class="slide-text">
                            <p><?php echo esc_html( $slider_item->subtitle ); ?></p>
                        </div>
                      <?php } ?>
                        <div class="clearfix"></div>
                        <div data-swiper-parallax="500" class="slide-btns">
                          <?php if ( $slider_item->button_text ) { ?>
                            <a href="<?php echo esc_url( $slider_item->button_link ); ?>" class="theme-btn">
                              <?php echo esc_html( $slider_item->button_text ); ?>
                            </a>
                          <?php } 
                          if ( $slider_item->video_link ) { ?>
                            <div class="slide-video-btn">
								              <a href="<?php echo esc_url( $slider_item->video_link ); ?>" class="video-btn" data-type="iframe" tabindex="0"></a>
                              </div> 
                          <?php } ?>
                        </div>
                    </div>
                </div> <!-- end slide-inner -->
            </div><!-- end swiper-slide -->
        <?php } } } ?>
        </div>
        <!-- end swiper-wrapper -->
        <!-- swipper controls -->
        <div class="swiper-pagination"></div>
        <div class="swiper-button-next"></div>
        <div class="swiper-button-prev"></div>
    </div>
  </section>
  <?php } 
 return ob_get_clean();
  }
}