<?php
/* ==========================================================
  Service
=========================================================== */
if ( !function_exists('apeix_service_function')) {
  function apeix_service_function( $atts, $content = NULL ) {
    extract($atts);

    $e_uniqid       = uniqid();
    $inline_style   = '';

    if ( $icon_color || $icon_size ) {
      $inline_style .= '.apeix-services-'.$e_uniqid .'.apeix-services .sgrid .service-icon i:before {';
      $inline_style .= ( $icon_size ) ? 'font-size:'.apeix_core_check_px($icon_size) .';' : '';
      $inline_style .= ( $icon_color ) ? 'color:'. $icon_color .';' : '';
      $inline_style .= '}';
    }
    if ( $icon_bgcolor ) {
      $inline_style .= '.apeix-services-'.$e_uniqid .'.apeix-services .sgrid .service-icon {';
      $inline_style .= ( $icon_bgcolor ) ? 'background:'. $icon_bgcolor .';' : '';
      $inline_style .= '}';
    }
    if ( $title_color || $title_size ) {
      $inline_style .= '.apeix-services-'.$e_uniqid .'.apeix-services .sgrid .service-text h2 a {';
      $inline_style .= ( $title_size ) ? 'font-size:'.apeix_core_check_px($title_size) .';' : '';
      $inline_style .= ( $title_color ) ? 'color:'. $title_color .';' : '';
      $inline_style .= '}';
    }
    if ( $desc_color || $desc_size ) {
      $inline_style .= '.apeix-services-'.$e_uniqid .'.apeix-services .sgrid .service-text p {';
      $inline_style .= ( $desc_size ) ? 'font-size:'.apeix_core_check_px($desc_size) .';' : '';
      $inline_style .= ( $desc_color ) ? 'color:'. $desc_color .';' : '';
      $inline_style .= '}';
    }

      // add inline style
      add_inline_style( $inline_style );
      $styled_class  = ' apeix-services-'.$e_uniqid.' ';

      if ( $service_style == 'style_one' ) {
        $service_class = 'service-style-1 ';
      }  else {
        $service_class = 'service-style-3 ';
      }

    ob_start();
    $args = array(
      'post_type' => 'service',
      'posts_per_page' => (int) $service_limit,
      'orderby' => $service_orderby,
      'order' => $service_order,
    );
    $apeix_service = new WP_Query( $args );
    if ($apeix_service->have_posts()) : $id = 0 ?>
    <div class="apeix-services <?php echo esc_attr( $service_class.$styled_class.' '.$class ) ?>">
      <div class="row">
          <div class="col col-xs-12">
              <?php while ($apeix_service->have_posts()) : $apeix_service->the_post();
                $service_options = get_post_meta( get_the_ID(), 'service_options', true );
                $service_title = isset($service_options['service_title']) ? $service_options['service_title'] : '';
                $service_desc = isset($service_options['service_desc']) ? $service_options['service_desc'] : '';
                $service_icon = isset($service_options['service_icon']) ? $service_options['service_icon'] : '';
                $icon_color = isset($service_options['icon_color']) ? $service_options['icon_color'] : '';
                $icon_bgcolor = isset($service_options['icon_bgcolor']) ? $service_options['icon_bgcolor'] : '';
                $read_more_text = $read_more_text ? $read_more_text : esc_html__( 'Read More', 'apeix' );
                $id++;
                $e_uniqid        = uniqid();
                $inline_style  = '';
               
                if ( $icon_color ) {
                 $inline_style .= '.sgrid-'.$e_uniqid .'.sgrid .service-icon i:before {';
                 $inline_style .= ( $icon_color ) ? 'color:'. $icon_color.';' : '';
                 $inline_style .= '}';
                }
                // add 
                if ( $icon_bgcolor ) {
                 $inline_style .= '.sgrid-'.$e_uniqid .'.sgrid .service-icon {';
                 $inline_style .= ( $icon_bgcolor ) ? 'fill:'. $icon_bgcolor.';' : '';
                 $inline_style .= '}';
                }
                // add inline style
                add_inline_style( $inline_style );
                $styled_class  = ' sgrid-'.$e_uniqid;

                $blog_excerpt = cs_get_option('theme_blog_excerpt');
                if ( $service_excerpt_limit ) {
                  $service_excerpt = $service_excerpt_limit;
                } else {
                  $service_excerpt = $blog_excerpt;
                } ?>
                <div class="col-md-4  col-sm-6 sgrid <?php echo esc_attr( $styled_class ); ?>">
                    <div class="service-wrap">
                        <div class="service-icon ">
                            <i class="fi <?php echo esc_attr( $service_icon ); ?>"></i>
                        </div>
                        <div class="service-text">
                           <h2><a href="<?php echo esc_url( get_permalink() ); ?>"><?php echo esc_html( $service_title ); ?></a></h2>
                           <p><?php echo esc_html( $service_desc ); ?></p>
                        </div>
                    </div>
                </div>
                <?php endwhile;
                  wp_reset_postdata();
                ?>
             	</div>
          </div>
      </div>
    <?php endif;
    return ob_get_clean();
  }
}
add_shortcode( 'mtnc_service', 'apeix_service_function' );
