<?php
add_action('init', 'apeix_project_kc_map', 99 );
function apeix_project_kc_map() {

	if (function_exists('kc_add_map')){
	    kc_add_map(
	        array(
	            'mtnc_project' => array(
	                'name' => esc_html__('Project','apeix-core'),
	                'description' => esc_html__('Display Project', 'apeix-core'),
	                'icon' => 'cpicon kc-icon-image-hover',
	                'category' => ApeixLibrary::apeix_kc_cat_name(),
	                'params' => array(
                  'Content' => array(
                   array(
                        'name' => 'project_limit',
                        'label' => esc_html__( 'Project Limit','apeix-core'),
                        'type' => 'text',
                        'description' => esc_html__('Write Project Limit ', 'apeix-core'),
                      ),
                    array(
                        'name' => 'particular_item',
                        'type' => 'autocomplete',
                        'label' => esc_html__( 'Particular Project', 'apeix-core' ),
                        'options'       => array(
                          'multiple'      => true,
                          'post_type'     => 'project',
                        ),
                        'description' => esc_html__('Type Project Name, and select after auto detect', 'apeix-core'),
                      ),
                    array(
                        'name' => 'project_show_category',
                        'label' => esc_html__( 'Show Certain Categories','apeix-core'),
                        'type' => 'text',
                        'description' => esc_html__('Show only certain categories ', 'apeix-core'),
                      ),
                    array(
                        'name' => 'project_hide_post',
                        'label' => esc_html__( 'Hide Certain Project','apeix-core'),
                        'type' => 'text',
                        'description' => esc_html__('Hide only certain Project ', 'apeix-core'),
                      ),
                    array(
                        'name' => 'project_order',
                        'label' => esc_html__( 'Orderby','apeix-core'),
                        'type' => 'select',
                          'options' => array(
                            '' => esc_html__('Order','apeix-core'),
                            'ASC' => esc_html__('Asending','apeix-core'),
                            'DESC' => esc_html__('Desending','apeix-core'),
                          ),
                        'admin_label' => true,
                        'description' => esc_html__('Select Project Orderby ', 'apeix-core'),
                      ),
                    array(
                        'name' => 'project_orderby',
                        'label' => esc_html__( 'Order By','apeix-core'),
                        'type' => 'select',
                          'options' => array(
                            'none' => esc_html__('None','apeix-core'),
                            'ID' => esc_html__('ID','apeix-core'),
                            'author' => esc_html__('Author','apeix-core'),
                            'title' => esc_html__('Title','apeix-core'),
                            'date' => esc_html__('Date','apeix-core'),
                            'menu_order' => esc_html__('Menu order','apeix-core'),
                          ),
                        'admin_label' => true,
                      ),
                    ),
                    'Style' => array(
	                    array(
                        'name' => 'class',
                        'label' => esc_html__('Extra Class','apeix-core'),
                        'type' => 'text',
                        'admin_label' => true,
                        'description' => esc_html__('Enter Extra Class for Titlte ..', 'apeix-core')
                      ),
                      array(
                        'name' => 'title_color',
                        'label' => esc_html__('Title Color','apeix-core'),
                        'type' => 'color_picker',
                        'admin_label' => true,
                        'description' => esc_html__('Set color for title', 'apeix-core')
                      ),
                      array(
                        'name' => 'title_size',
                        'label' => esc_html__('Title Size','apeix-core'),
                        'type' => 'number_slider',
                        'options' => array(
                          'min' => 15,
                          'max' => 60,
                          'unit' => 'px',
                          'show_input' => true
                        ),
                        'description' => esc_html__('Enter font-size for title such as: 15px, 1em ..etc..', 'apeix-core')
	                    ),
	                    array(
                        'name' => 'subtitle_color',
                        'label' => esc_html__('Sub Title Color','apeix-core'),
                        'type' => 'color_picker',
                        'admin_label' => true,
                        'description' => esc_html__('Set color for Sub title', 'apeix-core')
	                    ),
                      array(
                        'name' => 'subtitle_size',
                        'label' => esc_html__('Sub Title Size','apeix-core'),
                        'type' => 'number_slider',
                        'options' => array(
                          'min' => 15,
                          'max' => 60,
                          'unit' => 'px',
                          'show_input' => true
                        ),
                        'description' => esc_html__('Enter font-size for Sub title such as: 15px, 1em ..etc..', 'apeix-core')
                      ),
		                )
	                )
	            ),  // End of elemnt kc_icon

	        )
	    ); // End add map

	} // End if

}
