<?php
/* ==========================================================
  Pricing Info
=========================================================== */
if ( !function_exists('apeix_pricing_function')) {
  function apeix_pricing_function( $atts, $content = NULL ) {
    extract($atts);

    $e_uniqid       = uniqid();
    $inline_style   = '';

    if ( $title_color || $title_size  ) {
      $inline_style .= '.pricing-section-'. $e_uniqid .'.pricing-section .pricing-text h4 {';
      $inline_style .= ( $title_color ) ? 'color:'. $title_color .';' : '';
      $inline_style .= ( $title_size ) ? 'font-size:'.apeix_core_check_px($title_size) .';' : '';
      $inline_style .= '}';
    }

    if ( $desc_color ) {
      $inline_style .= '.page-wrapper .pricing-section-'. $e_uniqid .'.pricing-section .pricing-text p {';
      $inline_style .= ( $desc_color ) ? 'color:'. $desc_color .';' : '';
      $inline_style .= '}';
    }
    if ( $price_active ) {
      $inline_style .= '.pricing-section-'. $e_uniqid .'.pricing-section .pricing-text span {';
      $inline_style .= ( $price_active ) ? 'color:'. $price_active .';' : '';
      $inline_style .= '}';
    }
    if ( $tab_color ) {
      $inline_style .= '.pricing-section-'. $e_uniqid .'.pricing-section .nav-tabs>.pricing-content-1>a {';
      $inline_style .= ( $tab_color ) ? 'background-color:'. $tab_color .';' : '';
      $inline_style .= '}';
    }

    if ( $tab_bor_color ) {
      $inline_style .= '.pricing-section-'. $e_uniqid .'.pricing-section .nav-tabs>.pricing-content-1>a {';
      $inline_style .= ( $tab_bor_color ) ? 'border-color:'. $tab_bor_color .';' : '';
      $inline_style .= '}';
    }

    if ( $tab_icon_color ) {
      $inline_style .= '.pricing-section-'. $e_uniqid .'.pricing-section .nav-tabs>.pricing-content-1>a i:before {';
      $inline_style .= ( $tab_icon_color ) ? 'color:'. $tab_icon_color .';' : '';
      $inline_style .= '}';
    }


  // add inline style
  add_inline_style( $inline_style );
  $styled_class  = ' pricing-section-'. $e_uniqid.' ';
  $pricing_items = ( $pricing_items ) ? (array) $pricing_items : array();
  $pricing2_items = ( $pricing2_items ) ? (array) $pricing2_items : array();

ob_start(); ?>
<div class="pricing-section <?php echo esc_attr( $styled_class.''.$class ); ?>">
    <div class="row">
        <div class="col-12">
            <div class="tabs-site-button">
                <div class="row pricing-tabs">
                    <div class="col-md-12 col-12">
                        <ul class="nav nav-tabs">
                           <?php
                           if ( $pricing_items ) {
                             $tab_id = 1;
                             $content_id = 0;
                            foreach ( $pricing_items as $key => $pricing_item ) {
                               $tab_id++;
                               $content_id++;
                              if ( $pricing_item->active_pricing == 'yes') {
                                $active_class = ' active';
                              } else {
                                $active_class = '';
                              }
                           ?>
                            <li class="pricing-content-1 <?php echo esc_attr( $active_class ); ?>">
                              <a data-toggle="tab" href="#<?php echo esc_attr( $tab_id ); ?>">
                              <i class="fi <?php echo esc_attr( $pricing_item->price_icon ); ?>"></i>
                              </a>
                            </li>
                          <?php } } ?>
                        </ul>
                    </div>
                    <div class="col-md-12 col-12">
                        <div class="tab-content">
                        <?php
                           if ( $pricing2_items ) {
                             $pane_id = 1;
                             $content_id = 0;
                             $price_id = 0;
                            foreach ( $pricing2_items as $key => $pricing2_item ) {
                               $pane_id++;
                               $content_id++;
                               $price_id++;
                              if ( $pricing2_item->active_pricing == 'yes') {
                                $active_class = ' active';
                              } else {
                                $active_class = '';
                              }
                              $image_url = wp_get_attachment_url( $pricing2_item->image_url );
                              $image_alt = get_post_meta( $pricing2_item->image_url, '_wp_attachment_image_alt', true);
                           ?>
                            <div id="<?php echo esc_attr( $pane_id ); ?>" class="tab-pane <?php echo esc_attr( $active_class ); ?>">
                                <div class="row">
                                    <div class="col-lg-12 col-md-12 col-12">
                                        <div class="pricing-wrap">
                                            <div class="pricing-single">
                                                <div class="pricing-img pricing-img-<?php echo esc_attr( $content_id ); ?>">
                                                    <div class="pricing-text">
                                                        <span><small><?php echo esc_html( $pricing2_item->price_curency ); ?>
                                                        </small><?php echo esc_html( $pricing2_item->price_number ); ?></span>
                                                        <h4><?php echo esc_html( $pricing2_item->price_title ); ?></h4>
                                                        <?php echo wp_kses_post( $pricing2_item->item ); ?>
                                                    </div>
                                                    <img src="<?php echo esc_url( $image_url ); ?>" alt="<?php echo esc_attr( $image_alt ); ?>">
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                          <?php } } ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php return ob_get_clean();
  }
}
add_shortcode( 'mtnc_pricing', 'apeix_pricing_function' );
