<?php
add_action('init', 'apeix_pricing_kc_map', 99 );
function apeix_pricing_kc_map() {

	if (function_exists('kc_add_map')){
	    kc_add_map(
	        array(
	            'mtnc_pricing' => array(
	                'name' => esc_html__('Pricing','apeix-core'),
	                'description' => esc_html__('Display single icon', 'apeix-core'),
	                'icon' => 'cpicon kc-icon-pricing',
	                'category' => ApeixLibrary::apeix_kc_cat_name(),
	                'params' => array(
                  'Content' => array(
                    array(
                      'type'          => 'group',
                      'label'         => esc_html__(' Options', 'apeix-core'),
                      'name'          => 'pricing_items',
                      'description'   => esc_html__( 'Items Group Field', 'apeix-core' ),
                      'options'       => array('add_text' => esc_html__(' Add new Accordion', 'apeix-core')),
                      'params' => array(
                      	 array(
                          'name' => 'price_icon',
                          'label' => esc_html__( 'Select Price Icon here','apeix-core'),
                          'type' => 'icon_picker',
                          'description' => esc_html__('Select Price Icon', 'apeix-core'),
                        	),
                          array(
                            'name' => 'active_pricing',
                            'type' => 'toggle',
                            'label' => esc_html__( 'Featured Price', 'apeix-core' ),
                            'description' => esc_html__('Please Turn On to active Accordion, Please Only One Accordion turn on, Otherwise tab stop working', 'apeix-core'),
                          ),
                        ),
                      ),
                    array(
                      'type'          => 'group',
                      'label'         => esc_html__(' Options', 'apeix-core'),
                      'name'          => 'pricing2_items',
                      'description'   => esc_html__( 'Items Group Field', 'apeix-core' ),
                      'options'       => array('add_text' => esc_html__(' Add new Accordion', 'apeix-core')),
                      'params' => array(
                         array(
                            'name' => 'price_title',
                            'label' => esc_html__( 'Pricing Title','apeix-core'),
                            'type' => 'text',
                            'admin_label' => true,
                            'description' => esc_html__('Write Pricing Title Here', 'apeix-core'),
                          ),
                          array(
	                          'name' => 'price_number',
	                          'label' => esc_html__( 'Price Amount','apeix-core'),
	                          'type' => 'text',
	                          'description' => esc_html__('Write Price Amount In Number ', 'apeix-core'),
	                          ),
                         array(
                            'name' => 'price_curency',
                            'label' => esc_html__( 'Price Currency','apeix-core'),
                            'type' => 'text',
                            'description' => esc_html__('Write Price Currency ', 'apeix-core'),
                          ),
                         array(
                            'name' => 'item',
                            'label' => esc_html__( 'Price Field Team','apeix-core'),
                            'type' => 'editor',
                            'description' => esc_html__('Write Price Field Iteam ', 'apeix-core'),
                          ),
                         array(
                            'name' => 'image_url',
                            'type' => 'attach_image',
                            'label' => esc_html__('Set Price Image ', 'apeix-core'),
                          ),
                          array(
                            'name' => 'active_pricing',
                            'type' => 'toggle',
                            'label' => esc_html__( 'Featured Price', 'apeix-core' ),
                            'description' => esc_html__('Please Turn On to active Accordion, Please Only One Accordion turn on, Otherwise tab stop working', 'apeix-core'),
                          ),
                        ),
                      ),
                    ),
                    'Style' => array(
	                    array(
                        'name' => 'class',
                        'label' => esc_html__('Extra Class','apeix-core'),
                        'type' => 'text',
                        'admin_label' => true,
                        'description' => esc_html__('Enter Extra Class for Titlte ..', 'apeix-core')
                      ),
                     array(
                        'name' => 'title_size',
                        'label' => esc_html__('Title Text Size', 'apeix-plugin'),
                        'type' => 'number_slider',
                        'options' => array(
                          'min' => 10,
                          'max' => 60,
                          'unit' => 'px',
                          'show_input' => true
                        ),
                       ),
                     array(
                        'name' => 'title_color',
                        'label' => esc_html__('Title Color','apeix-core'),
                        'type' => 'color_picker',
                        'admin_label' => true,
                        'description' => esc_html__('Set color for title', 'apeix-core')
                     ),
                    array(
                        'name' => 'desc_color',
                        'label' => esc_html__('Description Text Color','apeix-core'),
                        'type' => 'color_picker',
                        'admin_label' => true,
                        'description' => esc_html__('Set color for Description Text', 'apeix-core')
                      ),
                     array(
                        'name' => 'price_active',
                        'label' => esc_html__('Price Color','apeix-core'),
                        'type' => 'color_picker',
                        'admin_label' => true,
                        'description' => esc_html__('Set Price color for Price', 'apeix-core')
                     ),
                     array(
                        'name' => 'tab_color',
                        'label' => esc_html__('Price Tab Background Color','apeix-core'),
                        'type' => 'color_picker',
                        'admin_label' => true,
                        'description' => esc_html__('Set Price Tab Background color for Price', 'apeix-core')
                     ),
                     array(
                        'name' => 'tab_bor_color',
                        'label' => esc_html__('Price Tab Border Color','apeix-core'),
                        'type' => 'color_picker',
                        'admin_label' => true,
                        'description' => esc_html__('Set Price Tab Border color for Price', 'apeix-core')
                     ),
                     array(
                        'name' => 'tab_icon_color',
                        'label' => esc_html__('Price Tab Icon Color','apeix-core'),
                        'type' => 'color_picker',
                        'admin_label' => true,
                        'description' => esc_html__('Set Price Tab Icon color for Price', 'apeix-core')
                     ),
		                )
	                )
	            ),  // End of elemnt kc_icon
	        )
	    ); // End add map
	} // End if
}
