<?php
/* ==========================================================
  Funfact
=========================================================== */
if ( !function_exists('apeix_funfact_function')) {
  function apeix_funfact_function( $atts, $content = NULL ) {

    extract($atts);

    $e_uniqid       = uniqid();
    $inline_style   = '';
    if ( $title_size || $title_color  ) {
      $inline_style .= '.fun-fact-'.$e_uniqid .'.fun-fact .fun-fact-grids .grid p {';
      $inline_style .= ( $title_size ) ? 'font-size:'.apeix_core_check_px($title_size) .';' : '';
      $inline_style .= ( $title_color ) ? 'color:'. $title_color .';' : '';
      $inline_style .= '}';
    }
    if ( $number_size || $number_color  ) {
      $inline_style .= '.fun-fact-'.$e_uniqid .'.fun-fact .fun-fact-grids .grid h3,.fun-fact-'.$e_uniqid .'.fun-fact .fun-fact-grids .grid h2 {';
      $inline_style .= ( $number_size ) ? 'font-size:'.apeix_core_check_px( $number_size) .';' : '';
      $inline_style .= ( $number_color ) ? 'color:'. $number_color .';' : '';
      $inline_style .= '}';
    }
    if ( $icon_size || $icon_color  ) {
      $inline_style .= '.fun-fact-'.$e_uniqid .'.fun-fact .fun-fact-grids .grid .hx-counter-icon .fi {';
      $inline_style .= ( $icon_size ) ? 'font-size:'.apeix_core_check_px( $icon_size) .';' : '';
      $inline_style .= ( $icon_color ) ? 'color:'. $icon_color .';' : '';
      $inline_style .= '}';
    }
    if ( $funfact_bg  ) {
      $inline_style .= '.fun-fact-'.$e_uniqid .'.fun-fact .fun-fact-grids .grid {';
      $inline_style .= ( $funfact_bg ) ? 'background-color:'. $funfact_bg .';' : '';
      $inline_style .= '}';
    }
     // add inline style
    add_inline_style( $inline_style );
    $styled_class  = ' fun-fact-'.$e_uniqid.' ';
    $funfact_items = ( $funfact_items ) ? (array) $funfact_items : array();


    ob_start(); ?>
    <?php if ( $funfact_style == 'standard' ) { ?>
    <section class="fun-fact fun-fact-section <?php echo esc_attr(  $class.$styled_class ) ?>">
      <div class="row">
          <div class="col col-md-6 col-sm-12">
              <div class="fun-fact-content">
                  <h2><?php echo esc_html( $title ); ?></h2>
                  <p><?php echo esc_html( $desc ); ?></p>
              </div>
          </div>
          <div class="col col-md-6 col-sm-12">
              <div class="fun-fact-grids clearfix">
                <?php
                  foreach ( $funfact_items as $key => $funfact_item ) {
                  $funfact_item->title = preg_replace('~\s*<br ?/?>\s*~',"<br />",$funfact_item->title);
                  $funfact_item->title = nl2br($funfact_item->title);
                  if ( $funfact_item->number ||  $funfact_item->title ) { ?>
                  <div class="grid">
                      <div>
                         <h3>
                          <span class="odometer" data-count="<?php echo esc_html( $funfact_item->number ) ?>"><?php echo esc_html__( '00','apeix-core' ); ?></span> 
                          <span class="plus">
                            <?php if ( $funfact_item->percent) {
                               echo esc_html( $funfact_item->percent );
                              } ?>
                          </span>
                        </h3>
                      </div>
                      <p><?php echo wp_kses_post( $funfact_item->title ); ?></p>
                  </div>
                  <?php } } ?> 
              </div>
          </div>
      </div>
   </section>
   <?php } else { ?>
    <div class="fun-fact fun-fact-section-s2 <?php echo esc_attr(  $class.$styled_class ) ?>">
        <div class="row">
            <div class="col-lg-12">
                <div class="fun-fact-grids clearfix">
                   <?php
                    foreach ( $funfact_items as $key => $funfact_item ) {
                      $funfact_item->title = preg_replace('~\s*<br ?/?>\s*~',"<br />",$funfact_item->title);
                      $funfact_item->title = nl2br($funfact_item->title);
                      if ( $funfact_item->number ||  $funfact_item->title ) { ?>
                      <div class="grid">
                          <div class="hx-counter-icon">
                              <i class="fi <?php echo esc_attr(  $funfact_item->icon ); ?>"></i>
                          </div>
                          <div>
                            <h2>
                              <span class="odometer" data-count="<?php echo esc_html( $funfact_item->number ) ?>"><?php echo esc_html__( '00','apeix-core' ); ?></span> 
                              <span class="plus">
                                <?php if ( $funfact_item->percent) {
                                   echo esc_html( $funfact_item->percent );
                                  } ?>
                              </span>
                            </h2>
                          </div>
                           <p><?php echo wp_kses_post( $funfact_item->title ); ?></p>
                      </div>
                    <?php } } ?> 
                </div>
            </div>
        </div>
    </div>
  <?php } 
   return ob_get_clean();
  }
}
add_shortcode( 'ole_funfact', 'apeix_funfact_function' );
