<?php
/* ==========================================================
  Service Info
=========================================================== */
if ( !function_exists('apeix_features_function')) {
  function apeix_features_function( $atts, $content = NULL ) {
    extract($atts);

    $e_uniqid       = uniqid();
    $inline_style   = '';
    if ( $title_size || $title_color ) {
      $inline_style .= '.apeix-features-'. $e_uniqid .'.apeix-features .features-wrap h2 {';
      $inline_style .= $title_size ? 'font-size: '. apeix_plugin_check_px($title_size) .';': '';
      $inline_style .= ( $title_color ) ? 'color:'. $title_color .';' : '';
      $inline_style .= '}';
    }
    if ( $desc_size || $desc_color ) {
      $inline_style .= '.apeix-features-'. $e_uniqid .'.apeix-features .features-wrap p {';
      $inline_style .= $desc_size ? 'font-size: '. apeix_plugin_check_px($desc_size) .';': '';
      $inline_style .= ( $desc_color ) ? 'color:'. $desc_color .';' : '';
      $inline_style .= '}';
    }
    if ( $icon_color ) {
      $inline_style .= '.apeix-features-'. $e_uniqid .'.apeix-features .features-wrap .features-icon i:before  {';
      $inline_style .= ( $icon_color ) ? 'color:'. $icon_color .';' : '';
      $inline_style .= '}';
    }

    if ( $icon_bgcolor ) {
      $inline_style .= '.apeix-features-'. $e_uniqid .'.apeix-features .features-wrap .features-icon  {';
      $inline_style .= ( $icon_bgcolor ) ? 'background-color:'. $icon_bgcolor .';' : '';
      $inline_style .= '}';
    }

    if ( $border_color ) {
      $inline_style .= '.apeix-features-'. $e_uniqid .'.apeix-features .features-wrap .features-icon:before {';
      $inline_style .= ( $border_color ) ? 'background-color:'. $border_color .';' : '';
      $inline_style .= '}';
    }
    
    // add inline style
    add_inline_style( $inline_style );
    $styled_class  = ' apeix-features-'. $e_uniqid.' ';
    $feature_items = ( $feature_items ) ? (array) $feature_items : array();


  ob_start(); ?>


    <?php if ( $feature_style == 'standard') { ?>
      <div class="apeix-features features-style  <?php echo esc_attr( $class.$styled_class ); ?>">
        <div class="row">
          <?php if ( $feature_items ) {
            foreach ( $feature_items as $key => $feature_item ) { ?>
            <div class="col col-md-4 col-sm-6">
                <div class="features-wrap">
                    <div class="features-icon">
                        <i class="fi <?php echo esc_attr( $feature_item->icon ); ?>"></i>
                    </div>
                    <div class="features-text">
                        <h2><?php echo esc_html( $feature_item->title ); ?></h2>
                        <p><?php echo esc_html( $feature_item->desc ); ?></p>
                    </div>
                </div>
            </div>
          <?php } } ?>
        </div>
      </div>
    <?php } else { ?>
    <div class="apeix-features service-style-1 service-details-what-we-do <?php echo esc_attr( $class.$styled_class ); ?>">
        <div class="row no-gutters">
          <?php if ( $feature_items ) {
            foreach ( $feature_items as $key => $feature_item ) { ?>
            <div class="col-md-4 col-sm-6">
                <div class="service-wrap">
                    <div class="service-icon">
                        <i class="fi <?php echo esc_attr( $feature_item->icon ); ?>"></i>
                    </div>
                    <div class="service-text">
                        <h2><?php echo esc_html( $feature_item->title ); ?></h2>
                        <p><?php echo esc_html( $feature_item->desc ); ?></p>
                    </div>
                </div>
            </div>
          <?php } } ?>
        </div>
    </div>
   <?php } ?>
 <?php return ob_get_clean();
  }
}
add_shortcode( 'mtq_features', 'apeix_features_function' );
