<?php
/* ==========================================================
  CTA Info
=========================================================== */
if ( !function_exists('apeix_cta_shortcode_function')) {
  function apeix_cta_shortcode_function( $atts, $content = true ) {
  	extract($atts);
  	$e_uniqid       = uniqid();
    $inline_style   = '';

  if ( $title_color || $title_size ) {
      $inline_style .= '.cta-section-'. $e_uniqid .'.cta-section .cta-text h2 {';
      $inline_style .= ( $title_color ) ? 'color:'. $title_color .';' : '';
      $inline_style .= ( $title_size ) ? 'font-size:'.apeix_core_check_px($title_size) .';' : '';
      $inline_style .= '}';
    } 
 
  if ( $btn_size || $btn_color || $btn_bg) {
      $inline_style .= '.cta-section-'. $e_uniqid .'.cta-section .cta-text a.theme-btn-s4 {';
      $inline_style .= ( $btn_color ) ? 'color:'. $btn_color .';' : '';
      $inline_style .= ( $btn_bg ) ? 'background-color:'. $btn_bg .';' : '';
      $inline_style .= ( $btn_size ) ? 'font-size:'.apeix_core_check_px($btn_size) .';' : '';
      $inline_style .= '}';
    }
  if ( $btn_hover_bg ) {
      $inline_style .= '.cta-section-'. $e_uniqid .'.cta-section .cta-text a.theme-btn-s4:hover {';
      $inline_style .= ( $btn_hover_bg ) ? 'background-color:'. $btn_hover_bg .';' : '';
      $inline_style .= '}';
    }

    // add inline style
  add_inline_style( $inline_style );
  $styled_class  = ' cta-section-'. $e_uniqid.' ';

  ob_start(); ?>
  <section class="cta-section <?php echo esc_attr( $styled_class.$class ); ?>">
    <div class="row">
        <div class="col col-xs-12">
            <div class="cta-text">
                <h2><?php echo esc_html( $title ); ?></h2>
                <a href="<?php echo esc_url( $link ); ?>" class="theme-btn-s4"><?php echo esc_html( $link_text ); ?></a>
            </div>
        </div>
    </div>
</section>
  <?php return ob_get_clean();
  }
}
add_shortcode( 'ole_cta', 'apeix_cta_shortcode_function' );