<?php
/* ==========================================================
  Contact form 7
=========================================================== */
if ( !function_exists('apeix_contact7_function')) {
  function apeix_contact7_function( $atts, $content = NULL ) {
    extract($atts);

      $e_uniqid       = uniqid();
      $inline_style   = '';
      
      if ( $button_color ) {
        $inline_style .= '.hx-contact-area-'.$e_uniqid .'.hx-contact-area .hx-contact-form .wpcf7-form-control.wpcf7-submit {';
        $inline_style .= ( $button_color ) ? 'color:'. $button_color .';' : '';
        $inline_style .= '}';
      }
      if ( $button_hover ) {
        $inline_style .= '.hx-contact-area-'.$e_uniqid .'.hx-contact-area .hx-contact-form .wpcf7-form-control.wpcf7-submit:hover {';
        $inline_style .= ( $button_hover ) ? 'background-color:'. $button_hover .';' : '';
        $inline_style .= '}';
      }
      if ( $input_border ) {
        $inline_style .= '.hx-contact-area-'.$e_uniqid .'.hx-contact-area .hx-contact-form input , .hx-contact-area-'.$e_uniqid .'.hx-contact-area .hx-contact-form textarea {';
        $inline_style .= ( $input_border ) ? 'border-color:'. $input_border .';' : '';
        $inline_style .= '}';
      }

    // add inline style
    add_inline_style( $inline_style );
    $styled_class  = ' hx-contact-area-'.$e_uniqid.' ';
    $contact_id = ( $contact_id ) ? $contact_id : 0;

    $image_url = wp_get_attachment_url( $image_url );
    $image_alt = get_post_meta( $image_url, '_wp_attachment_image_alt', true);

    ob_start(); ?>
    <div class="hx-contact-area <?php echo esc_attr( $styled_class.$class ); ?>">
        <div class="row">
            <div class="col col-md-7 col-sm-12 col-12">
                <div class="hx-contact-content">
                     <h2><?php echo esc_html( $title ); ?></h2>
                    <div class="hx-contact-form">
                        <?php echo do_shortcode( '[contact-form-7 id="'. $contact_id .'"]' ); ?>
                    </div>
                </div>
            </div>
            <div class="col-md-5">
                <div class="hx-contact-img">
                    <img src="<?php echo esc_url( $image_url ); ?>" alt="<?php echo esc_attr( $image_alt ); ?>">
                </div>
            </div>
        </div>
    </div>
  <?php  return ob_get_clean();
  }
}
add_shortcode( 'motc_contact7', 'apeix_contact7_function' );
