<?php
add_action('init', 'apeix_contact7_kc_map', 99 );
function apeix_contact7_kc_map() {
   $cf7 = get_posts( 'post_type="wpcf7_contact_form"&numberposts=-1' );
    $contact_forms = array();
    if ( $cf7 ) {
      foreach ( $cf7 as $cform ) {
        $contact_forms[ $cform->ID ] = $cform->post_title;
      }
    } else {
      $contact_forms[ esc_html__( 'No contact forms found', 'apeix-core' ) ] = 0;
    }
  if (function_exists('kc_add_map')){
      kc_add_map(
          array(
              'motc_contact7' => array(
                  'name' =>  esc_html__('Contact 7','apeix-core'),
                  'description' => esc_html__('Display single icon', 'apeix-core'),
                  'icon' => 'cpicon fas fa-envelope',
                  'category' => ApeixLibrary::apeix_kc_cat_name(),
                  'params' => array(
                  'Content' => array(
                    array(
                      'name' => 'title',
                      'label' => esc_html__( 'Contact Title','apeix-core'),
                      'type' => 'text',
                      'admin_label' => true,
                      'description' => esc_html__('Write Contact Title ', 'apeix-core'),
                    ),
                    array(
                      'name' => 'image_url',
                      'type' => 'attach_image',
                      'label' => esc_html__('Set Contact Image ', 'apeix'),
                    ),
                    array(
                      'name' => 'contact_id',
                      'label' => esc_html__('Contact Style','apeix-core'),
                      'type' => 'select',
                        'options' => $contact_forms,
                      'admin_label' => true,
                      'description' => esc_html__('Select your Contact style. ', 'apeix-core'),
                     ),
                    ),
                    'Style' => array(
                      array(
                        'name' => 'class',
                        'label' => esc_html__('Extra Class','apeix-core'),
                        'type' => 'text',
                        'admin_label' => true,
                        'description' => esc_html__('Enter Extra Class for Titlte ..', 'apeix-core')
                      ),
                      array(
                        'name' => 'button_color',
                        'label' => esc_html__('Button Color','apeix-core'),
                        'type' => 'color_picker',
                        'admin_label' => true,
                        'description' => esc_html__('Set color for Button', 'apeix-core')
                      ),
                      array(
                        'name' => 'border_color',
                        'label' => esc_html__('Button Border Color','apeix-core'),
                        'type' => 'color_picker',
                        'admin_label' => true,
                        'description' => esc_html__('Set Border color for Button', 'apeix-core')
                      ),
                      array(
                        'name' => 'button_hover',
                        'label' => esc_html__('Button Hover Color','apeix-core'),
                        'type' => 'color_picker',
                        'admin_label' => true,
                        'description' => esc_html__('Set hover color for Button', 'apeix-core')
                      ),
                      array(
                        'name' => 'input_border',
                        'label' => esc_html__('Form Input Border Color','apeix-core'),
                        'type' => 'color_picker',
                        'admin_label' => true,
                        'description' => esc_html__('Set form input Border Color', 'apeix-core')
                      ),
                    )
                  )
              ),  // End of elemnt kc_icon

          )
      ); // End add map

  } // End if

}
