<?php
/* ==========================================================
  Service Info
=========================================================== */
if ( !function_exists('apeix_contact_info_function')) {
  function apeix_contact_info_function( $atts, $content = NULL ) {
    extract($atts);

    $e_uniqid       = uniqid();
    $inline_style   = '';
    if ( $title_size || $title_color ) {
      $inline_style .= '.hx-contact-grid-area-'.$e_uniqid .' .hx-contact-gd-text h4 {';
      $inline_style .= $title_size ? 'font-size: '. apeix_plugin_check_px($title_size) .';': '';
      $inline_style .= ( $title_color ) ? 'color:'. $title_color .';' : '';
      $inline_style .= '}';
    }
   
    if ( $desc_size || $desc_color ) {
      $inline_style .= '.hx-contact-grid-area-'.$e_uniqid .' .hx-contact-gd-text span {';
      $inline_style .= $desc_size ? 'font-size: '. apeix_plugin_check_px($desc_size) .';': '';
      $inline_style .= ( $desc_color ) ? 'color:'. $desc_color .';' : '';
      $inline_style .= '}';
    }
   
    if ( $icon_color ) {
      $inline_style .= '.hx-contact-grid-area-'.$e_uniqid .' .hx-contact-gd-icon i:before {';
      $inline_style .= ( $icon_color ) ? 'color:'. $icon_color .';' : '';
      $inline_style .= '}';
    }
  
    if ( $icon_bgcolor ) {
      $inline_style .= '.hx-contact-grid-area-'.$e_uniqid .' .hx-contact-gd-icon {';
      $inline_style .= ( $icon_bgcolor ) ? 'background-color:'. $icon_bgcolor .';' : '';
      $inline_style .= '}';
    }
  
     // add inline style
    add_inline_style( $inline_style );
    $styled_class  = ' hx-contact-grid-area-'. $e_uniqid.' ';
    $contact_items = ( $contact_items ) ? (array) $contact_items : array();

     ob_start(); ?>
    <div class="hx-contact-grid-area <?php echo esc_attr( $styled_class.$class ); ?>">
      <div class="row">
        <?php if ( $contact_items ) {
          foreach ( $contact_items as $key => $contact_item ) { ?>
          <div class="col-lg-4 col-md-6 col-sm-12 col-12">
              <div class="hx-contact-gd-wrap">
                  <div class="hx-contact-gd-icon">
                      <i class="fi <?php echo esc_attr( $contact_item->item_icon ); ?>"></i>
                  </div>
                  <div class="hx-contact-gd-text">
                      <h4><?php echo esc_html( $contact_item->title ); ?></h4>
                      <span><?php echo esc_html( $contact_item->info ); ?></span>
                  </div>
              </div>
          </div>
          <?php } } ?>
      </div>
  </div>
    <?php return ob_get_clean();
  }
}
add_shortcode( 'contact_info', 'apeix_contact_info_function' );
