<?php
if (!function_exists('apeix_about_function')) {
    add_shortcode( 'aqt_about', 'apeix_about_function' );
    function apeix_about_function($atts, $content = NULL){
      extract($atts);
      $e_uniqid       = uniqid();
      $inline_style   = '';

      if ( $title_color || $title_size ) {
        $inline_style .= '.hx-about-area-'.$e_uniqid .'.hx-about-area .hx-about-content h2 {';
        $inline_style .= ( $title_color ) ? 'color:'. $title_color .';' : '';
        $inline_style .= ( $title_size ) ? 'font-size:'.apeix_core_check_px($title_size) .';' : '';
        $inline_style .= '}';
      }
      if ( $subtitle_color || $subtitle_size ) {
        $inline_style .= '.hx-about-area-'.$e_uniqid .'.hx-about-area .hx-about-content h4 {';
        $inline_style .= ( $subtitle_color ) ? 'color:'. $subtitle_color .';' : '';
        $inline_style .= ( $subtitle_size ) ? 'font-size:'.apeix_core_check_px($subtitle_size) .';' : '';
        $inline_style .= '}';
      }
      if ( $desc_size || $desc_color  ) {
        $inline_style .= '.page-wrapper .hx-about-area-'.$e_uniqid .' .hx-about-content p {';
        $inline_style .= ( $desc_size ) ? 'font-size:'.apeix_core_check_px($desc_size) .';' : '';
        $inline_style .= ( $desc_color ) ? 'color:'. $desc_color .';' : '';
        $inline_style .= '}';
      }

       if ( $icon_color ) {
        $inline_style .= '.hx-about-area-'.$e_uniqid .' .hx-about-content .hx-about-icon .fi {';
        $inline_style .= ( $icon_color ) ? 'color:'. $icon_color .';' : '';
        $inline_style .= '}';
      }

      if ( $button_size || $button_color ) {
        $inline_style .= '.hx-about-area-'.$e_uniqid .' .hx-about-content .about-btns a.theme-btn-s2 {';
        $inline_style .= ( $button_size ) ? 'font-size:'.apeix_core_check_px($button_size) .';' : '';
        $inline_style .= ( $button_color ) ? 'color:'. $button_color .';' : '';
        $inline_style .= '}';
      }

      if ( $button_bgcolor ) {
        $inline_style .= '.hx-about-area-'.$e_uniqid .' .hx-about-content .about-btns a.theme-btn-s2 {';
        $inline_style .= ( $button_bgcolor ) ? 'background:-webkit-linear-gradient(left, '. $button_bgcolor .' 0%, '. $button_bgcolor .' 50%, '. $button_bgcolor .' 100%);' : '';
        $inline_style .= '}';
      }

      if ( $button_bghover ) {
        $inline_style .= '.hx-about-area-'.$e_uniqid .' .hx-about-content .about-btns a.theme-btn-s2:hover {';
        $inline_style .= ( $button_bghover ) ? 'background-color:'. $button_bghover .';' : '';
        $inline_style .= '}';
      }

      if ( $button_hover ) {
        $inline_style .= '.hx-about-area-'.$e_uniqid .' .hx-about-content .about-btns a.theme-btn-s2:hover {';
        $inline_style .= ( $button_hover ) ? 'color:'. $button_hover .';' : '';
        $inline_style .= '}';
      }

    // add inline style
  add_inline_style( $inline_style );
  $styled_class  = 'hx-about-area-'.$e_uniqid.' ';
  $image_url = wp_get_attachment_url( $image_url );
  $image_alt = get_post_meta( $image_url, '_wp_attachment_image_alt', true);


  $about_items = ( $about_items ) ? (array) $about_items : array();

  ob_start(); ?>
  <div class="hx-about-area <?php echo esc_attr( $class.$styled_class ); ?>">
     <div class="container">
         <div class="row">
             <div class="col-md-6 col-sm-16 col-xs-12">
                 <div class="hx-about-img">
                      <img src="<?php echo esc_url( $image_url ); ?>" alt="<?php echo esc_attr( $image_alt ); ?>">
                 </div>
             </div>
             <div class="col-md-6 col-sm-16 col-xs-12">
             
                 <div class="hx-about-content">
                    <h2><?php echo esc_html( $title ); ?></h2>
                    <p><?php echo wp_kses_post( $desc ); ?></p>
                   <?php if ( $about_items ) {
                     foreach ( $about_items as $key => $about_item ) { ?>
                      <div class="hx-about-wrap">
                          <div class="hx-about-icon">
                              <i class="fi  <?php echo esc_attr( $about_item->icon ); ?>"></i>
                          </div>
                          <div class="hx-about-text">
                              <h4><?php echo esc_html( $about_item->title ); ?></h4>
                              <p><?php echo esc_html( $about_item->desc ); ?></p>
                          </div>
                      </div>
                  <?php } } ?>
                   <div class="about-btns">
                        <a href="<?php echo esc_url( $button_link ); ?>" class="theme-btn-s2"><?php echo esc_html( $button_text ); ?></a>
                    </div>
                 </div>
             </div>
         </div>
     </div>
  </div>
  <?php return ob_get_clean();
  }
}