<?php
/*
 * Elementor Apeix Pricing Widget
 * Author & Copyright: wpoceans
*/

namespace Elementor;

if (!defined('ABSPATH')) exit; // Exit if accessed directly

class Apeix_Pricing extends Widget_Base
{

	/**
	 * Retrieve the widget name.
	 */
	public function get_name()
	{
		return 'tmx-apeix_pricing';
	}

	/**
	 * Retrieve the widget title.
	 */
	public function get_title()
	{
		return esc_html__('Pricing', 'apeix-core');
	}

	/**
	 * Retrieve the widget icon.
	 */
	public function get_icon()
	{
		return 'eicon-price-table';
	}

	/**
	 * Retrieve the list of categories the widget belongs to.
	 */
	public function get_categories()
	{
		return ['wpoceans-category'];
	}

	/**
	 * Retrieve the list of scripts the Apeix Pricing widget depended on.
	 * Used to set scripts dependencies required to run the widget.
	 */
	public function get_script_depends()
	{
		return ['tmx-apeix_pricing'];
	}

	/**
	 * Register Apeix Pricing widget controls.
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 */
	protected function register_controls()
	{

		$this->start_controls_section(
			'section_pricing',
			[
				'label' => esc_html__('Pricing Options', 'apeix-core'),
			]
		);
		$repeater = new Repeater();
		$repeater->add_control(
			'tab_title',
			[
				'label' => esc_html__('Tab Title', 'apeix-core'),
				'type' => Controls_Manager::TEXT,
				'default' => esc_html__('Tab One', 'apeix-core'),
				'placeholder' => esc_html__('Type title text here', 'apeix-core'),
				'label_block' => true,
			]
		);
		$repeater->add_control(
			'tab_icon',
			[
				'label' => __('Icon', 'apeix-core'),
				'type' => \Elementor\Controls_Manager::ICONS,
				'default' => [
					'value' => 'flaticon-turbo',
					'library' => 'solid',
				],
			]
		);
		$repeater->add_control(
			'active_tabs',
			[
				'label' => esc_html__('Active', 'apeix-core'),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__('Yes', 'apeix-core'),
				'label_off' => esc_html__('No', 'apeix-core'),
				'return_value' => 'true',
				'default' => 'true',
			]
		);
		$this->add_control(
			'pricingTabs_groups',
			[
				'label' => esc_html__('Pricing Tab', 'apeix-core'),
				'type' => Controls_Manager::REPEATER,
				'default' => [
					[
						'tab_title' => esc_html__('Tabs', 'apeix-core'),
					],

				],
				'fields' =>  $repeater->get_controls(),
				'title_field' => '{{{ tab_title }}}',
			]
		);
		$repeater = new Repeater();
		$repeater->add_control(
			'pricing_image',
			[
				'label' => esc_html__('Pricing Image', 'apeix-core'),
				'type' => Controls_Manager::MEDIA,
				'frontend_available' => true,
				'default' => [
					'url' => Utils::get_placeholder_image_src(),
				],
				'description' => esc_html__('Set your image.', 'apeix-core'),
			]
		);
		$repeater->add_control(
			'pricing_title',
			[
				'label' => esc_html__('Price Title', 'apeix-core'),
				'type' => Controls_Manager::TEXT,
				'default' => esc_html__('Per Month', 'apeix-core'),
				'placeholder' => esc_html__('Type Price title text here', 'apeix-core'),
				'label_block' => true,
			]
		);
		$repeater->add_control(
			'pricing_amount',
			[
				'label' => esc_html__('Price Amount', 'apeix-core'),
				'type' => Controls_Manager::TEXT,
				'default' => esc_html__('99', 'apeix-core'),
				'placeholder' => esc_html__('Type Price Amount here', 'apeix-core'),
				'label_block' => true,
			]
		);
		$repeater->add_control(
			'pricing_curency',
			[
				'label' => esc_html__('Price Currency', 'apeix-core'),
				'type' => Controls_Manager::TEXT,
				'default' => esc_html__('$', 'apeix-core'),
				'placeholder' => esc_html__('Type Price Curency here', 'apeix-core'),
				'label_block' => true,
			]
		);
		$repeater->add_control(
			'pricing_items',
			[
				'label' => esc_html__('Description', 'apeix-core'),
				'type' => Controls_Manager::TEXTAREA,
				'default' => esc_html__('Price description', 'apeix-core'),
				'placeholder' => esc_html__('Type Price description here', 'apeix-core'),
				'label_block' => true,
			]
		);
		$repeater->add_control(
			'active_tabs',
			[
				'label' => esc_html__('Active', 'apeix-core'),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__('Yes', 'apeix-core'),
				'label_off' => esc_html__('No', 'apeix-core'),
				'return_value' => 'true',
				'default' => 'true',
			]
		);
		$this->add_control(
			'pricingItems_groups',
			[
				'label' => esc_html__('Pricing Items', 'apeix-core'),
				'type' => Controls_Manager::REPEATER,
				'default' => [
					[
						'pricing_title' => esc_html__('Pricing', 'apeix-core'),
					],

				],
				'fields' =>  $repeater->get_controls(),
				'title_field' => '{{{ pricing_title }}}',
			]
		);
		$this->end_controls_section(); // end: Section


		// Tab
		$this->start_controls_section(
			'section_tab_style',
			[
				'label' => esc_html__('Tab', 'apeix-core'),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'border_color',
			[
				'label' => esc_html__('Color', 'apeix-core'),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .pricing-tabs .nav-tabs li a' => 'border-color: {{VALUE}};',
				],
			]
		);
		$this->add_control(
			'icon_color',
			[
				'label' => esc_html__('Icon Color', 'apeix-core'),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .pricing-tabs .nav-tabs li a i:before' => 'color: {{VALUE}};',
				],
			]
		);
		$this->add_control(
			'hover_border_color',
			[
				'label' => esc_html__('Hover Border', 'apeix-core'),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .pricing-tabs .nav-tabs li a:hover' => 'border-color: {{VALUE}};',
				],
			]
		);
		$this->add_control(
			'hover_bg_color',
			[
				'label' => esc_html__('Hover BG', 'apeix-core'),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .pricing-tabs .nav-tabs li a:hover' => 'background-color: {{VALUE}};',
				],
			]
		);
		$this->add_control(
			'hover_icon_color',
			[
				'label' => esc_html__('Hover Icon', 'apeix-core'),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .pricing-tabs .nav-tabs li a:hover i:before' => 'color: {{VALUE}};',
				],
			]
		);
		$this->add_control(
			'active_border_color',
			[
				'label' => esc_html__('Active Border', 'apeix-core'),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .pricing-tabs .nav-tabs li.active a' => 'border-color: {{VALUE}};',
				],
			]
		);
		$this->add_control(
			'active_bg_color',
			[
				'label' => esc_html__('Active BG', 'apeix-core'),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .pricing-tabs .nav-tabs li.active a' => 'background-color: {{VALUE}};',
				],
			]
		);
		$this->add_control(
			'active_icon_color',
			[
				'label' => esc_html__('Active Icon', 'apeix-core'),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .pricing-tabs .nav-tabs li.active a i:before' => 'color: {{VALUE}};',
				],
			]
		);
		$this->end_controls_section(); // end: Section


		// Title
		$this->start_controls_section(
			'section_title_style',
			[
				'label' => esc_html__('Title', 'apeix-core'),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'label' => esc_html__('Typography', 'apeix-core'),
				'name' => 'apeix_title_typography',
				'selector' => '{{WRAPPER}} .pricing-tabs .pricing-text h4',
			]
		);
		$this->add_control(
			'title_color',
			[
				'label' => esc_html__('Color', 'apeix-core'),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .pricing-tabs .pricing-text h4' => 'color: {{VALUE}};',
				],
			]
		);
		$this->add_control(
			'title_padding',
			[
				'label' => esc_html__('Title Padding', 'apeix-core'),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', 'em'],
				'selectors' => [
					'{{WRAPPER}} .pricing-tabs .pricing-text h4' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		$this->end_controls_section(); // end: Section

		// Price
		$this->start_controls_section(
			'section_price_style',
			[
				'label' => esc_html__('Price', 'apeix-core'),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'label' => esc_html__('Typography', 'apeix-core'),
				'name' => 'apeix_price_typography',
				'selector' => '{{WRAPPER}} .pricing-tabs .pricing-text span',
			]
		);
		$this->add_control(
			'price_color',
			[
				'label' => esc_html__('Color', 'apeix-core'),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .pricing-tabs .pricing-text span' => 'color: {{VALUE}};',
				],
			]
		);
		$this->add_control(
			'price_padding',
			[
				'label' => esc_html__('Title Padding', 'apeix-core'),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', 'em'],
				'selectors' => [
					'{{WRAPPER}} .pricing-tabs .pricing-text span' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		$this->end_controls_section(); // end: Section

		// Content
		$this->start_controls_section(
			'section_content_style',
			[
				'label' => esc_html__('Content', 'apeix-core'),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'label' => esc_html__('Typography', 'apeix-core'),
				'name' => 'section_content_typography',
				'selector' => '{{WRAPPER}} .pricing-tabs .pricing-text p',
			]
		);
		$this->add_control(
			'content_color',
			[
				'label' => esc_html__('Color', 'apeix-core'),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .pricing-tabs .pricing-text p' => 'color: {{VALUE}};',
				],
			]
		);
		$this->add_responsive_control(
			'content_padding',
			[
				'label' => esc_html__('Padding', 'apeix-core'),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', 'em'],
				'selectors' => [
					'{{WRAPPER}} .pricing-tabs .pricing-text p' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		$this->end_controls_section(); // end: Section




	}

	/**
	 * Render Pricing widget output on the frontend.
	 * Written in PHP and used to generate the final HTML.
	 */
	protected function render()
	{
		$settings = $this->get_settings_for_display();
		$pricingTabs_groups = !empty($settings['pricingTabs_groups']) ? $settings['pricingTabs_groups'] : [];
		$pricingItems_groups = !empty($settings['pricingItems_groups']) ? $settings['pricingItems_groups'] : [];


		// Turn output buffer on
		ob_start();
?>
		<div class="pricing-section">
			<div class="row">
				<div class="col-12">
					<div class="tabs-site-button">
						<div class="row pricing-tabs">
							<div class="col-md-12 col-12">
								<ul class="nav nav-tabs">
									<?php
									$tab_id = 0;
									// Group Param Output
									if (is_array($pricingTabs_groups) && !empty($pricingTabs_groups)) {
										foreach ($pricingTabs_groups as $each_items) {
											$tab_id++;
											$tab_title = !empty($each_items['tab_title']) ? $each_items['tab_title'] : '';
											$active_tabs = !empty($each_items['active_tabs']) ? $each_items['active_tabs'] : '';
											$tab_icon = !empty($each_items['tab_icon']['value']) ? $each_items['tab_icon']['value'] : '';
											$tab_svg_url = !empty($each_items['tab_icon']['value']['url']) ? $each_items['tab_icon']['value']['url'] : '';
											$svg_alt = get_post_meta($tab_svg_url, '_wp_attachment_image_alt', true);

											if ($active_tabs == true) {
												$active_class = 'active';
											} else {
												$active_class = 'not-active';
											}

									?>
											<li class="pricing-content-1 <?php echo esc_attr($active_class); ?>">
												<a data-toggle="tab" href="#<?php echo esc_attr($tab_id); ?>">
													<?php if ($tab_svg_url) {
														echo '<img src="' . esc_url($tab_svg_url) . '" alt="' . esc_url($svg_alt) . '">';
													} else {
														echo ' <i class="' . esc_attr($tab_icon) . '"></i>';
													} ?>
												</a>
											</li>
									<?php }
									} ?>
								</ul>
							</div>
							<div class="col-md-12 col-12">
								<div class="tab-content">
									<?php
									$tab_id = 0;
									// Group Param Output
									if (is_array($pricingItems_groups) && !empty($pricingItems_groups)) {
										foreach ($pricingItems_groups as $each_items) {
											$tab_id++;

											$pricing_items = !empty($each_items['pricing_items']) ? $each_items['pricing_items'] : '';
											$pricing_curency = !empty($each_items['pricing_curency']) ? $each_items['pricing_curency'] : '';
											$pricing_amount = !empty($each_items['pricing_amount']) ? $each_items['pricing_amount'] : '';
											$pricing_title = !empty($each_items['pricing_title']) ? $each_items['pricing_title'] : '';

											$image_url = wp_get_attachment_url($each_items['pricing_image']['id']);
											$image_alt = get_post_meta($each_items['pricing_image']['id'], '_wp_attachment_image_alt', true);


											$active_tabs = !empty($each_items['active_tabs']) ? $each_items['active_tabs'] : '';

											if ($active_tabs ==  true) {
												$active_class = 'active';
											} else {
												$active_class = 'not-active';
											}

									?>
											<div id="<?php echo esc_attr($tab_id); ?>" class="tab-pane <?php echo esc_attr($active_class); ?>">
												<div class="row">
													<div class="col-lg-12 col-md-12 col-12">
														<div class="pricing-wrap">
															<div class="pricing-single">
																<div class="pricing-img pricing-img-<?php echo esc_attr($tab_id); ?>">
																	<div class="pricing-text">
																		<span>
																			<small>
																				<?php echo esc_html($pricing_curency); ?></small>
																			<?php echo esc_html($pricing_amount); ?>
																		</span>
																		<h4><?php echo esc_html($pricing_title); ?></h4>
																		<p><?php echo esc_html($pricing_items); ?></p>
																	</div>
																	<img src="<?php echo esc_url($image_url); ?>" alt="<?php echo esc_attr($image_alt); ?>">
																</div>
															</div>
														</div>
													</div>
												</div>
											</div>
									<?php }
									} ?>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
<?php
		// Return outbut buffer
		echo ob_get_clean();
	}
	/**
	 * Render Pricing widget output in the editor.
	 * Written as a Backbone JavaScript template and used to generate the live preview.
	 */

	//protected function _content_template(){}

}
Plugin::instance()->widgets_manager->register(new Apeix_Pricing());
