<?php
/*
 * Elementor Apeix Feature Widget
 * Author & Copyright: wpoceans
*/

namespace Elementor;

if (!defined('ABSPATH')) exit; // Exit if accessed directly

class Apeix_Feature extends Widget_Base
{

	/**
	 * Retrieve the widget name.
	 */
	public function get_name()
	{
		return 'wpo-apeix_feature';
	}

	/**
	 * Retrieve the widget title.
	 */
	public function get_title()
	{
		return esc_html__('Feature', 'apeix-core');
	}

	/**
	 * Retrieve the widget icon.
	 */
	public function get_icon()
	{
		return 'eicon-radio';
	}

	/**
	 * Retrieve the list of categories the widget belongs to.
	 */
	public function get_categories()
	{
		return ['wpoceans-category'];
	}

	/**
	 * Retrieve the list of scripts the Apeix Feature widget depended on.
	 * Used to set scripts dependencies required to run the widget.
	 */
	public function get_script_depends()
	{
		return ['wpo-apeix_feature'];
	}

	/**
	 * Register Apeix Feature widget controls.
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 */
	protected function register_controls()
	{

		$this->start_controls_section(
			'section_feature',
			[
				'label' => esc_html__('Feature Options', 'apeix-core'),
			]
		);

		$repeater = new Repeater();
		$repeater->add_control(
			'feature_title',
			[
				'label' => esc_html__('Title Text', 'apeix-core'),
				'type' => Controls_Manager::TEXT,
				'default' => esc_html__('Choose Your Service', 'apeix-core'),
				'placeholder' => esc_html__('Type title text here', 'apeix-core'),
				'label_block' => true,
			]
		);
		$repeater->add_control(
			'feature_content',
			[
				'label' => esc_html__('Content Text', 'apeix-core'),
				'type' => Controls_Manager::TEXT,
				'default' => esc_html__('Content.', 'apeix-core'),
				'placeholder' => esc_html__('Type content text here', 'apeix-core'),
				'label_block' => true,
			]
		);
		$repeater->add_control(
			'feature_icon',
			[
				'label' => __('Icon', 'apeix-core'),
				'type' => \Elementor\Controls_Manager::ICONS,
				'default' => [
					'value' => 'flaticon-turbo',
					'library' => 'solid',
				],
			]
		);
		$this->add_control(
			'featureItems_groups',
			[
				'label' => esc_html__('Feature Icons', 'apeix-core'),
				'type' => Controls_Manager::REPEATER,
				'default' => [
					[
						'feature_title' => esc_html__('Feature', 'apeix-core'),
					],

				],
				'fields' =>  $repeater->get_controls(),
				'title_field' => '{{{ feature_title }}}',
			]
		);
		$this->end_controls_section(); // end: Section


		// Title
		$this->start_controls_section(
			'section_title_style',
			[
				'label' => esc_html__('Title', 'apeix-core'),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'label' => esc_html__('Typography', 'apeix-core'),
				'name' => 'apeix_title_typography',
				'selector' => '{{WRAPPER}} .service-style-1.service-details-what-we-do .service-wrap .service-text h2',
			]
		);
		$this->add_control(
			'title_color',
			[
				'label' => esc_html__('Color', 'apeix-core'),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .service-style-1.service-details-what-we-do .service-wrap .service-text h2' => 'color: {{VALUE}};',
				],
			]
		);
		$this->add_control(
			'title_padding',
			[
				'label' => __('Title Padding', 'apeix-core'),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', 'em'],
				'selectors' => [
					'{{WRAPPER}} .service-style-1.service-details-what-we-do .service-wrap .service-text h2' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		$this->end_controls_section(); // end: Section

		// Content
		$this->start_controls_section(
			'section_content_style',
			[
				'label' => esc_html__('Content', 'apeix-core'),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'label' => esc_html__('Typography', 'apeix-core'),
				'name' => 'section_content_typography',
				'selector' => '{{WRAPPER}} .service-style-1.service-details-what-we-do .service-wrap .service-text p',
			]
		);
		$this->add_control(
			'content_color',
			[
				'label' => esc_html__('Color', 'apeix-core'),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .service-style-1.service-details-what-we-do .service-wrap .service-text p' => 'color: {{VALUE}};',
				],
			]
		);
		$this->end_controls_section(); // end: Section

		// Feature Icons
		$this->start_controls_section(
			'section_feature_icon_section_style',
			[
				'label' => esc_html__('Icon', 'apeix-core'),
				'tab' => Controls_Manager::TAB_STYLE,
			]

		);
		$this->add_control(
			'feature_item_icon_color',
			[
				'label' => esc_html__('Color', 'apeix-core'),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .service-style-1.service-details-what-we-do .service-wrap i:before' => 'color: {{VALUE}};',
				],
			]
		);
		$this->end_controls_section(); // end: Section



	}

	/**
	 * Render Feature widget output on the frontend.
	 * Written in PHP and used to generate the final HTML.
	 */
	protected function render()
	{
		$settings = $this->get_settings_for_display();
		$featureItems_groups = !empty($settings['featureItems_groups']) ? $settings['featureItems_groups'] : [];

		ob_start(); ?>
		<div class="apeix-features service-style-1 service-details-what-we-do ">
			<div class="row no-gutters">
				<?php
				// Group Param Output
				if (is_array($featureItems_groups) && !empty($featureItems_groups)) {
					foreach ($featureItems_groups as $each_item) {

						$feature_title = !empty($each_item['feature_title']) ? $each_item['feature_title'] : '';
						$feature_content = !empty($each_item['feature_content']) ? $each_item['feature_content'] : '';

						$feature_icon = !empty($each_item['feature_icon']['value']) ? $each_item['feature_icon']['value'] : '';
						$feature_svg_url = !empty($each_item['feature_icon']['value']['url']) ? $each_item['feature_icon']['value']['url'] : '';
						$svg_alt = get_post_meta($feature_svg_url, '_wp_attachment_image_alt', true);


				?>
						<div class="col-md-4 col-sm-6">
							<div class="service-wrap">
								<div class="service-icon">
									<?php if ($feature_svg_url) {
										echo '<img src="' . esc_url($feature_svg_url) . '" alt="' . esc_url($svg_alt) . '">';
									} else {
										echo ' <i class="' . esc_attr($feature_icon) . '"></i>';
									} ?>
								</div>
								<div class="service-text">
									<?php
									if ($feature_title) {
										echo '<h2>' . esc_html($feature_title) . '</h2>';
									}
									if ($feature_content) {
										echo '<p>' . esc_html($feature_content) . '</p>';
									}
									?>
								</div>
							</div>
						</div>
				<?php }
				} ?>
			</div>
		</div>
<?php
		// Return outbut buffer
		echo ob_get_clean();
	}
	/**
	 * Render Feature widget output in the editor.
	 * Written as a Backbone JavaScript template and used to generate the live preview.
	 */

	//protected function _content_template(){}

}
Plugin::instance()->widgets_manager->register_widget_type(new Apeix_Feature());
