<?php
/*
 * Elementor Apeix Contact Form 7 Widget
 * Author & Copyright: wpoceans
*/

namespace Elementor;

if (!defined('ABSPATH')) exit; // Exit if accessed directly

class Apeix_Contact_Form extends Widget_Base
{

	/**
	 * Retrieve the widget name.
	 */
	public function get_name()
	{
		return 'tmx-apeix_contact_form';
	}

	/**
	 * Retrieve the widget title.
	 */
	public function get_title()
	{
		return esc_html__('Contact Form', 'apeix-core');
	}

	/**
	 * Retrieve the widget icon.
	 */
	public function get_icon()
	{
		return 'eicon-form-horizontal';
	}

	/**
	 * Retrieve the list of categories the widget belongs to.
	 */
	public function get_categories()
	{
		return ['wpoceans-category'];
	}

	/**
	 * Retrieve the list of scripts the Apeix Contact Form widget depended on.
	 * Used to set scripts dependencies required to run the widget.
	 */
	/*
	public function get_script_depends() {
		return ['tmx-apeix_contact_form'];
	}
	 */

	/**
	 * Register Apeix Contact Form widget controls.
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 */
	protected function register_controls()
	{

		$this->start_controls_section(
			'section_contact_form',
			[
				'label' => esc_html__('Form Options', 'apeix-core'),
			]
		);
		$this->add_control(
			'section_title',
			[
				'label' => esc_html__('Title Text', 'apeix-core'),
				'type' => Controls_Manager::TEXT,
				'default' => esc_html__('Title Text', 'apeix-core'),
				'placeholder' => esc_html__('Type title text here', 'apeix-core'),
				'label_block' => true,
			]
		);
		$this->add_control(
			'form_image',
			[
				'label' => esc_html__('Form Image', 'apeix-core'),
				'type' => Controls_Manager::MEDIA,
				'frontend_available' => true,
				'default' => [
					'url' => Utils::get_placeholder_image_src(),
				],
				'description' => esc_html__('Set your image.', 'apeix-core'),
			]
		);
		$this->add_control(
			'form_id',
			[
				'label' => esc_html__('Select contact form', 'apeix-core'),
				'type' => Controls_Manager::SELECT,
				'options' => Controls_Helper_Output::get_posts('wpcf7_contact_form'),
			]
		);
		$this->end_controls_section(); // end: Section


		// Title
		$this->start_controls_section(
			'section_title_style',
			[
				'label' => esc_html__('Title', 'apeix-core'),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'label' => esc_html__('Typography', 'apeix-core'),
				'name' => 'apeix_title_typography',
				'selector' => '{{WRAPPER}} .hx-contact-area .hx-contact-content h2',
			]
		);
		$this->add_control(
			'title_color',
			[
				'label' => esc_html__('Color', 'apeix-core'),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .hx-contact-area .hx-contact-content h2' => 'color: {{VALUE}};',
				],
			]
		);
		$this->add_control(
			'title_padding',
			[
				'label' => esc_html__('Title Padding', 'apeix-core'),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', 'em'],
				'selectors' => [
					'{{WRAPPER}} .hx-contact-area .hx-contact-content h2' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		$this->end_controls_section(); // end: Section


		// Form Style

		$this->start_controls_section(
			'section_form_style',
			[
				'label' => esc_html__('Form', 'apeix-core'),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'form_typography',
				'selector' => '{{WRAPPER}} .hx-contact-content .hx-contact-form input[type="text"], 
				{{WRAPPER}} .hx-contact-content .hx-contact-form input[type="email"], 
				{{WRAPPER}} .hx-contact-content .hx-contact-form input[type="date"], 
				{{WRAPPER}} .hx-contact-content .hx-contact-form input[type="time"], 
				{{WRAPPER}} .hx-contact-content .hx-contact-form input[type="number"], 
				{{WRAPPER}} .hx-contact-content .hx-contact-form textarea, 
				{{WRAPPER}} .hx-contact-content .hx-contact-form select, 
				{{WRAPPER}} .hx-contact-content .hx-contact-form .form-control, 
				{{WRAPPER}} .track-contact .track-trace select, 
				{{WRAPPER}} .track-contact .track-trace input',
			]
		);
		$this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name' => 'form_border',
				'label' => esc_html__('Border', 'apeix-core'),
				'selector' => '{{WRAPPER}} .hx-contact-content .hx-contact-form input[type="text"], 
				{{WRAPPER}} .hx-contact-content .hx-contact-form input[type="email"], 
				{{WRAPPER}} .hx-contact-content .hx-contact-forminput[type="date"], 
				{{WRAPPER}} .hx-contact-content .hx-contact-form input[type="time"], 
				{{WRAPPER}} .hx-contact-content .hx-contact-form input[type="number"], 
				{{WRAPPER}} .hx-contact-content .hx-contact-form textarea, 
				{{WRAPPER}} .hx-contact-content .hx-contact-form select, 
				{{WRAPPER}} .hx-contact-content .hx-contact-form .form-control, 
				{{WRAPPER}} .hx-contact-content .hx-contact-form .nice-select,
				{{WRAPPER}} .track-contact .track-trace select, 
				{{WRAPPER}} .track-contact .track-trace input',

			]
		);
		$this->add_control(
			'placeholder_text_color',
			[
				'label' => __('Placeholder Text Color', 'apeix-core'),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .hx-contact-content .hx-contact-form input:not([type="submit"])::-webkit-input-placeholder' => 'color: {{VALUE}} !important;',
					'{{WRAPPER}} .hx-contact-content .hx-contact-form input:not([type="submit"])::-moz-placeholder' => 'color: {{VALUE}} !important;',
					'{{WRAPPER}} .hx-contact-content .hx-contact-form input:not([type="submit"])::-ms-input-placeholder' => 'color: {{VALUE}} !important;',
					'{{WRAPPER}} .hx-contact-content .hx-contact-form input:not([type="submit"])::-o-placeholder' => 'color: {{VALUE}} !important;',
					'{{WRAPPER}} .hx-contact-content .hx-contact-form textarea::-webkit-input-placeholder' => 'color: {{VALUE}} !important;',
					'{{WRAPPER}} .hx-contact-content .hx-contact-form textarea::-moz-placeholder' => 'color: {{VALUE}} !important;',
					'{{WRAPPER}} .hx-contact-content .hx-contact-form textarea::-ms-input-placeholder' => 'color: {{VALUE}} !important;',
					'{{WRAPPER}} .hx-contact-content .hx-contact-form textarea::-o-placeholder' => 'color: {{VALUE}} !important;',
					'{{WRAPPER}} .track-contact .track-trace input::-webkit-input-placeholder' => 'color: {{VALUE}} !important;',
					'{{WRAPPER}} .track-contact .track-trace select::-webkit-input-placeholder' => 'color: {{VALUE}} !important;',
				],
			]
		);
		$this->add_control(
			'label_color',
			[
				'label' => __('Label Color', 'apeix-core'),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .hx-contact-content .hx-contact-form label' => 'color: {{VALUE}} !important;',
				],
			]
		);
		$this->add_control(
			'text_color',
			[
				'label' => __('Text Color', 'apeix-core'),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .hx-contact-content .hx-contact-form input[type="text"], 
					{{WRAPPER}} .hx-contact-content .hx-contact-form input[type="email"], 
					{{WRAPPER}} .hx-contact-content .hx-contact-form input[type="date"], 
					{{WRAPPER}} .hx-contact-content .hx-contact-form input[type="time"], 
					{{WRAPPER}} .hx-contact-content .hx-contact-form input[type="number"], 
					{{WRAPPER}} .hx-contact-content .hx-contact-form textarea, 
					{{WRAPPER}} .hx-contact-content .hx-contact-form select, 
					{{WRAPPER}} .hx-contact-content .hx-contact-form .form-control, 
					{{WRAPPER}} .track-contact .track-trace input, 
					{{WRAPPER}} .hx-contact-content .hx-contact-form .nice-select' => 'color: {{VALUE}} !important;',
				],
			]
		);
		$this->end_controls_section(); // end: Section

		$this->start_controls_section(
			'section_button_style',
			[
				'label' => esc_html__('Button', 'apeix-core'),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'button_typography',
				'selector' => '{{WRAPPER}} .hx-contact-content .hx-contact-form .wpcf7-form-control.wpcf7-submit,.track-contact .track-trace .wpcf7-submit.submit-btn',
			]
		);
		$this->add_responsive_control(
			'btn_width',
			[
				'label' => esc_html__('Width', 'apeix-core'),
				'type' => Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 1000,
						'step' => 1,
					],
				],
				'size_units' => ['px', '%'],
				'selectors' => [
					'{{WRAPPER}} .hx-contact-content .hx-contact-form .wpcf7-form-control.wpcf7-submit,.track-contact .track-trace .wpcf7-submit.submit-btn' => 'min-width: {{SIZE}}{{UNIT}};',
				],
			]
		);
		$this->add_control(
			'btn_margin',
			[
				'label' => __('Margin', 'apeix-core'),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', 'em'],
				'selectors' => [
					'{{WRAPPER}} .hx-contact-content .hx-contact-form .wpcf7-form-control.wpcf7-submit,.track-contact .track-trace .wpcf7-submit.submit-btn' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		$this->add_control(
			'button_border_radius',
			[
				'label' => __('Border Radius', 'apeix-core'),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', '%', 'em'],
				'selectors' => [
					'{{WRAPPER}} .hx-contact-content .hx-contact-form .wpcf7-form-control.wpcf7-submit,.track-contact .track-trace .wpcf7-submit.submit-btn' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		$this->start_controls_tabs('button_style');
		$this->start_controls_tab(
			'button_normal',
			[
				'label' => esc_html__('Normal', 'apeix-core'),
			]
		);
		$this->add_control(
			'button_color',
			[
				'label' => esc_html__('Color', 'apeix-core'),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .hx-contact-content .hx-contact-form .wpcf7-form-control.wpcf7-submit,.track-contact .track-trace .wpcf7-submit.submit-btn' => 'color: {{VALUE}};',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Background::get_type(),
			[
				'name' => 'button_bg_color',
				'label' => esc_html__('Button BG Color', 'apeix-core'),
				'types' => ['gradient'],
				'selector' => '{{WRAPPER}} .hx-contact-content .hx-contact-form .wpcf7-form-control.wpcf7-submit',
			]
		);
		$this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name' => 'button_border',
				'label' => esc_html__('Border', 'apeix-core'),
				'selector' => '{{WRAPPER}} .hx-contact-content .hx-contact-form .wpcf7-form-control.wpcf7-submit,.track-contact .track-trace .wpcf7-submit.submit-btn',
			]
		);
		$this->end_controls_tab();  // end:Normal tab

		$this->start_controls_tab(
			'button_hover',
			[
				'label' => esc_html__('Hover', 'apeix-core'),
			]
		);
		$this->add_control(
			'button_hover_color',
			[
				'label' => esc_html__('Color', 'apeix-core'),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .hx-contact-content .hx-contact-form .wpcf7-form-control.wpcf7-submit:hover,.track-contact .track-trace .wpcf7-submit.submit-btn:hover' => 'color: {{VALUE}};',
				],
			]
		);
		$this->add_control(
			'button_bg_hover_color',
			[
				'label' => esc_html__('Background Color', 'apeix-core'),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .hx-contact-content .hx-contact-form .wpcf7-form-control.wpcf7-submit:hover,.track-contact .track-trace .wpcf7-submit.submit-btn:hover' => 'background-color: {{VALUE}};',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name' => 'button_hover_border',
				'label' => esc_html__('Border', 'apeix-core'),
				'selector' => '{{WRAPPER}} .hx-contact-content .hx-contact-form .wpcf7-form-control.wpcf7-submit:hover,.track-contact .track-trace .wpcf7-submit.submit-btn:hover',
			]
		);
		$this->end_controls_tab();  // end:Hover tab
		$this->end_controls_tabs(); // end tabs

		$this->end_controls_section(); // end: Section



	}

	/**
	 * Render Contact Form widget output on the frontend.
	 * Written in PHP and used to generate the final HTML.
	 */
	protected function render()
	{
		$settings = $this->get_settings_for_display();
		$section_title = !empty($settings['section_title']) ? $settings['section_title'] : '';
		$form_id = !empty($settings['form_id']) ? $settings['form_id'] : '';

		$bg_image = !empty($settings['form_image']['id']) ? $settings['form_image']['id'] : '';
		// Image
		$image_url = wp_get_attachment_url($bg_image);
		$image_alt = get_post_meta($bg_image, '_wp_attachment_image_alt', true);

		// Turn output buffer on
		ob_start(); ?>
		<div class="hx-contact-area">
			<div class="row">
				<div class="col col-md-7 col-sm-12 col-12">
					<div class="hx-contact-content">
						<?php if ($section_title) {
							echo '<h2>' . esc_html($section_title) . '</h2>';
						} ?>
						<div class="hx-contact-form">
							<?php echo do_shortcode('[contact-form-7 id="' . $form_id . '"]'); ?>
						</div>
					</div>
				</div>
				<div class="col-md-5">
					<div class="hx-contact-img">
						<?php if ($image_url) {
							echo '<img src="' . esc_url($image_url) . '" alt="' . esc_url($image_alt) . '">';
						} ?>
					</div>
				</div>
			</div>
		</div>
<?php
		// Return outbut buffer
		echo ob_get_clean();
	}



	/**
	 * Render Contact Form widget output in the editor.
	 * Written as a Backbone JavaScript template and used to generate the live preview.
	 */

	//protected function _content_template(){}

}
Plugin::instance()->widgets_manager->register(new Apeix_Contact_Form());
